package com.bcxin.ins.util;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.mybatisplus.toolkit.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 字典工具类
 * @author ThinkGem
 * @version 2013-5-29
 */
public class RegionUtils {
	


	public static List<ComRegion> regionList = new ArrayList<ComRegion>();
	public static List<ComRegion> p_regionList = new ArrayList<ComRegion>();
	public static List<ComRegion> c_regionList = new ArrayList<ComRegion>();
	public static List<ComRegion> a_regionList = new ArrayList<ComRegion>();

	/**
	 * 根据区域代码获取对应名称
	 * @param code
	 * @return
	 */
	public static String getRegionNameByCode(String code){
		if(StringUtils.isEmpty(code)){
			return "";
		}
		if(code.endsWith("0000")){
			return getNameforEachRegionList(p_regionList,code);
		}else if(code.endsWith("00")){
			return getNameforEachRegionList(c_regionList,code);
		}else {
			return getNameforEachRegionList(a_regionList,code);
		}
	}

	private static String getNameforEachRegionList(List<ComRegion> list,String code){
		for (ComRegion region : list){
			if(region.getCodes().equals(code)){
				return region.getNamed();
			}
		}
		return "";
	}

	private static ComRegion getRegionforEachRegionList(List<ComRegion> list,String code){
		for (ComRegion region : list){
			if(region.getCodes().equals(code)){
				return region;
			}
		}
		return null;
	}

	/**
	 * 根据区域代码获取对应名称(如果出现“市辖区”，转成省名称)
	 * @param code
	 * @return
	 */
	public static String getRegionNameByCodeTS(String code){
		for (ComRegion region : regionList){
			if(!region.getCodes().equals(code)){
				continue;
			}
			if("市辖区".equals(region.getNamed())){
				for (ComRegion pRegion : regionList){
					if(pRegion.getCodes().equals(region.getParent_id())){
						return pRegion.getNamed();
					}
				}
			}
			return region.getNamed();
		}
		return "";
	}

	/**
	 * 根据区域代码获取对应区域数据信息
	 * @param code
	 * @return
	 */
	public static ComRegion getComRegionByCode(String code){
		if(StringUtils.isEmpty(code)){
			return null;
		}
		if(code.endsWith("0000")){
			return getRegionforEachRegionList(p_regionList,code);
		}else if(code.endsWith("00")){
			return getRegionforEachRegionList(c_regionList,code);
		}else {
			return getRegionforEachRegionList(a_regionList,code);
		}
	}

	public static List<ComRegion> findDistrictByParentCode(String codeLevel, String parentCode){
		if(StringUtils.isEmpty(codeLevel) && StringUtils.isEmpty(parentCode)){
			return regionList;
		}
		List<ComRegion> toDoList = new ArrayList<ComRegion>();
		if(StringUtils.isNotEmpty(codeLevel) && StringUtils.isEmpty(parentCode)){
			return ConstProp.DIGIT_ONE.equals(codeLevel)?p_regionList
					:ConstProp.DIGIT_TWO.equals(codeLevel)?c_regionList
					:ConstProp.DIGIT_THREE.equals(codeLevel)?a_regionList
					:toDoList;
		}
		if(StringUtils.isNotEmpty(parentCode)&&StringUtils.isEmpty(codeLevel)){
			return regionList.stream()
					.filter(e -> parentCode.contains(e.getParent_id()))
					.collect(Collectors.toList());
		}
		if(ConstProp.DIGIT_ONE.equals(codeLevel)){
			return p_regionList.stream()
					.filter(e -> parentCode.contains(e.getParent_id()))
					.collect(Collectors.toList());
		}else if(ConstProp.DIGIT_TWO.equals(codeLevel)){
			return c_regionList.stream()
					.filter(e -> parentCode.contains(e.getParent_id()))
					.collect(Collectors.toList());
		}else if(ConstProp.DIGIT_THREE.equals(codeLevel)){
			return a_regionList.stream()
					.filter(e -> parentCode.contains(e.getParent_id()))
					.collect(Collectors.toList());
		}
		return toDoList;
	}

	/**
	 * 通过传入省市区代码返回省市区中文组装字符串（如：福建省厦门市集美区）
	 * @param pro
	 * @param cit
	 * @param are
	 * @return
	 */
	public static String getRegionNameByALLCode(String pro, String cit, String are){
		String result = "";

		if(StringUtils.isNotEmpty(are)){
			return getRegionName(are);
		}
		if(StringUtils.isNotEmpty(cit)){
			return getRegionName(cit);
		}
		if(StringUtils.isNotEmpty(pro)){
			return getRegionName(pro);
		}
		return result;
	}

	private static String getRegionName(String are) {
		ComRegion rg = getComRegionByCode(are);
		if(rg != null&& StringUtils.isNotEmpty(rg.getNamed_path())){
			return rg.getNamed_path().replace("->","");
        }
		return "";
	}
}
