package com.bcxin.ins.enums;

/**
 * <b> 接口类型枚举 </b>
 * @author ZXF
 * @create 2018/05/28 0028 10:09
 * @version
 * @注意事项 </b>
 */
public enum TransTypeEnum {
	HB("1", "核保")
	,PD("2", "批单")
	,HDCB("3", "承保回调")
	,HDZF("4", "批单支付回调")
	,ZFDZ("5", "获取支付地址")
	,ZFJG("6", "支付结果获取")
	,DZFP("7", "电子发票申请")
	,DZBD("8", "电子保单获取")
	,CBXX("9", "承保信息获取")
	,TB("10", "退保")
	,ZX("11", "注销")
	,PDQR("12", "批单确认（平安财增加员用）")
	,DZPD("13", "电子批单获取")
	,BASL("15", "报案受理")
	,AJCX("16", "案件查询")
	,CLSC("17", "材料上传")
	,XXAJCX("18", "同步线下案件查询")
	,CBQR("19", "承保确认")
	,PDJG("20", "批单结果查询")
	,XXCB("21", "线下承保回调")
	,PDDZFP("22", "批单电子发票查询")
	,FPSQ("23", "电子发票申请")
	,ZXPG("24", "最新批改查询")
	,TOB("25", "投保")
	,PDZF("26", "获取批单支付地址")
	,PDZFCX("27", "批单支付撤销")
	,DZFPXZ("28", "电子发票下载");

	private String value;
	private String name;

	private TransTypeEnum(String value, String name){
		this.value = value;
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public static TransTypeEnum convert_value(String value){
		if ("1".equals(value)) {
			return TransTypeEnum.HB;
		}else if ("2".equals(value)) {
			return TransTypeEnum.PD;
		}
		return null;
	}

	public static String getAlias(String value){
		for(TransTypeEnum e : TransTypeEnum.values()){
			if(e.getValue().equals(value)){
				return e.getName();
			}
		}
		return "";
	}
}
