package com.bcxin.ins.enums;

/**
 * 订单状态枚举
 * @author hzp
 * @date 2018/06/12
 */
public enum OrderStatusEnum {
    //投保中
    INSURING("1","投保中"),
    //待核保
    CHECKING_INSURED("2","待核保"),
    //已核保
    INSURED("3","已核保"),
    //待支付
    UN_PAY("4","待支付"),
    //待承保
    UNDERWRITEING("5","待承保"),
    //已承保
    UNDERWRITED("6","已承保"),
    //已出单
    OUT_ORDER("7","已出单"),
    //已配送
    DELIVERED("8","已配送"),
    //撤单申请中
    ORDER_CANCEL_APPLY("9","撤单申请中"),
    //已撤单
    ORDER_CANCELED("10","已撤单"),
    //已退款
    REFUNDED("11","已退款"),
    //已过期
    EXPIRED("12","已过期"),
    //已废弃
    DISCARD("13","已废弃"),
    //已取消
    CANCELED("14","已取消"),
    //已拒保
    REFUSED("15","已拒保"),
    //保障中
    GUARANTEE("21","保障中"),
    //已购买
    PAYED("23","已购买"),
    //已失效
    INVALID("24","已失效");

    private String key;
    private String alias;

    private OrderStatusEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey() {
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(OrderStatusEnum e : OrderStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
