package com.bcxin.ins.entity.policy_core;

import com.bcxin.ins.core.base.entity.DataEntity;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * <b>承保信息表 </b>
 * 
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@TableName("ins_underwrite")
public class InsUnderwrite implements Serializable {


	@TableId(type = IdType.ID_WORKER)
	private Long underwrite_id;

	/**
	 * 核销内码
	 */
	@TableField(value = "idx")
	private Long idx;

	/**
	 * 代码（外码）
	 */
	@TableField(value = "code")
	private String code;

	/**
	 * 核销外码
	 */
	@TableField(value = "codex")
	private String codex;

	@TableField(value = "remarks")
	private String remarks;	// 备注

	@TableField(value = "create_by",el="create_by.id")
	private SysUser create_by;	// 创建者

	@TableField(value = "create_time")
	private Date create_time;	// 创建日期

	@TableField(value = "update_by",el="update_by.id")
	private SysUser update_by;	// 更新者

	@TableField(value = "update_time")
	private Date update_time;	// 更新日期

	@TableField(value = "status")
	protected Integer status; 	//

	@TableField(value = "company_id",el="sysCompany.company_id")
	protected SysCompany sysCompany;

	/**
	* 核保日期
	*/
	@TableField(value = "underwrite_time")
	private Date underwrite_time;
	/**
	* 保险期限
	*/
	@TableField(value = "deadline")
	private String deadline;
	/**
	* 保险责任
	*/
	@TableField(value = "insurance_duty")
	private String insurance_duty;
	/**
	* 保险金额	*/
	@TableField(value = "insurance_amount")
	private BigDecimal insurance_amount;
	/**
	 * 承保范围
	 */
	@TableField(value = "coverage")
	private String coverage;
	/**
	* 可保营业额
	*/
	@TableField(value = "business_volume")
	private BigDecimal business_volume;
	/**
	* 最高赔偿限额
	*/
	@TableField(value = "insurance_amount_max")
	private String insurance_amount_max;
	/**
	* 逾期欠款通知最后期限
	*/
	@TableField(value = "balance_overdue_deadline")
	private String balance_overdue_deadline;
	/**
	* 开票期限
	*/
	@TableField(value = "make_invoice_deadline")
	private String make_invoice_deadline;
	/**
	* 营业额申报期限
	*/
	@TableField(value = "declare_time")
	private String declare_time;
	/**
	* 特殊条件
	*/
	@TableField(value = "special_if")
	private String special_if;
	/**
	* 备注
	*/
	@TableField(value = "underwrite_remark")
	private String underwrite_remark;
	/**
	* 总保险费率
	*/
	@TableField(value = "total_rate")
	private BigDecimal total_rate;
	/**
	* 保费缴纳方式
	*/
	@TableField(value = "payment_way")
	private String payment_way;
	/**
	* 预计年度保费
	*/
	@TableField(value = "year_premium")
	private BigDecimal year_premium;
	/**
	* 信用限额调查费
	*/
	@TableField(value = "credit_credit_fee")
	private BigDecimal credit_credit_fee;
	/**
	* 初始保费
	*/
	@TableField(value = "initial_premium")
	private BigDecimal initial_premium;
	/**
	* 承保时间
	*/
	@TableField(value = "acceptance_time")
	private Date acceptance_time;

	public InsUnderwrite(Long id){
		this.underwrite_id = id;
	}
	public InsUnderwrite(){

	}

	public Long getUnderwrite_id() {
		return underwrite_id;
	}

	public void setUnderwrite_id(Long underwrite_id) {
		this.underwrite_id = underwrite_id;
	}

	public Long getIdx() {
		return idx;
	}

	public void setIdx(Long idx) {
		this.idx = idx;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCodex() {
		return codex;
	}

	public void setCodex(String codex) {
		this.codex = codex;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public SysUser getCreate_by() {
		return create_by;
	}

	public void setCreate_by(SysUser create_by) {
		this.create_by = create_by;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreate_time() {
		return create_time;
	}

	public void setCreate_time(Date create_time) {
		this.create_time = create_time;
	}

	public SysUser getUpdate_by() {
		return update_by;
	}

	public void setUpdate_by(SysUser update_by) {
		this.update_by = update_by;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getUpdate_time() {
		return update_time;
	}

	public void setUpdate_time(Date update_time) {
		this.update_time = update_time;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public SysCompany getSysCompany() {
		return sysCompany;
	}

	public void setSysCompany(SysCompany sysCompany) {
		this.sysCompany = sysCompany;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getUnderwrite_time() {
		return underwrite_time;
	}

	public void setUnderwrite_time(Date underwrite_time) {
		this.underwrite_time = underwrite_time;
	}

	public String getDeadline() {
		return deadline;
	}

	public void setDeadline(String deadline) {
		this.deadline = deadline;
	}

	public String getInsurance_duty() {
		return insurance_duty;
	}

	public void setInsurance_duty(String insurance_duty) {
		this.insurance_duty = insurance_duty;
	}

	public BigDecimal getInsurance_amount() {
		return insurance_amount;
	}

	public void setInsurance_amount(BigDecimal insurance_amount) {
		this.insurance_amount = insurance_amount;
	}

	public String getCoverage() {
		return coverage;
	}

	public void setCoverage(String coverage) {
		this.coverage = coverage;
	}

	public BigDecimal getBusiness_volume() {
		return business_volume;
	}

	public void setBusiness_volume(BigDecimal business_volume) {
		this.business_volume = business_volume;
	}

	public String getInsurance_amount_max() {
		return insurance_amount_max;
	}

	public void setInsurance_amount_max(String insurance_amount_max) {
		this.insurance_amount_max = insurance_amount_max;
	}

	public String getBalance_overdue_deadline() {
		return balance_overdue_deadline;
	}

	public void setBalance_overdue_deadline(String balance_overdue_deadline) {
		this.balance_overdue_deadline = balance_overdue_deadline;
	}

	public String getMake_invoice_deadline() {
		return make_invoice_deadline;
	}

	public void setMake_invoice_deadline(String make_invoice_deadline) {
		this.make_invoice_deadline = make_invoice_deadline;
	}

	public String getDeclare_time() {
		return declare_time;
	}

	public void setDeclare_time(String declare_time) {
		this.declare_time = declare_time;
	}

	public String getSpecial_if() {
		return special_if;
	}

	public void setSpecial_if(String special_if) {
		this.special_if = special_if;
	}

	public String getUnderwrite_remark() {
		return underwrite_remark;
	}

	public void setUnderwrite_remark(String underwrite_remark) {
		this.underwrite_remark = underwrite_remark;
	}

	public BigDecimal getTotal_rate() {
		return total_rate;
	}

	public void setTotal_rate(BigDecimal total_rate) {
		this.total_rate = total_rate;
	}

	public String getPayment_way() {
		return payment_way;
	}

	public void setPayment_way(String payment_way) {
		this.payment_way = payment_way;
	}

	public BigDecimal getYear_premium() {
		return year_premium;
	}

	public void setYear_premium(BigDecimal year_premium) {
		this.year_premium = year_premium;
	}

	public BigDecimal getCredit_credit_fee() {
		return credit_credit_fee;
	}

	public void setCredit_credit_fee(BigDecimal credit_credit_fee) {
		this.credit_credit_fee = credit_credit_fee;
	}

	public BigDecimal getInitial_premium() {
		return initial_premium;
	}

	public void setInitial_premium(BigDecimal initial_premium) {
		this.initial_premium = initial_premium;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAcceptance_time() {
		return acceptance_time;
	}

	public void setAcceptance_time(Date acceptance_time) {
		this.acceptance_time = acceptance_time;
	}
}