package com.bcxin.ins.entity.policy_core;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 保全申请单表
 */
@Data
@TableName("ins_preservation_record")
public class InsPreservationRecord implements Serializable {

    /**
     * id
     */
    @TableId(type = IdType.ID_WORKER)
    private Long ins_preservation_record_id;

    /**
     * 归属用户id
     */
    @TableField(value = "sys_client_user_id")
    private Long sys_client_user_id;

    /**
     * 保单id
     */
    @TableField(value = "ins_insurance_slip_id")
    private Long ins_insurance_slip_id;

    /**
     * 投保人名称
     */
    @TableField(value = "app_role_name")
    private String app_role_name;

    /**
     * 批改流水号
     */
    @TableField(value = "revise_serial_number")
    private String revise_serial_number;

    /**
     * 批改单号
     */
    @TableField(value = "revise_serial_num_ins")
    private String revise_serial_num_ins;

    /**
     * 批改类型
     */
    @TableField(value = "revise_type")
    private String revise_type;

    /**
     * 批改状态
     */
    @TableField(value = "revise_status")
    private String revise_status;

    /**
     * 保单号
     */
    @TableField(value = "external_reference")
    private String external_reference;

    /**
     * 生效日期
     */
    @TableField(value = "inception_date")
    private Date inception_date;

    /**
     * 失效日期
     */
    @TableField(value = "planned_end_date")
    private Date planned_end_date;

    /**
     * 保险公司id
     */
    @TableField(value = "sys_ins_company_id")
    private Long sys_ins_company_id;

    /**
     * 保全缴费表id
     */
    @TableField(value = "ins_preservation_pay_id")
    private Long ins_preservation_pay_id;

    /**
     * 提交申请时间
     */
    @TableField(value = "start_time")
    private Date start_time;

    /**
     * 修改时间
     */
    @TableField(value = "update_time")
    private Date update_time;

    /**
     * 增员人数
     */
    @TableField(value = "add_count")
    private int add_count;

    /**
     * 减员人数
     */
    @TableField(value = "minus_count")
    private int minus_count;

    /**
     * 替换人数
     */
    @TableField(value = "replace_count")
    private int replace_count;

    /**
     * 批改单地址
     */
    @TableField(value = "revise_path")
    private String revise_path;

    /**
     * 批改支付地址
     */
    @TableField(value = "revise_pay")
    private String revise_pay;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 版本发布时间
     */
    @TableField(value = "release_time")
    private Date release_time;

    /**
     * 总保费
     */
    @TableField(value = "total_premium")
    private BigDecimal total_premium;

    /**
     * 是否推送标记0未推送，1已推送（针对不同平台推送保全人员时用到）
     */
    @TableField(value = "is_push")
    private Integer is_push = 0;

    /**
     * 同步业支返回的ID（存在值说明已同步业支）
     */
    @TableField(value = "record_zc_id")
    private String record_zc_id;

    @TableField(value = "e_invoice_url")
    private String e_invoice_url;//电子发票地址
}