package com.bcxin.ins.entity.policy_core;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 保全缴费表
 */
@Data
@TableName("ins_preservation_pay")
public class InsPreservationPay implements Serializable {

    /**
     * id
     */
    @TableId(type = IdType.ID_WORKER)
    private Long ins_preservation_pay_id;

    /**
     * 归属用户id
     */
    @TableField(value = "sys_client_user_id")
    private Long sys_client_user_id;

    /**
     * 订单id
     */
    @TableField(value = "ins_insurance_slip_id")
    private Long ins_insurance_slip_id;

    /**
     * 付款状态 0.待处理；1.待支付；2.待审核；3.已支付；4.暂存；5.支付中'；9.废弃
     */
    @TableField(value = "pay_status")
    private String pay_status;

    /**
     * 保单号
     */
    @TableField(value = "external_reference")
    private String external_reference;

    /**
     * 投保人名称
     */
    @TableField(value = "app_role_name")
    private String app_role_name;

    /**
     * 保险公司id
     */
    @TableField(value = "sys_ins_company_id")
    private Long sys_ins_company_id;

    /**
     * 结算开始时间
     */
    @TableField(value = "star_pay_time")
    private Date star_pay_time;

    /**
     * 结算终止时间
     */
    @TableField(value = "end_pay_time")
    private Date end_pay_time;

    /**
     * 保全单数
     */
    @TableField(value = "record_count")
    private int record_count;

    /**
     * 增员人数
     */
    @TableField(value = "add_count")
    private int add_count;

    /**
     * 减员人数
     */
    @TableField(value = "minus_count")
    private int minus_count;

    /**
     * 替换人数
     */
    @TableField(value = "replace_count")
    private int replace_count;

    /**
     * 付款通知书地址
     */
    @TableField(value = "pay_inform_path")
    private String pay_inform_path;

    /**
     * 支付凭证地址
     */
    @TableField(value = "pay_order_path")
    private String pay_order_path;

    /**
     * 支付类型6：线下支付，7：在线支付
     */
    @TableField(value = "pay_type")
    private String pay_type;

    /**
     * 支付号
     */
    @TableField(value = "pay_order_number")
    private String pay_order_number;

    /**
     * 支付地址
     */
    @TableField(value = "pay_url")
    private String pay_url;

    /**
     * 是否申请发票
     */
    @TableField(value = "is_fp")
    private int is_fp;
    /**
     * 发票地址
     */
    @TableField(value = "fp_url")
    private String fp_url;

    /**
     * 预期总保费
     */
    @TableField(value = "predict_total_amount")
    private BigDecimal predict_total_amount;

    /**
     * 实际总保费
     */
    @TableField(value = "fact_total_amount")
    private BigDecimal fact_total_amount;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;
    /**
     * 类型 0.月保单；1.月账单；2.结算单
     */
    @TableField(value = "belong_type")
    private String belong_type;
    /**
     * 上级部分账单ID
     */
    @TableField(value = "parent_part_bill_id")
    private Long parent_part_bill_id;
    /**
     * 上级账单ID
     */
    @TableField(value = "parent_bill_id")
    private Long parent_bill_id;
    /**
     * 上级结算ID
     */
    @TableField(value = "parent_foot_id")
    private Long parent_foot_id;
    /**
     * 保单号关键字（查询筛选用）
     */
    @TableField(value = "ex_keyword")
    private String ex_keyword;

    /**
     * 生成日期
     */
    @TableField(value = "build_data")
    private Date build_data;
    /**
     * 账单列
     */
    @TableField(exist = false)
    private String pay_list;

}