package com.bcxin.ins.entity.policy_core;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <b>投保订单 </b>
 *
 * @author zxf
 * @date 2017年1月5日 上午10:14:58
 * @注意事项 </b>
 * <b>
 */
@TableName("ins_insurance_slip")
public class InsInsuranceSlip implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long ins_insurance_slip_id;

    @TableField(value = "idx")
    private Long idx;

    @TableField(value = "code")
    private String code;

    @TableField(value = "codex")
    private String codex;

    @TableField(value = "remarks")
    private String remarks;	// 订单受理备注

    @TableField(value = "custom_remarks")
    private String custom_remarks;	// 自定义备注

    @TableField(value = "create_by",el="create_by.id")
    private SysUser create_by;	// 创建者

    @TableField(value = "create_time")
    private Date create_time;	// 创建日期

    @TableField(value = "update_by",el="update_by.id")
    private SysUser update_by;	// 更新者

    @TableField(value = "update_time")
    private Date update_time;	// 更新日期

    @TableField(value = "status")
    protected Integer status; 	//

    @TableField(value = "company_id",el="sysCompany.company_id")
    protected SysCompany sysCompany;

    @TableField(value = "policy_serial_number")
    private String policy_serial_number;//投保单号

    @TableField(value = "pro_primary_id",el="pro_primary.pro_primary_id")
    private ProPrimary pro_primary;

    @TableField(value = "premium")
    private BigDecimal premium;

    @TableField(value = "rate")
    private BigDecimal rate;

    @TableField(value = "unit_count")
    private Integer unit_count;

    @TableField(value = "inception_date")
    private Date inception_date;

    @TableField(value = "planned_end_date")
    private Date planned_end_date;

    @TableField(value = "signed_date")
    private Date signed_date;

    @TableField(value = "insured_amount")
    private BigDecimal insured_amount;

    @TableField(value = "trade_serial_number")
    private String trade_serial_number;

    @TableField(value = "notice_no")
    private String notice_no;
    /**
     * 保险期限类型 1按年，2按月
     */
    @TableField(value = "inception_type")
    private String inception_type;

    /**
     * 保障长度
     */
    @TableField(value = "inception_long")
    private String inception_long;

    @TableField(value = "order_status")
    private String order_status; //订单状态 1、2未完成，3已核保，4待支付，5、6已购买、其他是已失效

    /**
     * 保险公司处理用户
     */
    @TableField(value = "insurer_user_id",el="insurerUser.insurer_user_id")
    private SysUser insurerUser;

    @TableField(value = "order_user_id")
    private Long order_user_id;

    /**
     * 分销商标识
     */
    @TableField(value = "recommend_code")
    private String recommend_code;

    /**
     * 承保表
     */
    @TableField(value = "underwrite_id",el="underwrite.underwrite_id")
    private InsUnderwrite underwrite;
    /**
     * 保单配送信息表
     */
    @TableField(value = "mail_policy_id",el="mailPolicy.ins_mail_policy_id")
    private InsMailPolicy mailPolicy = new InsMailPolicy();

    @TableField(value = "register_user_id")
    private Long register_user_id;

    @TableField(value = "classify")
    private String classify;

    @TableField(value = "special_id")
    private Long special_id;

    @TableField(value = "user_insure_path")
    private String user_insure_path;

    @TableField(value = "bh_initial")
    private String bh_initial;

    @TableField(value = "insure_path")
    private String insure_path;

    @TableField(value = "lg_path")
    private String lg_path;

    @TableField(value = "province")
    private String province;

    @TableField(value = "city")
    private String city;

    @TableField(value = "area_code")
    private String area_code;

    @TableField(value = "address")
    private String address;

    /**
     * 下单时间
     */
    @TableField(value = "start_time")
    private Date start_time;

    /**
     * 订单结束时间
     */
    @TableField(value = "end_time")
    private Date end_time;

    /**
     * 客户识别授权书
     */
    @TableField(value = "accredit_path")
    private String accredit_path;

    /**
     * 支撑的订单id
     */
    @TableField(value = "order_zc_id")
    private Long order_zc_id;

    /**
     * 是否已成功发送影像信息(默认0否，1是，目前小微产品用到)
     */
    @TableField(value = "is_send_yx")
    private int is_send_yx = 0;

    /**
     * 是否见费，0非见费，1见费
     */
    @TableField(value = "is_policy_before_pay_fee")
    private int is_policy_before_pay_fee = 1;

    /**
     * 争议处理
     */
    @TableField(value = "dispute")
    private String dispute;

    /**
     * 来源标识
     * 例：v5录入线下保单并标注保单为百联保购买时就会调用接口设置这个订单字段值为：PASP-QY
     */
    @TableField(value = "web_type")
    private String web_type;

    @TableField(value = "arbitral_institution")
    private String arbitral_institution;

    /**
     * 是否包含可选保障责任
     */
    @TableField(value = "is_contain_repo")
    private String is_contain_repo;

    /**
     * 交易表
     */
    @TableField(exist = false)
    private List<InsTransaction> insTransaction;

    @TableField(exist = false)
    private Map<String,Object> mapSpecial = new HashMap<String,Object>();
    @TableField(exist = false)
    private List<InsRoleInpolicy> roles = new ArrayList<InsRoleInpolicy>();
    @TableField(exist = false)
    private Map<String, List<InsRoleInpolicy>> roleMap = new HashMap<String, List<InsRoleInpolicy>>();

    public List<InsRoleInpolicy> getRolesOfKind(String kind) {
        List<InsRoleInpolicy> rolesOfKind = roles.stream()
                .filter(e -> kind.contains(e.getKind()))
                .collect(Collectors.toList());
        if(rolesOfKind.size()<1){
            return null;
        }
        return rolesOfKind;
    }

    public Map<String, List<InsRoleInpolicy>> getRoleMap() {
        for (InsRoleInpolicy role : roles) {
            List<InsRoleInpolicy> rolesOfKind = roleMap.computeIfAbsent(role.getKind(), k -> new ArrayList<InsRoleInpolicy>());
//            String kind = role.getKind();
//            List<InsRoleInpolicy> rolesOfKind = roleMap.get(kind);
//            if (rolesOfKind == null) {
//                rolesOfKind = new ArrayList<InsRoleInpolicy>();
//                roleMap.put(kind, rolesOfKind);
//            }
            if (!rolesOfKind.contains((role))) {
                rolesOfKind.add(role);
            }
        }
        return roleMap;
    }

    public Long getIns_insurance_slip_id() {
        return ins_insurance_slip_id;
    }

    public void setIns_insurance_slip_id(Long ins_insurance_slip_id) {
        this.ins_insurance_slip_id = ins_insurance_slip_id;
    }

    public Long getIdx() {
        return idx;
    }

    public void setIdx(Long idx) {
        this.idx = idx;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodex() {
        return codex;
    }

    public void setCodex(String codex) {
        this.codex = codex;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public SysUser getCreate_by() {
        return create_by;
    }

    public void setCreate_by(SysUser create_by) {
        this.create_by = create_by;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    public SysUser getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(SysUser update_by) {
        this.update_by = update_by;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public SysCompany getSysCompany() {
        return sysCompany;
    }

    public void setSysCompany(SysCompany sysCompany) {
        this.sysCompany = sysCompany;
    }

    public String getPolicy_serial_number() {
        return policy_serial_number;
    }

    public void setPolicy_serial_number(String policy_serial_number) {
        this.policy_serial_number = policy_serial_number;
    }

    public ProPrimary getPro_primary() {
        return pro_primary;
    }

    public void setPro_primary(ProPrimary pro_primary) {
        this.pro_primary = pro_primary;
    }

    public BigDecimal getPremium() {
        return premium;
    }

    public void setPremium(BigDecimal premium) {
        this.premium = premium;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Integer getUnit_count() {
        return unit_count;
    }

    public void setUnit_count(Integer unit_count) {
        this.unit_count = unit_count;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getInception_date() {
        return inception_date;
    }

    public void setInception_date(Date inception_date) {
        this.inception_date = inception_date;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getPlanned_end_date() {
        return planned_end_date;
    }

    public void setPlanned_end_date(Date planned_end_date) {
        this.planned_end_date = planned_end_date;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getSigned_date() {
        return signed_date;
    }

    public void setSigned_date(Date signed_date) {
        this.signed_date = signed_date;
    }

    public BigDecimal getInsured_amount() {
        return insured_amount;
    }

    public void setInsured_amount(BigDecimal insured_amount) {
        this.insured_amount = insured_amount;
    }

    public String getTrade_serial_number() {
        return trade_serial_number;
    }

    public void setTrade_serial_number(String trade_serial_number) {
        this.trade_serial_number = trade_serial_number;
    }

    public String getOrder_status() {
        return order_status;
    }

    public void setOrder_status(String order_status) {
        this.order_status = order_status;
    }

    public SysUser getInsurerUser() {
        return insurerUser;
    }

    public void setInsurerUser(SysUser insurerUser) {
        this.insurerUser = insurerUser;
    }

    public Long getOrder_user_id() {
        return order_user_id;
    }

    public void setOrder_user_id(Long order_user_id) {
        this.order_user_id = order_user_id;
    }

    public InsUnderwrite getUnderwrite() {
        return underwrite;
    }

    public void setUnderwrite(InsUnderwrite underwrite) {
        this.underwrite = underwrite;
    }

    public InsMailPolicy getMailPolicy() {
        return mailPolicy;
    }

    public void setMailPolicy(InsMailPolicy mailPolicy) {
        this.mailPolicy = mailPolicy;
    }

    public Long getRegister_user_id() {
        return register_user_id;
    }

    public void setRegister_user_id(Long register_user_id) {
        this.register_user_id = register_user_id;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public Long getSpecial_id() {
        return special_id;
    }

    public void setSpecial_id(Long special_id) {
        this.special_id = special_id;
    }

    public String getUser_insure_path() {
        return user_insure_path;
    }

    public void setUser_insure_path(String user_insure_path) {
        this.user_insure_path = user_insure_path;
    }

    public String getInsure_path() {
        return insure_path;
    }

    public void setInsure_path(String insure_path) {
        this.insure_path = insure_path;
    }

    public String getLg_path() {
        return lg_path;
    }

    public void setLg_path(String lg_path) {
        this.lg_path = lg_path;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getArea_code() {
        return area_code;
    }

    public void setArea_code(String area_code) {
        this.area_code = area_code;
    }

    public Map<String, Object> getMapSpecial() {
        return mapSpecial;
    }

    public void setMapSpecial(Map<String, Object> mapSpecial) {
        this.mapSpecial = mapSpecial;
    }

    public List<InsRoleInpolicy> getRoles() {
        return roles;
    }

    public void setRoles(List<InsRoleInpolicy> roles) {
        this.roles = roles;
    }

    public void setRoleMap(Map<String, List<InsRoleInpolicy>> roleMap) {
        this.roleMap = roleMap;
    }

    public Date getStart_time() {
        return start_time;
    }

    public void setStart_time(Date start_time) {
        this.start_time = start_time;
    }

    public Date getEnd_time() {
        return end_time;
    }

    public void setEnd_time(Date end_time) {
        this.end_time = end_time;
    }

    public List<InsTransaction> getInsTransaction() {
        return insTransaction;
    }

    public void setInsTransaction(List<InsTransaction> insTransaction) {
        this.insTransaction = insTransaction;
    }

    public String getRecommend_code() {
        return recommend_code;
    }

    public void setRecommend_code(String recommend_code) {
        this.recommend_code = recommend_code;
    }

    public String getAccredit_path() {
        return accredit_path;
    }

    public void setAccredit_path(String accredit_path) {
        this.accredit_path = accredit_path;
    }

    public String getBh_initial() {
        return bh_initial;
    }

    public void setBh_initial(String bh_initial) {
        this.bh_initial = bh_initial;
    }

    public Long getOrder_zc_id() {
        return order_zc_id;
    }

    public void setOrder_zc_id(Long order_zc_id) {
        this.order_zc_id = order_zc_id;
    }

    public String getNotice_no() {
        return notice_no;
    }

    public void setNotice_no(String notice_no) {
        this.notice_no = notice_no;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getDispute() {
        return dispute;
    }

    public void setDispute(String dispute) {
        this.dispute = dispute;
    }

    public String getArbitral_institution() {
        return arbitral_institution;
    }

    public void setArbitral_institution(String arbitral_institution) {
        this.arbitral_institution = arbitral_institution;
    }

    public int getIs_send_yx() {
        return is_send_yx;
    }

    public void setIs_send_yx(int is_send_yx) {
        this.is_send_yx = is_send_yx;
    }

    public String getIs_contain_repo() {
        return is_contain_repo;
    }

    public void setIs_contain_repo(String is_contain_repo) {
        this.is_contain_repo = is_contain_repo;
    }

    public int getIs_policy_before_pay_fee() {
        return is_policy_before_pay_fee;
    }

    public void setIs_policy_before_pay_fee(int is_policy_before_pay_fee) {
        this.is_policy_before_pay_fee = is_policy_before_pay_fee;
    }

    public String getCustom_remarks() {
        return custom_remarks;
    }

    public void setCustom_remarks(String custom_remarks) {
        this.custom_remarks = custom_remarks;
    }

    public String getWeb_type() {
        return web_type;
    }

    public void setWeb_type(String web_type) {
        this.web_type = web_type;
    }

    public String getInception_type() {
        return inception_type;
    }

    public void setInception_type(String inception_type) {
        this.inception_type = inception_type;
    }

    public String getInception_long() {
        return inception_long;
    }

    public void setInception_long(String inception_long) {
        this.inception_long = inception_long;
    }
}