package com.bcxin.ins.entity.common;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <b>任务残留表（当某方法回传数据给第三方时未成功传递的单子会在当前表记录，用于定时器多次尝试回传如果传递成功，则成功的记录会销毁） </b>
 *
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@TableName("com_task_residual")
public class ComTaskResidual implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long com_task_residual_id;
    /**    方法名     */
    @TableField(value = "method_name")
    private String method_name;
    /**    注释     */
    @TableField(value = "annotation")
    private String annotation;
    /**    类全称     */
    @TableField(value = "class_name")
    private String class_name;
    /**    参数个数     */
    @TableField(value = "param_num")
    private int param_num = 0;
    /**    参数类型数组     */
    @TableField(value = "param_type_arr")
    private String param_type_arr;
    /**    参数值数组     */
    @TableField(value = "param_value_arr")
    private String param_value_arr;
    /**    创建时间     */
    @TableField(value = "create_time")
    private Date create_time;
    /**    是否夜间执行     */
    @TableField(value = "is_nightly_run")
    private String is_nightly_run = "0";

    public ComTaskResidual(){}

    public ComTaskResidual(String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr){
        this.method_name = method_name;
        this.annotation = annotation;
        this.class_name = class_name;
        this.param_num = param_num;
        this.param_type_arr = param_type_arr;
        this.param_value_arr = param_value_arr;
        this.create_time = new Date();
    }

    public ComTaskResidual(String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr, String is_nightly_run){
        this.method_name = method_name;
        this.annotation = annotation;
        this.class_name = class_name;
        this.param_num = param_num;
        this.param_type_arr = param_type_arr;
        this.param_value_arr = param_value_arr;
        this.is_nightly_run = is_nightly_run;
        this.create_time = new Date();
    }

    public Long getCom_task_residual_id() {
        return com_task_residual_id;
    }

    public void setCom_task_residual_id(Long com_task_residual_id) {
        this.com_task_residual_id = com_task_residual_id;
    }

    public String getMethod_name() {
        return method_name;
    }

    public void setMethod_name(String method_name) {
        this.method_name = method_name;
    }

    public String getAnnotation() {
        return annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getClass_name() {
        return class_name;
    }

    public void setClass_name(String class_name) {
        this.class_name = class_name;
    }

    public int getParam_num() {
        return param_num;
    }

    public void setParam_num(int param_num) {
        this.param_num = param_num;
    }

    public String getParam_type_arr() {
        return param_type_arr;
    }

    public void setParam_type_arr(String param_type_arr) {
        this.param_type_arr = param_type_arr;
    }

    public String getParam_value_arr() {
        return param_value_arr;
    }

    public void setParam_value_arr(String param_value_arr) {
        this.param_value_arr = param_value_arr;
    }

    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }
}