package com.bcxin.ins.entity.common;

import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 定时任务信息状态表 </b>
 * @author ZXF
 * @create 2018/10/16 0016 13:53
 * @version
 * @注意事项 </b>
 */
@TableName("com_task_cron_status")
public class ComTaskCronStatus implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long com_task_cron_status_id;

    /**
     * 任务ID
     */
    @TableField("com_task_cron_id")
    private Long com_task_cron_id;

    /**
     * 执行状态 (1:执行成功,2:执行失败)
     */
    @TableField("run_status")
    private Integer run_status;

    /**
     * 执行开始时间
     */
    @TableField("run_start_time")
    private Date run_start_time;

    /**
     * 执行结束时间
     */
    @TableField("run_end_time")
    private Date run_end_time;

    /**
     * 错误信息
     */
    @TableField("error_message")
    private String error_message;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getCom_task_cron_status_id() {
        return com_task_cron_status_id;
    }

    public void setCom_task_cron_status_id(Long com_task_cron_status_id) {
        this.com_task_cron_status_id = com_task_cron_status_id;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getCom_task_cron_id() {
        return com_task_cron_id;
    }

    public void setCom_task_cron_id(Long com_task_cron_id) {
        this.com_task_cron_id = com_task_cron_id;
    }

    public Integer getRun_status() {
        return run_status;
    }

    public void setRun_status(Integer run_status) {
        this.run_status = run_status;
    }

    public Date getRun_start_time() {
        return run_start_time;
    }

    public void setRun_start_time(Date run_start_time) {
        this.run_start_time = run_start_time;
    }

    public Date getRun_end_time() {
        return run_end_time;
    }

    public void setRun_end_time(Date run_end_time) {
        this.run_end_time = run_end_time;
    }

    public String getError_message() {
        return error_message;
    }

    public void setError_message(String error_message) {
        this.error_message = error_message;
    }
}
