package com.bcxin.ins.third.gzzrx.zhonghua.security;

import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Iterator;

/**
 * <b>中华回调接口报文信息转换辅助表 </b>
 * 
 * @author zxf
 * @date 2017年1月19日 下午2:47:14
 * @注意事项 </b>
 * <b>
 */
public class ZHSendInfoVo {

	private static Logger logger = LoggerFactory.getLogger(ZHSendInfoVo.class);

	protected Document requestDocument;
	protected Element rootElement;

	private String transrno;//交易码
	private String partnercode;//合作伙伴代码
	private String partnersubcode;//合作伙伴子机构代码
	private String serialnumber;//交易流水号
	private String transdate;//交易时间
	private String payresult;//支付结果
	private String payremark;//支付描述
	private String paymenttype;//支付方式
	private String paydate;//支付时间
	private String payamt;//支付金额
	private String payid;//支付单号
	private String payno;//支付流水号
	private String appno;//投保单号
	private String polno;//保单号
	private String eurl;//电子保单下载URL
	private String receipt_url;//电子回执地址
	private String econfirmurl;//电子保函下载URL

	public String getTransrno() {
		return transrno;
	}

	public void setTransrno(String transrno) {
		this.transrno = transrno;
	}

	public String getPartnercode() {
		return partnercode;
	}

	public void setPartnercode(String partnercode) {
		this.partnercode = partnercode;
	}

	public String getPartnersubcode() {
		return partnersubcode;
	}

	public void setPartnersubcode(String partnersubcode) {
		this.partnersubcode = partnersubcode;
	}

	public String getSerialnumber() {
		return serialnumber;
	}

	public void setSerialnumber(String serialnumber) {
		this.serialnumber = serialnumber;
	}

	public String getTransdate() {
		return transdate;
	}

	public void setTransdate(String transdate) {
		this.transdate = transdate;
	}

	public String getPayresult() {
		return payresult;
	}

	public void setPayresult(String payresult) {
		this.payresult = payresult;
	}

	public String getPayremark() {
		return payremark;
	}

	public void setPayremark(String payremark) {
		this.payremark = payremark;
	}

	public String getPaymenttype() {
		return paymenttype;
	}

	public void setPaymenttype(String paymenttype) {
		this.paymenttype = paymenttype;
	}

	public String getPaydate() {
		return paydate;
	}

	public void setPaydate(String paydate) {
		this.paydate = paydate;
	}

	public String getPayamt() {
		return payamt;
	}

	public void setPayamt(String payamt) {
		this.payamt = payamt;
	}

	public String getPayid() {
		return payid;
	}

	public void setPayid(String payid) {
		this.payid = payid;
	}

	public String getPayno() {
		return payno;
	}

	public void setPayno(String payno) {
		this.payno = payno;
	}

	public String getAppno() {
		return appno;
	}

	public void setAppno(String appno) {
		this.appno = appno;
	}

	public String getPolno() {
		return polno;
	}

	public void setPolno(String polno) {
		this.polno = polno;
	}

	public String getEurl() {
		return eurl;
	}

	public void setEurl(String eurl) {
		this.eurl = eurl;
	}

	public String getReceipt_url() {
		return receipt_url;
	}

	public void setReceipt_url(String receipt_url) {
		this.receipt_url = receipt_url;
	}

	public String getEconfirmurl() {
		return econfirmurl;
	}

	public void setEconfirmurl(String econfirmurl) {
		this.econfirmurl = econfirmurl;
	}

	/**
	 * 对请求的报文解析
	 * @param originalXML
	 */
	public void analysisXML(String originalXML) {
		try {
			requestDocument = DocumentHelper.parseText(originalXML);
			rootElement = requestDocument.getRootElement();
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				if("HEAD".equals(node.getName())){
					analysisHead(node);
				}
				if("MAIN".equals(node.getName())){
					analysisMain(node);
				}
			}
		}catch (Exception e){
			logger.info("analysisXML:"+e.getMessage());
		}
	}

	private void analysisMain(Element node) {
		for(Iterator n = node.elementIterator(); n.hasNext();){
            Element node_n = (Element) n.next();
            if("BASE".equals(node_n.getName())){
				analysisBase(node_n);
			}
            if("POLICYLIST".equals(node_n.getName())){
				analysisPolicyList(node_n);
			}
        }
	}

	private void analysisPolicyList(Element node_n) {
		for(Iterator o = node_n.elementIterator(); o.hasNext();){
            Element node_o = (Element) o.next();
            if("POLICY".equals(node_o.getName())){
				analysisPolicy(node_o);
			}
        }
	}

	private void analysisPolicy(Element node_o) {
		for(Iterator x = node_o.elementIterator(); x.hasNext();){
            Element node_x = (Element) x.next();
            String name = node_x.getName();
            String value = node_x.getText();
            if(StringUtils.isNotEmpty(value)){
                value = value.replace("<![CDATA[", ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR);
            }
            if("APPNO".equals(name)){
                this.setAppno(value);
            }
            if("POLNO".equals(name)){
                this.setPolno(value);
            }
            if("EURL".equals(name)){
                this.setEurl(value);
            }
            if("RECEIPT_URL".equals(name)){
                this.setReceipt_url(value);
            }
            if("ECONFIRMURL".equals(name)){
                this.setEconfirmurl(value);
            }
        }
	}

	private void analysisBase(Element node_n) {
		for(Iterator o = node_n.elementIterator(); o.hasNext();){
            Element node_o = (Element) o.next();
            String name = node_o.getName();
            String value = node_o.getText();
            if(StringUtils.isNotEmpty(value)){
                value = value.replace("<![CDATA[", ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR);
            }
            if("SERIALNUMBER".equals(name)){
                this.setSerialnumber(value);
            }
            if("TRANSDATE".equals(name)){
                this.setTransdate(value);
            }
            if("PAYRESULT".equals(name)){
                this.setPayresult(value);
            }
            if("PAYREMARK".equals(name)){
                this.setPayremark(value);
            }
            if("PAYMENTTYPE".equals(name)){
                this.setPaymenttype(value);
            }
            if("PAYDATE".equals(name)){
                this.setPaydate(value);
            }
            if("PAYAMT".equals(name)){
                this.setPayamt(value);
            }
            if("PAYID".equals(name)){
                this.setPayid(value);
            }
            if("PAYNO".equals(name)){
                this.setPayno(value);
            }
        }
	}

	private void analysisHead(Element node) {
		for(Iterator n = node.elementIterator(); n.hasNext();) {
            Element node_n = (Element) n.next();
            if ("TRANSRNO".equals(node_n.getName())) {
                this.setTransrno(node_n.getText());
            }
            if ("PARTNERCODE".equals(node_n.getName())) {
                this.setPartnercode(node_n.getText());
            }
            if ("PARTNERSUBCODE".equals(node_n.getName())) {
                this.setPartnersubcode(node_n.getText());
            }
        }
	}

	/**
	 * <b> 返回接收结果 </b>
	 * @author ZXF
	 * @create 2019/02/22 0022 13:48
	 * @version
	 * @注意事项 </b>
	 */
	public String returnResult(String resultcode, String errinfo){
		String result = "<?xml version=\"1.0\" encoding=\"GBK\"?>\n" +
				"<INSUREQRET>\n" +
				"\t<HEAD>\n" +
				"\t\t<TRANSRNO>1002</TRANSRNO>\n" +
				"\t\t<RESULTCODE>"+resultcode+"</RESULTCODE>\n" +
				"\t\t<ERRINFO>"+errinfo+"</ERRINFO>\n" +
				"\t</HEAD>\n" +
				"</INSUREQRET>";
		return result;
	}

}
