package com.bcxin.ins.third.build.dubang;

import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DictConst;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;


/**
 * <b>用于发布都邦回调信息接口处理（941支付信息接收） </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
class DBBuildAPIServiceImpl implements DBBuildAPIService {

	@Autowired
	private InsTransactionAPIService insTransactionAPIService;
	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private Build_DBRequestService build_DBRequestService;

	@Override
	public String callbackPay(String xml){
		String sta = ConstProp.DIGIT_ZERO;
		String val = ConstProp.BLANK_CHAR;
		if(StringUtils.isEmpty(xml)){
			return Build_PackageMessageDuBang.returnSuccessInfo(sta,val);
		}
		DBSendInfoVo vo = new DBSendInfoVo();
		vo.analysisXML(xml);
		vo.setRequestType(DBProp.PORT_941);
		if(vo.isSign()){
			//完善支付信息，更新支付信息
			OrderFormVo dto = insInsuranceSlipAPIService.getOrderFormVoByTradeSerialNumber(vo.getOutOrderNo());
			if(dto != null){
				PolicyTransactionVo pvo = new PolicyTransactionVo();
				pvo.setOut_of_pocket(new BigDecimal(vo.getAmount()));
				pvo.setEnd_time(DateUtil.convertStringToDate(vo.getPayTime()));
				pvo.setPolicy_id(dto.getOid());
				insTransactionAPIService.updateTransationMsg(pvo);
				sta = ConstProp.DIGIT_ONE;
				val = vo.getOutOrderNo();
			}
		}
		return Build_PackageMessageDuBang.returnSuccessInfo(sta,val);
	}

	@Override
    public String callbackPolicy(String xml){
        String sta = ConstProp.DIGIT_ZERO;
        String val = ConstProp.BLANK_CHAR;
        if(StringUtils.isEmpty(xml)){
			return Build_PackageMessageDuBang.returnPolicyStatus(sta,val);
		}
		DBSendInfoVo vo = new DBSendInfoVo();
		vo.analysisXML(xml);
		vo.setRequestType(DBProp.PORT_942);
		if(!vo.isSign()){
			return Build_PackageMessageDuBang.returnPolicyStatus(sta,val);
		}
		//更新保单状态业务
		if(!"V".equals(vo.getCertiType())){
			sta = ConstProp.DIGIT_ONE;
			val = vo.getCertiType();
			return Build_PackageMessageDuBang.returnPolicyStatus(sta,val);
		}
		OrderFormVo orderVo = insInsuranceSlipAPIService.findPolicyByExternalAndRoleName(vo.getPolicyNo(),ConstProp.BLANK_CHAR);
		if(orderVo == null){
			sta = ConstProp.DIGIT_ONE;
			val = vo.getCertiType();
			return Build_PackageMessageDuBang.returnPolicyStatus(sta,val);
		}
		orderVo.setPolicy_status(DictConst.ORDER_STATUS_YCB);
		policyService.updateOrderFormStatus(orderVo);
		String result = build_DBRequestService.requestDB(Long.parseLong(orderVo.getOid()),ConstProp.DIGIT_FOUR,null);
		if(StringUtils.isNotEmpty(result)){
			if(ConstProp.CODE_SUCCESS.equals(result.split(ConstProp.POUND_SIGN)[0])){
				PolicyTransactionVo ptvo= new PolicyTransactionVo();
				ptvo.setPolicy_id(orderVo.getOid());
				ptvo.setInsure_path(result.split(ConstProp.POUND_SIGN)[1]);//保单地址
				insTransactionAPIService.savePolicyOther(ptvo);
			}
		}
		sta = ConstProp.DIGIT_ONE;
		val = vo.getCertiType();
        return Build_PackageMessageDuBang.returnPolicyStatus(sta,val);
    }

}
