package com.bcxin.ins.service.product.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.service.order.ComRegionAPIService;
import com.bcxin.ins.dao.product.InsProductAPIDao;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.service.product.InsProductggAPIService;
import com.bcxin.ins.core.entity.MySysInsCompany;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.service.MySysInsCompanyService;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.product_core.ProPrimaryExpire;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 保险产品实现
 * @author playboy
 *
 */
@Service
@Transactional
public class InsProductAPIServiceImpl extends ServiceImpl<InsProductAPIDao, ProPrimary> implements InsProductAPIService {

    @Autowired
    private InsProductAPIDao dao;
    @Autowired
    private InsProductggAPIService insProductggService;
    @Autowired
    private SysCompanyService sysCompanyService;
    @Autowired
    private ComRegionAPIService regionService;
    @Autowired
    private   MySysInsCompanyService  mySysInsCompanyService;

    @Autowired
    private InsProductResponsibilityAPIService insProductResponsibilityService;

    private static List<ProductVo> DEFAULT_PRO_LIST = Lists.newArrayList();

    /**
     * <b>根据关键字查询所有产品并转成Vo </b>
     * @param keywords 关键字
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午2:45:30
     * @注意事项 </b>
     * <b>
     */
    @Override
    public List<ProductVo> selectProductVoListByCondition(String keywords){
        List<ProductVo> voList = new ArrayList<ProductVo>();
        List<ProPrimary> productList = selectInsProductListByCondition(keywords);
        for(ProPrimary product : productList){
            voList.add(willInsProductSetUpProductVo(product));
        }
        return voList;
    }

    @Override
    public ProPrimary findProductByCode(String code){
        return dao.getInsProductgByCode(code);
    }

    /**
     * <b>根据关键字查询所有产品 </b>
     * @param keywords 关键字
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午5:09:14
     * @注意事项 </b>
     * <b>
     */
    @Override
    public List<ProPrimary> selectInsProductListByCondition(String keywords){
        return dao.selectInsProductListByCondition(keywords);
    }

    /**
     * <b>根据已有的多个产品id查询产品并转Vo </b>
     * @param pids 产品id集
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午5:08:24
     * @注意事项 </b>
     * <b>
     */
    @Override
    public List<ProductVo> fillProductList(String[] pids) {

        List<ProductVo>  plist= new ArrayList<ProductVo>();
        for (String pid : pids) {
            plist.add(willInsProductAndFeeSetUpProductVo(dao.getProduct(Long.parseLong(pid))));
        }
        return plist;
    }

    /**
     * <b>将产品信息匹配到ProductVo辅助类,增加上级分销商已分配对应产品的佣金 </b>
     *
     * @param product
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午2:46:50
     * @注意事项 </b>
     * <b>
     */
    @Override
    public ProductVo willInsProductAndFeeSetUpProductVo(ProPrimary product){
        ProductVo vo = new ProductVo();
        vo.setOid(String.valueOf(product.getPro_primary_id()));
        vo.setProduct_name(product.getInsurance_name());

//        vo.setProductDescribe(product.getIntro());
        vo.setProduct_code(product.getProduct_code());
        if(product.getSupplier() != null){
            vo.setInsurance_name(product.getSupplier().getCompany_name());//保险公司名称
        }
        SysUser user = SysUserUtils.getUser();
        /*InsProductCompanyFee parentFee = insProductCompanyFeeAPIService.getInsProductCompanyFeeByUserAndProduct(user.getSysCompany().getId(), product.getId());
        if(parentFee != null){
            vo.setTotalRebate(String.valueOf(parentFee.getBrokerage()));
        }*/
        return vo;
    }

    /**
     * <b>将产品信息匹配到ProductVo辅助类 </b>
     *
     * @param product
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午2:46:50
     * @注意事项 </b>
     * <b>
     */
    @Override
    public ProductVo willInsProductSetUpProductVo(ProPrimary product){
        ProductVo vo = new ProductVo();
        vo.setOid(String.valueOf(product.getPro_primary_id()));
        vo.setProduct_name(product.getInsurance_name());
        vo.setProduct_label(product.getLabel());
        vo.setDo_hot(product.getDo_hot());
        vo.setScope(product.getScope());
        vo.setSource(product.getSource());
        vo.setFrom_of_policy(product.getFrom_of_policy());
        vo.setIntro(product.getIntro());
        vo.setProduct_type(product.getProduct_type());
        vo.setProduct_code(product.getProduct_code());
        vo.setPremium_min(String.valueOf(product.getPremium_min()));
        vo.setP_status(String.valueOf(product.getStatus()));
        vo.setEffective_date(String.valueOf(product.getEffective_date()));
        vo.setEffective_date_after_n(String.valueOf(product.getEffective_date_after_n()));
        vo.setEffective_date_before_n(String.valueOf(product.getEffective_date_before_n()));
        if(product.getSupplier() != null){
            vo.setInsurance_name(product.getSupplier().getCompany_name());//保险公司名称
            vo.setIns_com_intro(product.getSupplier().getIntro());//保险公司简介
            vo.setMin_insurance_draw(product.getSupplier().getCompany_logo());
        }
        vo.setResponsibilityVoList(insProductResponsibilityService.findResponsibilityVoList(String.valueOf(product.getPro_primary_id())));
        return vo;
    }

    @Override
    public List<ProPrimary> findProductList(ProPrimary insProduct) {

        return dao.findProductList(insProduct);
    }

    @Override
    public List<SysCompany> fillCompanyList(String[] cids) {
        List<SysCompany>  slist= new ArrayList<SysCompany>();
        for (String cid : cids) {
            SysCompany  sysCompany= sysCompanyService.get(Long.parseLong(cid));
            slist.add(sysCompany);
        }
        return slist;
    }

    /**
     *查询产品属性 根据产品id（主） 和类型 去关联哪一张表
     * @param pid
     * @return
     */
    @Override
    public InsProductVo getProductAttrListByPid(Long pid, String type) {
        return dao.getProductAttrListByPid(pid,type);

    }

    @Override
    public ProPrimary getProduct(Long pid) {
        return dao.getProduct(pid);
    }

    @Override
    public List<ProductVo> getProductsByConditionAndPage(String pro_type, String condition, DwzPage page) {
        List<ProductVo> voList = new ArrayList<ProductVo>();
        Page<ProPrimary> pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        System.out.println(condition);
        List<ProPrimary> productList = dao.getProductsByConditionAndPage(pro_type,condition,pageHelper);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());

        for(ProPrimary ip : productList){
            voList.add(willInsProductSetUpProductVo(ip));
        }
        return voList;
    }

    /**
     * <b>根据产品id获取产品信息设置到OrderFormVo</b>
     *
     * @param vo
     * @param insProduct_id
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午2:46:50
     * @注意事项 </b>
     * <b>
     */
    @Override
    public void accordingToProductIDToGetInsProductSetUpOrderFormVo(OrderFormVo vo, Long insProduct_id){
        ProPrimary insProduct = dao.getProduct(insProduct_id);
        if(insProduct != null){
            ProPrimaryExpire insProductgg = insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
            if(insProductgg != null){
                vo.setFees_for(insProductgg.getFees_for());
                vo.setPay_methods(insProductgg.getPay_methods());
            }
            vo.setProduct_name(insProduct.getInsurance_name());
            vo.setProduct_type(insProduct.getProduct_type());
            vo.setProduct_code(insProduct.getProduct_code());
            if(insProduct.getSupplier() != null){
                MySysInsCompany sysCompany=mySysInsCompanyService.selectById(insProduct.getSupplier().getSys_ins_company_id());
//                SysInsCompany sysCompany = sysCompanyService.selectById(insProduct.getSupplier().getSys_ins_company_id());
                if(sysCompany != null){
                    vo.setInsurance_name(sysCompany.getCompany_name());
                }
            }
        }
    }

    /**
     * <b>根据产品id获取产品信息设置到AdviceNoteVo</b>
     *
     * @param vo
     * @param insProduct_id
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午2:46:50
     * @注意事项 </b>
     * <b>
     */
    @Override
    public void accordingToProductIDToGetInsProductSetUpAdviceNoteVo(AdviceNoteVo vo, Long insProduct_id){
        ProPrimary insProduct = dao.getProduct(insProduct_id);
        if(insProduct != null){
            /*ProPrimaryExpire insProductgg = insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
            if(insProductgg != null){
                vo.setPay_methods(insProductgg.getPay_methods());
            }*/
            vo.setProduct_name(insProduct.getInsurance_name());
            vo.setProduct_type(insProduct.getProduct_type());
            if(insProduct.getSupplier() != null){
                MySysInsCompany  sysCompany=mySysInsCompanyService.selectById(insProduct.getSupplier().getSys_ins_company_id());

                if(sysCompany != null){
                    vo.setCompany_ename(sysCompany.getCompany_ename());
                    vo.setCompany_name(sysCompany.getCompany_name());
                    vo.setShort_name(sysCompany.getShort_name());
                    String address = "";
                    ComRegion pro = regionService.findDistrictByCode("",sysCompany.getProvince());
                    ComRegion city = regionService.findDistrictByCode("",sysCompany.getCity());
                    ComRegion dis = regionService.findDistrictByCode("",sysCompany.getDistrict());
                    if(pro != null && city != null && dis != null ){
                        address = pro.getNamed()+city.getNamed()+dis.getNamed();
                    }
                    vo.setRegistered_address(address);
                    vo.setBank_name(sysCompany.getBank_name());
                    vo.setBank_account(sysCompany.getBank_account());
                    vo.setBank_account_name(sysCompany.getBank_account_name());
                }
            }
        }
    }

    /**
     * <b>查询所有产品 </b>
     *
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午2:45:30
     * @注意事项 </b>
     * <b>
     */
    @Override
    public List<ProductVo> selectProductVoList(ProPrimary insProduct){
        List<ProductVo> voList = new ArrayList<ProductVo>();
        List<ProPrimary> productList = dao.findProductList(insProduct);

        for(ProPrimary ip : productList){
            voList.add(willInsProductSetUpProductVo(ip));
        }
        return voList;
    }

    /**
     * <b> 查询所有已上线的产品列 </b>
     * @author ZXF
     * @create 2018/04/24 0024 15:32
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<ProductVo> getProductsByOnLine(String code){
        if(StringUtils.isEmpty(code)){
//            return dao.getProductsByOnLine(ConstProp.DEFAULT_X);
            if(DEFAULT_PRO_LIST.size()==0){
                loadDefaultProducts();
            }
            return DEFAULT_PRO_LIST;
        }
        String key = ConstProp.REDIS_HEAD_PRODUCT_PCO+code+"-";
        List<ProductVo> voList;
        if(JedisUtils.exists(key)){
            voList = JSON.parseArray(JedisUtils.get(key),ProductVo.class);
        }else{
            voList = dao.getProductsByOnLine(code);
            for(ProductVo vo : voList){
                vo.setResponsibilityVoList(insProductResponsibilityService.findResponsibilityVoList(vo.getOid()));
            }
            //设置一个月过期
            JedisUtils.set(key,JSON.toJSONString(voList),ConstProp.ONE_MONTH_TIMEOUT_SECONDS);
        }

        return voList;
    }

    /**
     * <b> 定时任务加载所有的产品信息到静态列表 DEFAULT_PRO_LIST ，预计10分钟重置一次</b>
     * @author ZXF
     * @create 2021/11/24 0024 16:55
     * @version
     * @注意事项 </b>
     */
    @Override
    public void loadDefaultProducts(){
//        String code = ConstProp.DEFAULT_X;
//        String key = ConstProp.REDIS_HEAD_PRODUCT_PCO+code+"-";
        List<ProductVo> voList = dao.getProductsByOnLine(ConstProp.DEFAULT_X);
        for(ProductVo vo : voList){
            vo.setResponsibilityVoList(insProductResponsibilityService.findResponsibilityVoList(vo.getOid()));
        }
        DEFAULT_PRO_LIST = voList;
    }

    /**
     * <b>根据产品子表id查询并封装到ProductVo </b>
     *
     * @param insProductID
     * @return
     * @author ZXF
     * @date 2017年1月10日 下午2:46:16
     * @注意事项 </b>
     * <b>
     */
    @Override
    public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID){
        ProductVo ip;
        String key = ConstProp.REDIS_HEAD_PRODUCT_ID+String.valueOf(insProductID);
        if(JedisUtils.exists(key)){
            ip = JSON.parseObject(JedisUtils.get(key),ProductVo.class);
        }else{
            ip = dao.accordingToInsProductIDToGetInsProductInProductVo(insProductID);
            if(ip != null){
                ip.setResponsibilityVoList(insProductResponsibilityService.findResponsibilityVoList(ip.getOid()));
                //设置一个月过期
                JedisUtils.set(key,JSON.toJSONString(ip),ConstProp.ONE_MONTH_TIMEOUT_SECONDS);
            }
        }
        return ip;
    }

    /**
     * <b> 查询产品信息跟保障责任信息，用于saas对接接口 </b>
     * @author ZXF
     * @create 2018/04/02 0002 17:20
     * @version
     * @注意事项 </b>
     */
    @Override
    public String listProductAndResponsibility(){
        List<ProductVo> pList = dao.listProductAndResponsibility(ConstProp.TYX);
        JSONArray ja1 = new JSONArray();
        JSONObject jo1;
        JSONArray ja2;
        List<ResponsibilityVo> rList = null;
        for(ProductVo p : pList){
            jo1 = new JSONObject();
            rList = insProductResponsibilityService.findResponsibilityVoList(p.getOid());
            ja2 = new JSONArray();
            JSONObject jo2;
            for(ResponsibilityVo r : rList){
                jo2 = new JSONObject();
                jo2.put("name",r.getName());
                jo2.put("guaProjectCode",r.getResponsibility_code());
                jo2.put("fcy",r.getFcy());
                ja2.add(jo2);
                jo2 = null;
            }
            jo1.put("insName",p.getProduct_name());
            jo1.put("comName",p.getInsurance_name());
            jo1.put("proIntro",p.getIntro());
            jo1.put("proImgPath",p.getDetail_product_draw());
            jo1.put("insFee",String.valueOf(new BigDecimal(p.getPremium_min())));
            jo1.put("proCode",p.getProduct_code());
            jo1.put("resList",ja2);
            ja1.add(jo1);
            jo1 = null;
            rList = null;
            ja2 = null;
        }
        String result = JSON.toJSONString(ja1);
        System.out.println("产品信息：----------------------");
        System.out.println(result);
        System.out.println("产品信息：----------------------");
        return result;
    }

}
