package com.bcxin.ins.service.order.impl;


import com.bcxin.ins.dao.order.InsClaimInformationAPIDao;
import com.bcxin.ins.service.order.InsClaimInformationAPIService;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.policy_report.InsClaimInformation;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsClaimInformationVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>雇主责任险雇员特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsClaimInformationAPIServiceImpl extends ServiceImpl<InsClaimInformationAPIDao, InsClaimInformation> implements InsClaimInformationAPIService {

	private static Logger log =  LoggerFactory.getLogger(InsClaimInformationAPIServiceImpl.class);

	@Autowired
	private InsClaimInformationAPIDao dao;

	/**
	 * <b>根据Vo及订单ID更新InsCommonReport数据 </b>
	 *
	 * @param vo
	 * @param report_id 报案id
	 * @author ZXF
	 * @create 2019/11/20 0020 16:56
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void accordingToTheInsCommonReportVoSetUpInsClaimInformation(InsCommonReportVo vo, Long report_id) {
		List<InsClaimInformationVo> hvoList = vo.getClaimInformationVoList();
		if(hvoList == null || hvoList.size() == 0){
			return;
		}
		List<InsClaimInformation> ahs = Lists.newArrayList();//新增
		List<InsClaimInformation> uhs = Lists.newArrayList();//修改
		try{
			//先删除所有状态为0的附件根据报案id（每次修改都是先删除原记录添加新记录）
			delectAllInsClaimInformation(report_id);
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			for(InsClaimInformationVo hvo : hvoList){
				if(hvo.isNull()||StringUtils.isEmpty(hvo.getFile_key())){
					continue;
				}
				setClaimInformationToList(vo, report_id, ahs, uhs, idWorker, hvo);
			}
			if(ahs.size()>0){
				dao.batchInsert(ahs);
			}
			if(uhs.size()>0){
				dao.batchUpdate(uhs);
			}
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			e.printStackTrace();
		}

	}

	/**
	 * <b> 设置附件信息区分更新或修改加到对应list </b>
	 * @author ZXF
	 * @create 2020/09/15 0015 11:07
	 * @version
	 * @注意事项 </b>
	 */
	private void setClaimInformationToList(InsCommonReportVo vo, Long report_id, List<InsClaimInformation> ahs, List<InsClaimInformation> uhs, IdWorker idWorker, InsClaimInformationVo hvo) {
		InsClaimInformation icf;
		if(StringUtils.isNotEmpty(hvo.getIns_claim_information_id())){
            icf = new InsClaimInformation();
            icf.setIns_claim_information_id(Long.parseLong(hvo.getIns_claim_information_id()));
            icf.setIns_common_report_id(report_id);
            icf.setCreate_time(new Date());
            try {
                MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), icf);
            } catch (Exception e) {
                e.printStackTrace();
            }
            uhs.add(icf);
        }else{
            icf = new InsClaimInformation();
            icf.setIns_claim_information_id(idWorker.nextId());
            try {
                MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), icf);
                icf.setIns_common_report_id(report_id);
                icf.setCreate_time(new Date());
                icf.setCreate_by(new SysUser(Long.parseLong(vo.getRegister_user_id())));
            } catch (Exception e) {
                e.printStackTrace();
            }
            ahs.add(icf);
        }
	}

	/**
	 * <b>获取InsCommonReportVo根据报案id查询附件信息插入到InsCommonReportVo </b>
	 *
	 * @param vo 报案辅助表
	 * @param report_id 报案id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id){
		List<InsClaimInformationVo> list = dao.selectInsClaimInformationVoByReportId(report_id);
		int count = 0;
		if(list != null){
			if(list.size()<3){
				count = list.size();
			}else{
				count = 100;
			}
		}
		if(count == 100){
			for(int i = count;i<3;i++){
				list.add(new InsClaimInformationVo());
			}
		}
		vo.setClaimInformationVoList(list);
	}

	/**
	 * 根据id删除附件
	 * @param oid 雇员id
	 * @return
	 */
	@Override
	public boolean delectInsClaimInformationByOid(Long oid){
		try {
			dao.deleteById(oid);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * 根据id删除报案下所有附件
	 * @param oid 订单id
	 * @return
	 */
	@Override
	public boolean delectAllInsClaimInformation(Long oid){
		try {
			Map<String, Object> map = Maps.newHashMap();
			map.put("ins_common_report_id",oid);
			map.put("status","0");
			dao.deleteByMap(map);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * 根据报案Id查找附件状态为0的条目变更状态为1
	 * @param report_id 报案id
	 * @return
	 */
	@Override
	public boolean updateStatusByReportId(Long report_id){
		try {
			dao.updateStatusByReportId(report_id);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	@Override
	public boolean updateStatusByIds(List<String> ids){
		try {
			dao.updateStatusByIds(ids);
			return true;
		}catch (Exception e){
			return false;
		}
	}
}
