package com.bcxin.ins.service.order.impl;


import com.bcxin.ins.dao.order.InsCaseScheduleAPIDao;
import com.bcxin.ins.service.order.InsCaseScheduleAPIService;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.policy_report.InsCaseSchedule;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsCaseScheduleVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>报案成功案件信息业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsCaseScheduleAPIServiceImpl extends ServiceImpl<InsCaseScheduleAPIDao, InsCaseSchedule> implements InsCaseScheduleAPIService {

	@Autowired
	private InsCaseScheduleAPIDao dao;

	/**
	 * <b>根据Vo及订单ID更新InsCommonReport数据 </b>
	 *
	 * @param vo
	 * @param report_id 报案id
	 * @author ZXF
	 * @create 2019/11/20 0020 16:56
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void accordingToTheInsCommonReportVoSetUpInsCaseSchedule(InsCommonReportVo vo, Long report_id) {
		List<InsCaseScheduleVo> hvoList = vo.getCaseScheduleVoList();
        InsCaseSchedule icf = null;
		List<InsCaseSchedule> ahs = Lists.newArrayList();//新增
		List<InsCaseSchedule> uhs = Lists.newArrayList();//修改
		try{
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			for(InsCaseScheduleVo hvo : hvoList){
				if(hvo.isNull()){
					continue;
				}
				if(StringUtils.isNotEmpty(hvo.getIns_case_schedule_id())){
					icf = new InsCaseSchedule();
					icf.setIns_case_schedule_id(Long.parseLong(hvo.getIns_case_schedule_id()));
					icf.setIns_common_report_id(report_id);
					try {
						MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), icf);
					} catch (Exception e) {
						e.printStackTrace();
					}
					uhs.add(icf);
				}else{
					icf = new InsCaseSchedule();
					icf.setIns_case_schedule_id(idWorker.nextId());
					try {
						MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), icf);
						icf.setIns_common_report_id(report_id);
						icf.setCreate_time(new Date());
						icf.setCreate_by(new SysUser(Long.parseLong(vo.getRegister_user_id())));
						icf.setStatus(0);
					} catch (Exception e) {
						e.printStackTrace();
					}
					ahs.add(icf);
				}
			}
			if(ahs.size()>0){
				dao.batchInsert(ahs);
			}
			if(uhs.size()>0){
				dao.batchUpdate(uhs);
			}
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			e.printStackTrace();
		}

	}

	/**
	 * <b>获取InsCommonReportVo根据报案id查询报案成功案件信息插入到InsCommonReportVo </b>
	 *
	 * @param vo 报案辅助表
	 * @param report_id 报案id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id){
		List<InsCaseScheduleVo> list = dao.selectInsCaseScheduleVoByReportId(report_id);
		int count = 0;
		if(list != null){
			if(list.size()<3){
				count = list.size();
			}else{
				count = 100;
			}
		}
		if(count == 100){
			for(int i = count;i<3;i++){
				list.add(new InsCaseScheduleVo());
			}
		}
		vo.setCaseScheduleVoList(list);
	}

	/**
	 * 根据id删除报案成功案件信息
	 * @param oid 报案成功案件信息id
	 * @return
	 */
	@Override
	public boolean delectInsCaseScheduleByOid(Long oid){
		try {
			dao.deleteById(oid);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * 根据id删除报案下所有报案成功案件信息
	 * @param oid 报案id
	 * @return
	 */
	@Override
	public boolean delectAllInsCaseSchedule(Long oid){
		try {
			Map<String, Object> map = Maps.newHashMap();
			map.put("ins_common_report_id",oid);
			dao.deleteByMap(map);
			return true;
		}catch (Exception e){
			return false;
		}
	}
}
