package com.bcxin.ins.rest;

import com.bcxin.ins.entity.common.ComTaskResidual;
import com.bcxin.ins.spring.util.SpringContextHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class TaskReflectUtil {


    /**
     * <b> 类反射 </b>
     *
     * @author ZXF
     * @create 2018/03/19 0019 14:06
     * @version
     * @注意事项 </b>
     */
    public void classReflect(ComTaskResidual ctr){
        ClassLoader cls = Thread.currentThread().getContextClassLoader();
        try {
            Class c =  cls.loadClass(ctr.getClass_name());
            String[] tArr = ctr.getParam_type_arr().split(",");
            String[] vArr = ctr.getParam_value_arr().split(",", -1);
            Class[] csArr = new Class[ctr.getParam_num()];
            Object[] otArr = new Object[ctr.getParam_num()];
            for(int i = 0; i<ctr.getParam_num();i++){
                String tp = tArr[i];
                if("String".equals(tp)){
                    csArr[i] = String.class;
                    otArr[i] = String.valueOf(vArr[i]);
                }else if("int".equals(tp)){
                    csArr[i] = int.class;
                    otArr[i] = Integer.parseInt(vArr[i]);
                }else if("BigDecimal".equals(tp)){
                    csArr[i] = BigDecimal.class;
                    otArr[i] = new BigDecimal(vArr[i]);
                }else if("Long".equals(tp)){
                    csArr[i] = Long.class;
                    otArr[i] = Long.parseLong(vArr[i]);
                }
            }
            Object o =  SpringContextHolder.getBean(c);
            Method method = o.getClass().getDeclaredMethod(ctr.getMethod_name(),csArr);
            method.setAccessible(true);
//            Type t = method.getAnnotatedReturnType().getType();
            boolean ret = (boolean)method.invoke(o, otArr);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ComTaskResidual ctr = new ComTaskResidual("testReflect"
                ,"测试方法"
                ,"com.bcxin.ins.service.order.PolicyService"
                ,3
                ,"String"
                ,"呵呵"
        );
//        classReflect(ctr);
    }


}