package com.bcxin.ins.dao.order;

import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>投保人/被保人信息表数据访问  </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface InsRoleInpolicyAPIDao extends BaseMapper<InsRoleInpolicy> {

	public InsRoleInpolicy selectById(@Param("id") Long id);

	void batchUpdate(@Param("list") List<InsRoleInpolicy> list);
	void batchInsert(@Param("list") List<InsRoleInpolicy> list);

	/**
	 * <b>根据投保单id查询投保单被保人列表 </b> 
	 * 
	 * @param oid 投保单id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 下午4:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsRoleInpolicy> selectInsRoleInpolicyByInsInsuranceSlip(@Param("oid") Long oid);

	List<RoleSubjectVo> selectRoleSubjectVoByInsInsuranceSlip(@Param("oid") Long oid);

	public List<InsRoleInpolicy> findInsRoleInpolicyByPolicyAndKeywordForPage(@Param("page") Page<InsRoleInpolicy> page, @Param("policyId") Long policyId, @Param("keyword") String keyword);

	public List<InsRoleInpolicy> findInsRoleInpolicyByPolicyAndKeywordForPage( @Param("policyId") Long policyId, @Param("keyword") String keyword);

	/**
	 * <b>根据投保单id查询被保险人数量 </b>
	 *
	 * @param oid 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	public int countInsurancedByID(@Param("oid") Long oid);

	/**
	 * <b>根据订单id查询被保险人列表 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年4月14日 下午10:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsRoleInpolicy> getRoleInPolicyByOrderId(@Param("order_id") Long order_id, @Param("kind") String kind);

	public void delectAllInsRole(@Param("order_id") Long order_id);

	/**
	 * <b> 根据投保人收录的银行信息转查太保银行信息 </b>
	 * @author ZXF
	 * @create 2024/04/17 0017 10:26
	 * @version
	 * @注意事项 </b>
	 */
	public Map<String,String> getTBBankByOrderId(@Param("order_id") Long order_id);

	/**
	 * <b> 根据订单id查询团险保障人员列表 </b>
	 * @author ZXF
	 * @create 2019/11/07 0007 14:57
	 * @version
	 * @注意事项 </b>
	 */
	List<ResultSetExcelVo> selectRoleInPolicyListByOrderID(@Param("order_id") Long order_id);

	InsPreservationResultSetVo setResultSetVo(@Param("role_id") Long role_id);

	public String getOrgUrlByOrderID(@Param("order_id") Long order_id);
}
