/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.preservation.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.dao.preservation.InsPreservationPayAPIDao;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationPay;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.tyx.changan.TYX_CARequestService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.FileHelp;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgRecordType;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.excel.ExcelUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.excel.InsPreservationPayChildExcelVo;
import com.bcxin.ins.vo.excel.InsPreservationPayExcelVo;
import com.bcxin.ins.vo.excel.InsPreservationSettlementExcelVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class InsPreservationPayAPIServiceImpl
extends ServiceImpl<InsPreservationPayAPIDao, InsPreservationPay>
implements InsPreservationPayAPIService {
    private Logger log = LoggerFactory.getLogger(InsPreservationPayAPIServiceImpl.class);
    @Autowired
    private InsPreservationPayAPIDao insPreservationPayAPIDao;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private ClientUserService userService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ComDeployConfigService comDeployConfigService;
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
    @Autowired
    private GZZRX_CARequestService gZZRX_CARequestService;
    @Autowired
    private TYX_CARequestService tYX_CARequestService;

    @Override
    public List<InsPreservationPay> findInsPreservationPayByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationPay> list = this.insPreservationPayAPIDao.findInsPreservationPayByKeyword((Page<InsPreservationPay>)pageHelper, userId, pay_status, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<InsPreservationPayVo> findInsPreservationPayVoByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationPayVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, pay_status, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<InsPreservationPay> findInsPreservationBillByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationPay> list = this.insPreservationPayAPIDao.findInsPreservationBillByKeyword((Page<InsPreservationPay>)pageHelper, userId, pay_status, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<InsPreservationPayVo> findInsPreservationBillVoByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationBillVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, pay_status, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<InsPreservationPayVo> findInsPreservationSettlementVoByKeyword(DwzPage page, Long userId, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationSettlementVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public void downBillPay(Long userId, String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response) {
        Page pageHelper = new Page(1, 65535);
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationBillVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, pay_status, start_time, end_time, keyword);
        ExcelUtil util = new ExcelUtil(InsPreservationPayExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u6c47\u603b\u8d26\u5355\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ArrayList addMap = Lists.newArrayList();
            for (InsPreservationPayVo vo : list) {
                addMap.add(new InsPreservationPayExcelVo(vo.getExternal_reference(), vo.getCompany_name(), vo.getApp_role_name(), vo.getRecord_count(), vo.getPredict_total_amount(), vo.getStar_pay_time(), vo.getEnd_pay_time(), vo.getBuild_data(), SysDictUtils.getDictLabel((String)vo.getPay_status(), (String)"billPayStatus", (String)""), vo.getIs_part() == 1 ? "\u90e8\u5206\u8d26\u5355" : "\u6c47\u603b\u8d26\u5355", vo.getIs_fp() == 1 ? "\u662f" : "\u5426"));
            }
            util.exportExcel((List)addMap, keyword + "\u6c47\u603b\u8d26\u5355\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downSettlementPay(Long userId, String start_time, String end_time, String keyword, HttpServletResponse response) {
        Page pageHelper = new Page(1, 65535);
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationSettlementVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, start_time, end_time, keyword);
        ExcelUtil util = new ExcelUtil(InsPreservationSettlementExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u7ed3\u7b97\u5355\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ArrayList addMap = Lists.newArrayList();
            for (InsPreservationPayVo vo : list) {
                addMap.add(new InsPreservationSettlementExcelVo(vo.getExternal_reference(), vo.getCompany_name(), vo.getRecord_count(), vo.getFact_total_amount(), vo.getBuild_data(), "3".equals(vo.getPay_status()) ? "\u5df2\u7ed3\u7b97" : "-"));
            }
            util.exportExcel((List)addMap, keyword + "\u7ed3\u7b97\u5355\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downChildBillPay(Long userId, Long parentPayId, String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response) {
        Page pageHelper = new Page(1, 65535);
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationChildBillVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, parentPayId, pay_status, start_time, end_time, keyword);
        ExcelUtil util = new ExcelUtil(InsPreservationPayChildExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u5b50\u8d26\u5355\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ArrayList addMap = Lists.newArrayList();
            for (InsPreservationPayVo vo : list) {
                addMap.add(new InsPreservationPayChildExcelVo(vo.getExternal_reference(), vo.getCompany_name(), vo.getInsurance_name(), vo.getApp_role_name(), SysDictUtils.getDictLabel((String)vo.getPay_status(), (String)"payStatus", (String)""), vo.getRecord_count(), vo.getAdd_count(), vo.getMinus_count(), vo.getReplace_count(), vo.getPredict_total_amount(), vo.getFact_total_amount(), vo.getStar_pay_time(), vo.getEnd_pay_time()));
            }
            util.exportExcel((List)addMap, keyword + "\u5b50\u8d26\u5355\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downChildSettlementBillPay(Long userId, Long parentPayId, String start_time, String end_time, String keyword, HttpServletResponse response) {
        Page pageHelper = new Page(1, 65535);
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationChildSettlementVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, parentPayId, start_time, end_time, keyword);
        ExcelUtil util = new ExcelUtil(InsPreservationPayChildExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword + "\u5b50\u8d26\u5355\u6e05\u5355.xls").getBytes("gb2312"), "ISO8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ArrayList addMap = Lists.newArrayList();
            for (InsPreservationPayVo vo : list) {
                addMap.add(new InsPreservationPayChildExcelVo(vo.getExternal_reference(), vo.getCompany_name(), vo.getInsurance_name(), vo.getApp_role_name(), SysDictUtils.getDictLabel((String)vo.getPay_status(), (String)"payStatus", (String)""), vo.getRecord_count(), vo.getAdd_count(), vo.getMinus_count(), vo.getReplace_count(), vo.getPredict_total_amount(), vo.getFact_total_amount(), vo.getStar_pay_time(), vo.getEnd_pay_time()));
            }
            util.exportExcel((List)addMap, keyword + "\u5b50\u8d26\u5355\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<InsPreservationPayVo> findInsPreservationChildBillVoByKeyword(DwzPage page, Long userId, Long parentPayId, String pay_status, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationChildBillVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, parentPayId, pay_status, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<InsPreservationPayVo> findInsPreservationChildSettlementVoByKeyword(DwzPage page, Long userId, Long parentPayId, String start_time, String end_time, String keyword) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsPreservationPayVo> list = this.insPreservationPayAPIDao.findInsPreservationChildSettlementVoByKeyword((Page<InsPreservationPayVo>)pageHelper, userId, parentPayId, start_time, end_time, keyword);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public JSONObject createPartBill(String isSummaryBill, String[] payIds) {
        int isConsistent;
        JSONObject json = new JSONObject();
        if (payIds == null || payIds.length < 1) {
            json.put("status", (Object)"300");
            json.put("msg", (Object)"\u65e0\u6709\u6548\u8d26\u5355");
            return json;
        }
        if ("1".equals(isSummaryBill)) {
            if (payIds.length < 2) {
                json.put("status", (Object)"300");
                json.put("msg", (Object)"\u5355\u6761\u6c47\u603b\u8d26\u5355\u53ef\u76f4\u63a5\u5b8c\u6210\u7f34\u8d39\u4e1a\u52a1");
                return json;
            }
        } else {
            Map<String, String> map;
            String partBillSign = this.insPreservationPayAPIDao.isPartBillSign(payIds);
            if (StringUtils.isNotEmpty((String)partBillSign)) {
                json.put("status", (Object)"300");
                json.put("msg", (Object)("\u8fd9\u4e9b\u8d26\u5355\u7f16\u7801\u5df2\u751f\u6210\u90e8\u5206\u8d26\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6210\uff1a" + partBillSign));
                return json;
            }
            List<Map<String, String>> isConsistentSummaryBill = this.insPreservationPayAPIDao.isConsistentSummaryBill(payIds);
            if (isConsistentSummaryBill.size() == 1 && "1".equals((map = isConsistentSummaryBill.get(0)).get("isAll"))) {
                json.put("status", (Object)"300");
                json.put("msg", (Object)("\u64cd\u4f5c\u5bf9\u8c61\u5f52\u5c5e\u540c\u4e00\u8d26\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6210\uff1a" + map.get("external_reference")));
                return json;
            }
        }
        if ((isConsistent = this.insPreservationPayAPIDao.isConsistentInsurancePlan(isSummaryBill, payIds)) > 1) {
            json.put("status", (Object)"300");
            json.put("msg", (Object)"\u8d26\u5355\u9669\u79cd\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5408\u5e76");
            return json;
        }
        List<InsPreservationPay> billMergeList = this.insPreservationPayAPIDao.consistentBillMerge(isSummaryBill, payIds);
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        for (InsPreservationPay ipPay : billMergeList) {
            Long ins_preservation_pay_id = idWorker.nextId();
            ipPay.setExternal_reference("BFZD" + ins_preservation_pay_id);
            ipPay.setIns_preservation_pay_id(ins_preservation_pay_id);
            ipPay.setParent_part_bill_id(ins_preservation_pay_id);
            String[] pays = ipPay.getPay_list().split(",");
            this.insertOrUpdate(ipPay);
            this.insPreservationPayAPIDao.updateParentPartBillId(ins_preservation_pay_id, "5", pays);
        }
        json.put("status", (Object)"200");
        json.put("msg", (Object)"\u90e8\u5206\u8d26\u5355\u5b8c\u6210\u5408\u5e76");
        return json;
    }

    @Override
    public JSONObject createPartBillByNo(String isSummaryBill, String[] payNos) {
        String payIds = this.insPreservationPayAPIDao.findPayIdsByPayNos(payNos);
        return this.createPartBill(isSummaryBill, payIds.split(","));
    }

    @Override
    public InsPreservationPayVo findIPPayVoById(Long oid) {
        return this.insPreservationPayAPIDao.findInsPreservationPayVoById(oid);
    }

    @Override
    public InsPreservationPayVo findInsPreservationPayVoById(Long oid) {
        InsPreservationPayVo vo = this.insPreservationPayAPIDao.findInsPreservationPayVoById(oid);
        vo.setInsPreservationRecordVoList(this.insPreservationRecordAPIService.findInsPreservationRecordVoByPayId(null, oid, ""));
        return vo;
    }

    @Override
    public String uploadFile(MultipartFile roleFile, String savePath) {
        String result = "";
        if (!roleFile.isEmpty()) {
            try {
                String fileName = roleFile.getOriginalFilename();
                String materialFileType = fileName.split("\\.")[1];
                String files = DateUtil.generatorRadomNumber() + "." + materialFileType;
                result = savePath + files;
                String path = GlobalResources.COM_IMG_RE + savePath;
                FileHelp.mFile((MultipartFile)roleFile, (String)path, (String)files);
                result = "/getResource?path=" + result;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = "";
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        return result;
    }

    @Override
    public boolean savePayPath(Long oid, String path) {
        boolean flag = true;
        try {
            InsPreservationPay insPreservationPay = (InsPreservationPay)this.selectById(oid);
            if (StringUtils.isNotEmpty((String)insPreservationPay.getPay_order_path())) {
                path = insPreservationPay.getPay_order_path() + "||" + path;
            }
            insPreservationPay.setPay_order_path(path);
            insPreservationPay.setPay_status("2");
            this.updateById(insPreservationPay);
        }
        catch (Exception e) {
            flag = false;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    private void sendEmailByCheckPending(InsPreservationPay ipp) {
        SysClientUser user = (SysClientUser)this.userService.selectById(ipp.getSys_client_user_id());
        String[] arrs = this.comDeployConfigService.getValueByKey("exmail").split(";");
        EmailModel emailModel = new EmailModel(EmailMsgRecordType.PAY_CHECK_PENDING, user.getReal_name() == null ? "-" : user.getReal_name(), user.getLogin_name(), ipp.getExternal_reference(), DateUtil.convertDateToString((Date)ipp.getStar_pay_time(), (String)"yyyy-MM-dd"), DateUtil.convertDateToString((Date)ipp.getEnd_pay_time(), (String)"yyyy-MM-dd"));
        this.log.info("\u4fdd\u5168\u7f34\u8d39\u4e0a\u4f20\u652f\u4ed8\u51ed\u8bc1\u90ae\u4ef6\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + emailModel.getContent());
        ArrayList<String> emailList = new ArrayList<String>();
        for (int i = 0; i < arrs.length; ++i) {
            if (!StringUtils.isNotBlank((String)arrs[i]) || arrs[i].contains(":")) continue;
            emailList.add(arrs[i].trim());
            this.log.info("\u4fdd\u5168\u7f34\u8d39\u4e0a\u4f20\u652f\u4ed8\u51ed\u8bc1\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-" + (i + 1) + "\uff09:" + arrs[i]);
        }
        if (emailList.size() > 0) {
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
        }
    }

    @Override
    public void findInsPreservationPayByPaymentType(String paymentType) {
        List<String> idList = this.insPreservationPayAPIDao.findInsPreservationPayIdsByPaymentType(paymentType);
        if (idList.size() > 0) {
            this.insPreservationPayAPIDao.updateStatusById("1", (String[])idList.toArray());
        }
    }

    @Override
    public void createInsPreservationBillByThisMonth(String lastMonth) {
        List<InsPreservationPay> ippInitList = this.insPreservationPayAPIDao.selectRecordBillBylastMonth(lastMonth);
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        for (InsPreservationPay ipPay : ippInitList) {
            Long ins_preservation_pay_id = idWorker.nextId();
            ipPay.setExternal_reference("ZD" + ins_preservation_pay_id);
            ipPay.setIns_preservation_pay_id(ins_preservation_pay_id);
            String[] pays = ipPay.getPay_list().split(",");
            this.insertOrUpdate(ipPay);
            this.insPreservationPayAPIDao.updateParentPayId(ins_preservation_pay_id, pays);
        }
    }

    @Override
    public void createInsPreservationPayByThisMonth(String policyNo, Date star, Date end) {
        try {
            List<InsPreservationPay> ippInitList = this.insPreservationPayAPIDao.selectNotHavePayByThisMonth(policyNo, star, end);
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            for (InsPreservationPay ipPay : ippInitList) {
                ipPay.setIns_preservation_pay_id(Long.valueOf(idWorker.nextId()));
                this.insertOrUpdate(ipPay);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean setIPPay(InsPreservationRecord record, Map<String, String> map) {
        try {
            Date star = DateUtil.convertString2Date((String)(DateUtil.convertDateToString((Date)DateUtil.getFirstDayOfThisMonth(), (String)"yyyy-MM-dd") + " 00:00:00"));
            Date end = DateUtil.convertString2Date((String)(DateUtil.convertDateToString((Date)DateUtil.getLastDayOfThisMonth(), (String)"yyyy-MM-dd") + " 23:59:59"));
            InsPreservationPay ipPay = this.insPreservationPayAPIDao.getPayExAndMonth(record.getExternal_reference(), star, end);
            if (ipPay == null) {
                this.createInsPreservationPayByThisMonth(record.getExternal_reference(), star, end);
                ipPay = this.insPreservationPayAPIDao.getPayExAndMonth(record.getExternal_reference(), star, end);
            }
            String payStatus = "4";
            BigDecimal premium = record.getTotal_premium();
            int recordCount = ipPay.getRecord_count();
            int addCount = ipPay.getAdd_count();
            int minusCount = ipPay.getMinus_count();
            int replaceCount = ipPay.getReplace_count();
            BigDecimal predictTotal = ipPay.getPredict_total_amount();
            predictTotal = predictTotal.add(premium);
            record.setIns_preservation_pay_id(ipPay.getIns_preservation_pay_id());
            this.insPreservationRecordAPIService.updateById(record);
            this.insPreservationResultSetAPIService.updateResultSet(record.getIns_preservation_record_id(), record.getRevise_type());
            ipPay.setPay_status(payStatus);
            ipPay.setRecord_count(++recordCount);
            ipPay.setAdd_count(addCount += record.getAdd_count());
            ipPay.setReplace_count(replaceCount += record.getReplace_count());
            ipPay.setMinus_count(minusCount += record.getMinus_count());
            ipPay.setPredict_total_amount(predictTotal);
            if (!this.insertOrUpdate(ipPay)) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5168\u7f34\u8d39\u4fe1\u606f\u521d\u59cb\u5316\u63d2\u5165\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }

    @Override
    public boolean updatePayStatusBySerialNum(String serial_num) {
        InsPreservationPay pay;
        InsPreservationRecord record = this.insPreservationRecordAPIService.findInsPreservationRecordByBySerialNum(serial_num);
        if (record != null && (pay = (InsPreservationPay)this.selectById(record.getIns_preservation_pay_id())) != null) {
            pay.setPay_status("3");
            pay.setFact_total_amount(pay.getPredict_total_amount());
            pay.setEnd_pay_time(new Date());
            this.updateById(pay);
            return true;
        }
        return false;
    }

    @Override
    public Result getFP(Long oid) {
        InsPreservationPay pay = (InsPreservationPay)this.selectById(oid);
        if (pay == null) {
            return Result.fail((String)"\u8d26\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.isNotEmpty((String)pay.getFp_url())) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)pay.getFp_url());
        }
        pay.setIs_fp(1);
        this.insPreservationPayAPIDao.updateById(pay);
        return Result.success((String)"\u7533\u8bf7\u5df2\u6210\u529f\u63d0\u4ea4\uff01");
    }

    @Override
    public boolean getFPTask(Long oid) {
        InsPreservationPay pay = (InsPreservationPay)this.selectById(oid);
        if (pay == null) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)pay.getFp_url())) {
            return true;
        }
        String rec = this.insPreservationPayAPIDao.getRecordCode(oid);
        if (StringUtils.isEmpty((String)rec)) {
            return true;
        }
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(pay.getIns_insurance_slip_id());
        if (vo == null) {
            return true;
        }
        String result = "300#\u8be5\u4fdd\u5355\u672a\u5f00\u901a\u5728\u7ebf\u5f00\u7968\u529f\u80fd";
        if (vo.getProduct_code().contains("GZZRX-CA")) {
            result = this.gZZRX_CARequestService.request_ca_dzfp(pay.getIns_insurance_slip_id(), "22", rec, DateUtil.convertDateToString((Date)pay.getStar_pay_time(), (String)"yyyy-MM-dd"), DateUtil.convertDateToString((Date)pay.getEnd_pay_time(), (String)"yyyy-MM-dd"));
        } else if (vo.getProduct_code().contains("TYX-CA")) {
            result = this.tYX_CARequestService.request_ca_dzfp(pay.getIns_insurance_slip_id(), "22", rec, DateUtil.convertDateToString((Date)pay.getStar_pay_time(), (String)"yyyy-MM-dd"), DateUtil.convertDateToString((Date)pay.getEnd_pay_time(), (String)"yyyy-MM-dd"));
        }
        if (result.contains("200#")) {
            String url = result.replace("200#", "");
            url = url.replace("*", "#");
            this.insPreservationPayAPIDao.updateFpUrl(oid, url);
            return true;
        }
        return false;
    }
}

