/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.SpecialLitigationAPIDao;
import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.service.order.LnAccusedAPIService;
import com.bcxin.ins.service.order.SpecialLitigationAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SpecialLitigationAPIServiceImpl
extends ServiceImpl<SpecialLitigationAPIDao, SpecialLitigation>
implements SpecialLitigationAPIService {
    @Autowired
    private SpecialLitigationAPIDao dao;
    @Autowired
    private LnAccusedAPIService lnAccusedService;

    @Override
    public SpecialLitigation getSpecialLitigationBusiness(Long oid) {
        SpecialLitigation specialLitigation = this.dao.selectById(oid);
        if (specialLitigation != null) {
            this.setLnAccused(specialLitigation);
        }
        return specialLitigation;
    }

    @Override
    public SpecialLitigation initSpecialLitigation() {
        SpecialLitigation specialLitigation = new SpecialLitigation();
        this.dao.insert(specialLitigation);
        return specialLitigation;
    }

    private void setLnAccused(SpecialLitigation specialLitigation) {
        List<LnAccused> insLnAccusedList = this.lnAccusedService.selectLnAccusedBySpecialLitigation(specialLitigation.getSpecial_litigation_id());
        if (insLnAccusedList.size() > ConstProp.INT_NUMBER_ZERO) {
            specialLitigation.setLn_accused(insLnAccusedList);
        }
    }

    @Override
    public void getSpecialLitigationVo_1BySpecial_id(SpecialLitigationVo_1 vo, Long ceID) {
        SpecialLitigation specialLitigation = this.getSpecialLitigationBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)specialLitigation), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setLnAccusedVo(this.lnAccusedService.packagingLnAccusedVoListByLnAccusedList(specialLitigation.getLn_accused()));
    }

    @Override
    public void getSpecialLitigationVo_2BySpecial_id(SpecialLitigationVo_2 vo, Long ceID) {
        SpecialLitigation specialLitigation = this.getSpecialLitigationBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)specialLitigation), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getSpecialLitigationVo_3BySpecial_id(SpecialLitigationVo_3 vo, Long ceID) {
        SpecialLitigation specialLitigation = this.getSpecialLitigationBusiness(ceID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)specialLitigation), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void accordingToTheSpecialLitigationVo_1SetUpSpecialLitigation(SpecialLitigationVo_1 vo, Long special_id) {
        SpecialLitigation specialLitigation = this.getSpecialLitigationBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)specialLitigation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lnAccusedService.setLnAccusedByLnAccusedVo(vo.getLnAccusedVo(), specialLitigation.getSpecial_litigation_id());
        this.dao.updateById(specialLitigation);
    }

    @Override
    public void accordingToTheSpecialLitigationVo_2SetUpSpecialLitigation(SpecialLitigationVo_2 vo, Long special_id) {
        SpecialLitigation specialLitigation = this.getSpecialLitigationBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)specialLitigation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(specialLitigation);
    }

    @Override
    public void accordingToTheSpecialLitigationVo_3SetUpSpecialLitigation(SpecialLitigationVo_3 vo, Long special_id) {
        SpecialLitigation specialLitigation = this.getSpecialLitigationBusiness(special_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)specialLitigation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(specialLitigation);
    }
}

