/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsTransactionAPIDao;
import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.service.order.InsAgreementAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.TransactionVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsTransactionAPIServiceImpl
extends ServiceImpl<InsTransactionAPIDao, InsTransaction>
implements InsTransactionAPIService {
    @Autowired
    private InsTransactionAPIDao dao;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipAPIService;
    @Autowired
    private InsAgreementAPIService insAgreementService;
    @Autowired
    private InsRoleInpolicyAPIService insRolieInpolicyAPIService;
    @Autowired
    private InsProductAPIService insProductAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;

    @Override
    public List<InsTransaction> selectInsTransactionByInsOrderForm(Long oid) {
        return this.dao.selectInsTransactionByInsOrderForm(oid);
    }

    @Override
    public InsTransaction initInsTransaction() {
        InsTransaction insTransaction = new InsTransaction();
        insTransaction.setStart_time(new Date());
        this.dao.insert(insTransaction);
        return insTransaction;
    }

    @Override
    public List<TransactionVo> packagingTransactionVoListByInsTransactionList(List<InsTransaction> itList) {
        ArrayList<TransactionVo> voList = new ArrayList<TransactionVo>();
        for (InsTransaction it : itList) {
            voList.add(this.accordingToInsTransactionIntoTransactionVo(it));
        }
        return voList;
    }

    @Override
    public void accordingToTheTransactionVoSetUpInsTransaction(TransactionVo vo, Long insTransaction_id) {
        InsTransaction insTransaction = null;
        insTransaction = StrUtil.isNotBlank((CharSequence)vo.getOid()) ? this.dao.selectById(Long.parseLong(vo.getOid())) : this.initInsTransaction();
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(insTransaction);
    }

    @Override
    public TransactionVo accordingToInsTransactionIntoTransactionVo(InsTransaction insTransaction) {
        TransactionVo vo = new TransactionVo();
        if (insTransaction == null) {
            return vo;
        }
        vo.setOid(String.valueOf(insTransaction.getIns_transaction_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insTransaction), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public void setOrderFormVoOfShowUrlByOrderID(OrderFormVo vo, Long order_id) {
        List<InsTransaction> insTransactionList = this.selectInsTransactionByInsOrderForm(order_id);
        if (insTransactionList.size() > ConstProp.INT_NUMBER_ZERO) {
            InsTransaction insTransaction = insTransactionList.get(ConstProp.INT_NUMBER_ZERO);
            vo.setPay_methods(insTransaction.getPay_type());
            vo.setPay_order_number(insTransaction.getPay_order_number());
            if (StrUtil.isNotBlank((CharSequence)insTransaction.getDeal_url())) {
                vo.setShow_url(insTransaction.getDeal_url());
            }
        }
        String p_p = "";
        for (InsTransaction it : insTransactionList) {
            if (!StringUtils.isNotEmpty((String)it.getPay_order_url())) continue;
            p_p = p_p + "," + it.getPay_order_url();
        }
        vo.setPay_order_url(p_p);
    }

    @Override
    public void uploadPayMentFileToTranction(String path_url, InsInsuranceSlip order, String path_sign, String payAmount, String paymentMethod) {
        InsTransaction it = this.getTranctionByorderIDAndStatus(order.getIns_insurance_slip_id());
        if (it == null) {
            it = new InsTransaction();
            it.setStart_time((Date)DateUtil.getTimestamp());
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            it.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            it.setPay_type(paymentMethod);
            String payment_way = "1";
            if (order.getUnderwrite() != null) {
                payment_way = order.getUnderwrite().getPayment_way();
            }
            it.setPayment_method(payment_way);
            it.setUser_id(order.getRegister_user_id());
            it.setInsurance_slip(order);
            it.setTransaction_status("2");
            this.dao.insert(it);
        } else {
            it.setUpdate_time((Date)DateUtil.getTimestamp());
            it.setEnd_time((Date)DateUtil.getTimestamp());
        }
        it.setPay_amount(new BigDecimal(payAmount));
        it.setPath_sign(path_sign);
        it.setPay_order_url(path_url);
        this.dao.updateById(it);
    }

    @Override
    public InsTransaction getTranctionByorderIDAndStatus(Long order_id) {
        List<InsTransaction> insTransactionList = this.selectInsTransactionByInsOrderForm(order_id);
        if (insTransactionList == null) {
            return null;
        }
        for (InsTransaction it : insTransactionList) {
            if (!"2".equals(it.getTransaction_status())) continue;
            return it;
        }
        return null;
    }

    @Override
    public void saveTransaction(PolicyTransactionVo vo) {
        if (vo.getOid() != null) {
            return;
        }
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipAPIService.selectById(Long.parseLong(vo.getPolicy_id()));
        if (StrUtil.isNotBlank((CharSequence)vo.getPayment_method())) {
            InsTransaction insTransaction = null;
            List<InsTransaction> insTransactionList = this.selectInsTransactionByInsOrderForm(Long.parseLong(vo.getPolicy_id()));
            if (insTransactionList.size() > 0) {
                insTransaction = insTransactionList.get(0);
            } else {
                insTransaction = this.initInsTransaction();
                insTransaction.setInsurance_slip(insInsuranceSlip);
            }
            if (StringUtils.isNotEmpty((String)vo.getTrade_serial_number())) {
                insTransaction.setTrade_serial_number(vo.getTrade_serial_number());
            }
            insTransaction.setPayment_method(vo.getPayment_method());
            if (StringUtils.isEmpty((String)insTransaction.getPay_type())) {
                insTransaction.setPay_type(vo.getPay_type());
            }
            if (vo.getOut_of_pocket() != null) {
                insTransaction.setOut_of_pocket(vo.getOut_of_pocket());
            }
            if (insTransaction.getPay_amount() == null || BigDecimal.ZERO.equals(insTransaction.getPay_amount())) {
                insTransaction.setPay_amount(vo.getPay_amount());
            }
            if (StringUtils.isEmpty((String)insTransaction.getPay_order_url())) {
                insTransaction.setPay_order_url(vo.getPay_order_url());
            }
            insTransaction.setPay_order_number(vo.getPay_order_number());
            if (StringUtils.isNotEmpty((String)vo.getPath_sign())) {
                insTransaction.setPath_sign(vo.getPath_sign());
            } else {
                OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(insInsuranceSlip.getIns_insurance_slip_id());
                insTransaction.setPath_sign("1".equals(orderVo.getPay_methods()) ? "1" : "");
            }
            insTransaction.setDeal_url(vo.getDeal_url());
            insTransaction.setEnd_time(vo.getEnd_time());
            insTransaction.setTransaction_status(vo.getTransaction_status());
            insTransaction.setUser_id(vo.getUser_id());
            this.dao.updateById(insTransaction);
        }
        if (StrUtil.isBlank((String)vo.getPolicy_serial_number())) {
            return;
        }
        insInsuranceSlip.setPolicy_serial_number(vo.getPolicy_serial_number());
        if (!"6".equals(vo.getPay_type())) {
            if (vo.getOut_of_pocket() != null) {
                insInsuranceSlip.setPremium(vo.getOut_of_pocket());
            }
            if (vo.getPay_amount() != null) {
                insInsuranceSlip.setPremium(vo.getPay_amount());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getNotice_no())) {
            insInsuranceSlip.setNotice_no(vo.getNotice_no());
        }
        this.insInsuranceSlipAPIService.updateById(insInsuranceSlip);
    }

    @Override
    public void updateTransaction(PolicyTransactionVo vo) {
        if (StrUtil.isNotBlank((CharSequence)vo.getPolicy_id())) {
            InsTransaction insTransaction = null;
            List<InsTransaction> insTransactionList = this.selectInsTransactionByInsOrderForm(Long.parseLong(vo.getPolicy_id()));
            if (insTransactionList.size() <= 0) {
                return;
            }
            insTransaction = insTransactionList.get(0);
            if (StringUtils.isNotEmpty((String)vo.getTrade_serial_number())) {
                insTransaction.setTrade_serial_number(vo.getTrade_serial_number());
            }
            if (StringUtils.isEmpty((String)insTransaction.getPay_type())) {
                insTransaction.setPay_type(vo.getPay_type());
            }
            insTransaction.setPay_order_number(vo.getPay_order_number());
            insTransaction.setEnd_time(vo.getEnd_time());
            this.dao.updateById(insTransaction);
        }
    }

    @Override
    public void savePolicyOther(PolicyTransactionVo vo) {
        InsInsuranceSlip insInsuranceSlip = (InsInsuranceSlip)this.insInsuranceSlipAPIService.selectById((Serializable)((Object)vo.getPolicy_id()));
        if (insInsuranceSlip == null) {
            return;
        }
        InsAgreement insAgreement = this.insAgreementService.selectInsAgreementByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
        if (insAgreement == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)vo.getLg_path())) {
            insInsuranceSlip.setLg_path(vo.getLg_path());
            insAgreement.setLg_path(vo.getLg_path());
        }
        if (StringUtils.isNotEmpty((String)vo.getInsure_path())) {
            insInsuranceSlip.setInsure_path(vo.getInsure_path());
            insAgreement.setInsure_path(vo.getInsure_path());
        }
        this.insInsuranceSlipAPIService.updateById(insInsuranceSlip);
        this.insAgreementService.updateById(insAgreement);
    }

    @Override
    public void savePolicyExternalReference(PolicyTransactionVo vo) {
        InsInsuranceSlip insInsuranceSlip = (InsInsuranceSlip)this.insInsuranceSlipAPIService.selectById((Serializable)((Object)vo.getPolicy_id()));
        Long orderId = Long.parseLong(vo.getPolicy_id());
        List<InsTransaction> list = this.dao.selectInsTransactionByInsOrderForm(orderId);
        if (list != null && list.size() > 0) {
            InsTransaction insTransaction = list.get(0);
            insTransaction.setTransaction_status("1");
            insTransaction.setEnd_time((Date)DateUtil.getTimestamp());
            insTransaction.setOut_of_pocket(insInsuranceSlip.getPremium());
            insTransaction.setPath_sign("1");
            this.dao.updateById(insTransaction);
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getPolicy_number())) {
            this.insAgreementService.willInsurePolicyVoChangeIntoInsAgreement(insInsuranceSlip.getIns_insurance_slip_id(), vo.getPolicy_number());
            OrderFormVo orderVo = new OrderFormVo();
            orderVo.setOid(vo.getPolicy_id());
            orderVo.setPolicy_status("6");
            this.policyService.updateOrderFormStatus(orderVo);
            ThreadUtil.excAsync(() -> this.otherCZ(insInsuranceSlip.getIns_insurance_slip_id(), insInsuranceSlip.getPro_primary().getPro_primary_id()), (boolean)false);
        }
    }

    @Override
    public void savePolicyExternalReference_16(PolicyTransactionVo vo) {
        InsInsuranceSlip insInsuranceSlip = (InsInsuranceSlip)this.insInsuranceSlipAPIService.selectById((Serializable)((Object)vo.getPolicy_id()));
        Long orderId = Long.parseLong(vo.getPolicy_id());
        if (StrUtil.isNotBlank((CharSequence)vo.getPolicy_number())) {
            OrderFormVo orderVo = new OrderFormVo();
            orderVo.setOid(vo.getPolicy_id());
            orderVo.setPolicy_status("16");
            this.policyService.updateOrderFormStatus(orderVo);
            this.insAgreementService.willInsurePolicyVoChangeIntoInsAgreement(insInsuranceSlip.getIns_insurance_slip_id(), vo.getPolicy_number());
            ThreadUtil.excAsync(() -> this.otherCZ(insInsuranceSlip.getIns_insurance_slip_id(), insInsuranceSlip.getPro_primary().getPro_primary_id()), (boolean)false);
        }
    }

    @Override
    public void otherCZ(Long order_id, Long pro_id) {
        ProPrimary product = this.insProductAPIService.getProduct(pro_id);
        if (StringUtils.isEmpty((String)product.getProduct_code())) {
            return;
        }
        if (product.getProduct_code().contains("TYX") || product.getProduct_code().contains("GZZRX")) {
            this.insPreservationResultSetAPIService.initResultSetByOrderId(order_id);
        }
    }

    @Override
    public void updateTransationMsg(PolicyTransactionVo vo) {
        List<InsTransaction> list = this.dao.selectInsTransactionByInsOrderForm(Long.parseLong(vo.getPolicy_id()));
        if (list != null && list.size() > 0) {
            InsTransaction insTransaction = list.get(0);
            insTransaction.setTransaction_status("1");
            insTransaction.setEnd_time(vo.getEnd_time());
            insTransaction.setOut_of_pocket(vo.getOut_of_pocket());
            insTransaction.setPath_sign("1");
            this.dao.updateById(insTransaction);
        }
    }

    @Override
    public void savePolicyExternalReferenceToDB(PolicyTransactionVo vo) {
        InsInsuranceSlip insInsuranceSlip = (InsInsuranceSlip)this.insInsuranceSlipAPIService.selectById((Serializable)((Object)vo.getPolicy_id()));
        if (StrUtil.isNotBlank((CharSequence)vo.getPolicy_number())) {
            this.insAgreementService.willInsurePolicyVoChangeIntoInsAgreement(insInsuranceSlip.getIns_insurance_slip_id(), vo.getPolicy_number());
            ProPrimary proPrimary = this.insProductAPIService.getProduct(insInsuranceSlip.getPro_primary().getPro_primary_id());
        }
    }

    @Override
    public String accordingToOrderIDGainPathSign(String order_id) {
        List<InsTransaction> insTransactionList = this.selectInsTransactionByInsOrderForm(Long.parseLong(order_id));
        String pathSign = "1-0";
        if (insTransactionList == null) {
            return pathSign;
        }
        for (InsTransaction it : insTransactionList) {
            if (!"2".equals(it.getTransaction_status())) continue;
            pathSign = it.getPath_sign() + "-1";
        }
        if ("1-0".equals(pathSign)) {
            pathSign = String.valueOf(insTransactionList.size() + 1) + "-0";
        }
        return pathSign;
    }
}

