/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsRoleInpolicyAPIDao;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsRoleFavoreeAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsRoleInpolicyAPIServiceImpl
extends ServiceImpl<InsRoleInpolicyAPIDao, InsRoleInpolicy>
implements InsRoleInpolicyAPIService {
    @Autowired
    private InsRoleInpolicyAPIDao dao;
    @Autowired
    private InsRoleFavoreeAPIService insRoleFavoreeService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;

    @Override
    public List<InsRoleInpolicy> selectInsRoleInpolicyByInsInsuranceSlip(Long oid) {
        return this.dao.selectInsRoleInpolicyByInsInsuranceSlip(oid);
    }

    @Override
    public List<InsRoleInpolicy> findInsRoleInpolicyByPolicyAndKeywordForPage(DwzPage page, Long policyId, String keyword) {
        List<InsRoleInpolicy> roles;
        if (page != null) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            roles = this.dao.findInsRoleInpolicyByPolicyAndKeywordForPage((Page<InsRoleInpolicy>)pageHelper, policyId, keyword);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        } else {
            roles = this.dao.findInsRoleInpolicyByPolicyAndKeywordForPage(policyId, keyword);
        }
        return roles;
    }

    @Override
    public InsRoleInpolicy packagingInsRoleInpolicy(Long oid) {
        InsRoleInpolicy insRoleInpolicy = this.dao.selectById(oid);
        if (insRoleInpolicy != null) {
            insRoleInpolicy.setInsRoleFavoreeList(this.insRoleFavoreeService.selectInsRoleFavoreeByInsRoleInpolicy(insRoleInpolicy.getIns_role_inpolicy_id()));
        }
        return insRoleInpolicy;
    }

    @Override
    public List<InsRoleInpolicy> initInsRoleInpolicy(InsInsuranceSlip insInsuranceSlip, String roleType, String kind) {
        ArrayList<InsRoleInpolicy> roleLost = new ArrayList<InsRoleInpolicy>();
        InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
        if ("3".equals(kind)) {
            insRoleInpolicy.setKind("1");
            this.createRole(insRoleInpolicy, insInsuranceSlip, roleType);
            roleLost.add(insRoleInpolicy);
            insRoleInpolicy = new InsRoleInpolicy();
            insRoleInpolicy.setKind("2");
            this.createRole(insRoleInpolicy, insInsuranceSlip, roleType);
            roleLost.add(insRoleInpolicy);
        } else {
            insRoleInpolicy.setKind(kind);
            this.createRole(insRoleInpolicy, insInsuranceSlip, roleType);
            roleLost.add(insRoleInpolicy);
        }
        return roleLost;
    }

    @Override
    public void createRole(InsRoleInpolicy insRoleInpolicy, InsInsuranceSlip insInsuranceSlip, String roleType) {
        insRoleInpolicy.setRole_type(roleType);
        insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
        this.dao.insert(insRoleInpolicy);
    }

    @Override
    public void setRoleInPolicyByRoleCompanyVo(List<RoleSubjectVo> voList, Long policyID) {
        if (voList == null || voList.size() <= ConstProp.INT_NUMBER_ZERO) {
            return;
        }
        InsInsuranceSlip insInsuranceSlip = new InsInsuranceSlip();
        insInsuranceSlip.setIns_insurance_slip_id(policyID);
        ArrayList uRoles = Lists.newArrayList();
        ArrayList aRoles = Lists.newArrayList();
        for (RoleSubjectVo vo : voList) {
            if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
                this.pushUpdateList(insInsuranceSlip, uRoles, vo);
                continue;
            }
            this.pushSaveList(insInsuranceSlip, aRoles, vo);
        }
        if (aRoles.size() > 0) {
            this.dao.batchInsert(aRoles);
        }
        if (uRoles.size() > 0) {
            this.dao.batchUpdate(uRoles);
        }
    }

    private void pushSaveList(InsInsuranceSlip insInsuranceSlip, List<InsRoleInpolicy> aRoles, RoleSubjectVo vo) {
        if (!"3".equals(vo.getKind())) {
            InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
            insRoleInpolicy.setKind(vo.getKind());
            insRoleInpolicy.setIns_role_inpolicy_id(Long.valueOf(IdWorker.getId()));
            insRoleInpolicy.setRole_type(vo.getRole_type());
            insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
            insRoleInpolicy.setStatus(Integer.valueOf(1));
            this.setRole(vo, insRoleInpolicy);
            aRoles.add(insRoleInpolicy);
            return;
        }
        List<InsRoleInpolicy> roleList = this.initInsRoleInpolicy(insInsuranceSlip, vo.getRole_type(), vo.getKind());
        for (InsRoleInpolicy role : roleList) {
            this.updateRole(vo, role);
        }
    }

    private void pushUpdateList(InsInsuranceSlip insInsuranceSlip, List<InsRoleInpolicy> uRoles, RoleSubjectVo vo) {
        if (!"3".equals(vo.getKind())) {
            InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
            insRoleInpolicy.setIns_role_inpolicy_id(Long.valueOf(Long.parseLong(vo.getOid())));
            insRoleInpolicy.setKind(vo.getKind());
            insRoleInpolicy.setRole_type(vo.getRole_type());
            insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
            insRoleInpolicy.setStatus(Integer.valueOf(1));
            this.setRole(vo, insRoleInpolicy);
            uRoles.add(insRoleInpolicy);
            return;
        }
        List<InsRoleInpolicy> roleList = this.selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
        for (InsRoleInpolicy role : roleList) {
            this.updateRole(vo, role);
        }
    }

    @Override
    public void accordingToTheRoleSubjectVoSetUpInsRoleInpolicy(RoleSubjectVo vo, InsInsuranceSlip insInsuranceSlip) {
        InsRoleInpolicy insRoleInpolicy = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            if ("3".equals(vo.getKind())) {
                List<InsRoleInpolicy> roleList = this.selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
                for (InsRoleInpolicy role : roleList) {
                    this.updateRole(vo, role);
                }
            } else {
                insRoleInpolicy = this.packagingInsRoleInpolicy(Long.parseLong(vo.getOid()));
                this.updateRole(vo, insRoleInpolicy);
            }
        } else {
            List<InsRoleInpolicy> roleList = this.initInsRoleInpolicy(insInsuranceSlip, vo.getRole_type(), vo.getKind());
            for (InsRoleInpolicy role : roleList) {
                this.updateRole(vo, role);
            }
        }
    }

    private void setRole(RoleSubjectVo vo, InsRoleInpolicy insRoleInpolicy) {
        insRoleInpolicy.setName_cn(vo.getName_cn());
        insRoleInpolicy.setName_en(vo.getName_en());
        vo.setKind(insRoleInpolicy.getKind());
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insRoleInpolicy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        insRoleInpolicy.setApp_business_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_business_path()) ? vo.getApp_business_path() : "0");
        insRoleInpolicy.setApp_address_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_address_path()) ? vo.getApp_address_path() : "0");
        insRoleInpolicy.setApp_idcard_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_idcard_path()) ? vo.getApp_idcard_path() : "0");
        insRoleInpolicy.setApp_organizing_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_organizing_path()) ? vo.getApp_organizing_path() : "0");
        insRoleInpolicy.setApp_spouse_card_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_spouse_card_path()) ? vo.getApp_spouse_card_path() : "0");
        insRoleInpolicy.setApp_tax_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_tax_path()) ? vo.getApp_tax_path() : "0");
        insRoleInpolicy.setApp_trauschein_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_trauschein_path()) ? vo.getApp_trauschein_path() : "0");
    }

    private void updateRole(RoleSubjectVo vo, InsRoleInpolicy insRoleInpolicy) {
        insRoleInpolicy.setName_cn(vo.getName_cn());
        insRoleInpolicy.setName_en(vo.getName_en());
        vo.setKind(insRoleInpolicy.getKind());
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insRoleInpolicy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        insRoleInpolicy.setApp_business_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_business_path()) ? vo.getApp_business_path() : "0");
        insRoleInpolicy.setApp_address_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_address_path()) ? vo.getApp_address_path() : "0");
        insRoleInpolicy.setApp_idcard_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_idcard_path()) ? vo.getApp_idcard_path() : "0");
        insRoleInpolicy.setApp_organizing_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_organizing_path()) ? vo.getApp_organizing_path() : "0");
        insRoleInpolicy.setApp_spouse_card_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_spouse_card_path()) ? vo.getApp_spouse_card_path() : "0");
        insRoleInpolicy.setApp_tax_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_tax_path()) ? vo.getApp_tax_path() : "0");
        insRoleInpolicy.setApp_trauschein_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_trauschein_path()) ? vo.getApp_trauschein_path() : "0");
        this.dao.updateById(insRoleInpolicy);
    }

    @Override
    public List<RoleSubjectVo> getRoleSubjectVoListByPolicyID(Long policyID) {
        return this.dao.selectRoleSubjectVoByInsInsuranceSlip(policyID);
    }

    @Override
    public RoleSubjectVo accordingToInsRoleInpolicyIntoRoleSubjectVo(InsRoleInpolicy role) {
        RoleSubjectVo vo = new RoleSubjectVo();
        vo.setName_cn(role.getName_cn());
        vo.setName_en(role.getName_en());
        vo.setOid(String.valueOf(role.getIns_role_inpolicy_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)role), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setApp_address_path("0".equals(role.getApp_address_path()) ? "" : role.getApp_address_path());
        vo.setApp_business_path("0".equals(role.getApp_business_path()) ? "" : role.getApp_business_path());
        vo.setApp_idcard_path("0".equals(role.getApp_idcard_path()) ? "" : role.getApp_idcard_path());
        vo.setApp_organizing_path("0".equals(role.getApp_organizing_path()) ? "" : role.getApp_organizing_path());
        vo.setApp_spouse_card_path("0".equals(role.getApp_spouse_card_path()) ? "" : role.getApp_spouse_card_path());
        vo.setApp_tax_path("0".equals(role.getApp_tax_path()) ? "" : role.getApp_tax_path());
        vo.setApp_trauschein_path("0".equals(role.getApp_trauschein_path()) ? "" : role.getApp_trauschein_path());
        return vo;
    }

    @Override
    public List<InsRoleInpolicy> getInsRoleInpolicyListByIDAndKind(Long oid, String kind) {
        HashMap columnMap = Maps.newHashMap();
        columnMap.put("insurance_slip_id", oid);
        columnMap.put("kind", kind);
        List roleList = this.dao.selectByMap(columnMap);
        return roleList;
    }

    @Override
    public int countInsurancedByID(Long oid) {
        return this.dao.countInsurancedByID(oid);
    }

    @Override
    public void createUserByRole(Long orderID) {
        InsInsuranceSlip insOrderForm = this.insInsuranceSlipService.selectById(orderID);
        List<InsRoleInpolicy> roleList = this.dao.getRoleInPolicyByOrderId(insOrderForm.getIns_insurance_slip_id(), "");
        ClientUserVo vo = null;
        ArrayList<ClientUserVo> voList = new ArrayList<ClientUserVo>();
        for (InsRoleInpolicy role : roleList) {
            if (!"2".equals(role.getKind())) continue;
            vo = new ClientUserVo();
            vo.setId_card(role.getOrganization_code());
            vo.setReal_name(role.getName_cn());
            vo.setTelephone(role.getMobile());
            voList.add(vo);
        }
    }

    @Override
    public boolean delectAllInsRole(Long order_id) {
        try {
            this.dao.delectAllInsRole(order_id);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, String> getTBBankByOrderId(Long order_id) {
        return this.dao.getTBBankByOrderId(order_id);
    }

    @Override
    public List<ResultSetExcelVo> selectRoleInPolicyListByOrderID(Long policyID) {
        return this.dao.selectRoleInPolicyListByOrderID(policyID);
    }

    @Override
    public InsPreservationResultSetVo setResultSetVo(Long role_id) {
        return this.dao.setResultSetVo(role_id);
    }

    @Override
    public String getOrgUrlByOrderID(Long policyID) {
        return this.dao.getOrgUrlByOrderID(policyID);
    }
}

