/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.dao.order.InsPaymentInfoAPIDao;
import com.bcxin.ins.entity.policy_report.InsPaymentInfo;
import com.bcxin.ins.service.order.InsPaymentInfoAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.vo.report_pac.InsPaymentInfoVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsPaymentInfoAPIServiceImpl
extends ServiceImpl<InsPaymentInfoAPIDao, InsPaymentInfo>
implements InsPaymentInfoAPIService {
    @Autowired
    private InsPaymentInfoAPIDao dao;

    @Override
    public InsPaymentInfo initInsPaymentInfo(Long user_id) {
        InsPaymentInfo insPaymentInfo = new InsPaymentInfo();
        insPaymentInfo.setCreate_time(new Date());
        insPaymentInfo.setCreate_by(new SysUser(user_id));
        this.dao.insert(insPaymentInfo);
        return insPaymentInfo;
    }

    @Override
    public void saveInsPaymentInfo(InsPaymentInfoVo vo, Long insPaymentInfoID) {
        if (vo == null) {
            return;
        }
        InsPaymentInfo insPaymentInfo = (InsPaymentInfo)this.dao.selectById(insPaymentInfoID);
        try {
            MyConverUtil.map2PoToString((Map)MyConverUtil.PO2Map((Object)vo), (Object)insPaymentInfo);
            insPaymentInfo.setUpdate_time(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateByIdForManual(insPaymentInfo);
    }

    @Override
    public void convertInsPaymentInfoVo(InsPaymentInfoVo vo, InsPaymentInfo insPaymentInfo) {
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insPaymentInfo), (Object)vo);
            if (vo.getProvince_name() != null) {
                vo.setBank_address(vo.getProvince_name() + " " + vo.getCity_name());
            }
            if (vo.getBank_account_attribute() != null) {
                vo.setBank_account_attribute_name("1".equals(vo.getBank_account_attribute()) ? "\u4e2a\u4eba\u8d26\u53f7" : "\u516c\u53f8\u8d26\u53f7");
            }
            if (vo.getClient_certificate_type() != null) {
                vo.setClient_certificate_type_name(IdType.convert_value((String)vo.getClient_certificate_type()).getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public InsPaymentInfoVo getInsPaymentInfoVo(Long insPaymentInfoID) {
        InsPaymentInfoVo vo = null;
        try {
            InsPaymentInfo insPaymentInfo = (InsPaymentInfo)this.dao.selectById(insPaymentInfoID);
            vo = new InsPaymentInfoVo();
            this.convertInsPaymentInfoVo(vo, insPaymentInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public void savePayDate(String pay_date, Long report_id) {
        this.dao.savePayDate(pay_date, report_id);
    }
}

