/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.auth;

import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.auth.DigestAuth;
import com.pingan.iobs.sdk.auth.EncodeUtils;
import com.pingan.iobs.sdk.auth.Mac;
import com.pingan.iobs.sdk.repkg.org.json.JSONException;
import com.pingan.iobs.sdk.repkg.org.json.JSONStringer;

public class PutPolicy {
    public String scope;
    public String callbackUrl;
    public String callbackBody;
    public String returnUrl;
    public String returnBody;
    public String endUser;
    public long expires;
    public String saveKey;
    public int insertOnly;
    public int detectMime;
    public long fsizeLimit;
    public String mimeLimit;
    public String persistentNotifyUrl;
    public String persistentOps;
    public long deadline;
    public String persistentPipeline;

    public PutPolicy() {
    }

    public PutPolicy(String scope) {
        this.scope = scope;
    }

    public String marshal() throws JSONException {
        JSONStringer stringer = new JSONStringer();
        stringer.object();
        stringer.key("scope").value(this.scope);
        if (this.callbackUrl != null && this.callbackUrl.length() > 0) {
            stringer.key("callbackUrl").value(this.callbackUrl);
        }
        if (this.callbackBody != null && this.callbackBody.length() > 0) {
            stringer.key("callbackBody").value(this.callbackBody);
        }
        if (this.returnUrl != null && this.returnUrl.length() > 0) {
            stringer.key("returnUrl").value(this.returnUrl);
        }
        if (this.returnBody != null && this.returnBody.length() > 0) {
            stringer.key("returnBody").value(this.returnBody);
        }
        if (this.saveKey != null && this.saveKey.length() > 0) {
            stringer.key("saveKey").value(this.saveKey);
        }
        if (this.insertOnly > 0) {
            stringer.key("insertOnly").value(this.insertOnly);
        }
        if (this.detectMime > 0) {
            stringer.key("detectMime").value(this.detectMime);
        }
        if (this.fsizeLimit > 0L) {
            stringer.key("fsizeLimit").value(this.fsizeLimit);
        }
        if (this.mimeLimit != null && this.mimeLimit.length() > 0) {
            stringer.key("mimeLimit").value(this.mimeLimit);
        }
        if (this.endUser != null && this.endUser.length() > 0) {
            stringer.key("endUser").value(this.endUser);
        }
        if (this.persistentNotifyUrl != null && this.persistentNotifyUrl.length() > 0) {
            stringer.key("persistentNotifyUrl").value(this.persistentNotifyUrl);
        }
        if (this.persistentOps != null && this.persistentOps.length() > 0) {
            stringer.key("persistentOps").value(this.persistentOps);
        }
        if (this.persistentPipeline != null && this.persistentPipeline.trim().length() > 0) {
            stringer.key("persistentPipeline").value(this.persistentPipeline);
        }
        stringer.key("deadline").value(this.deadline);
        stringer.endObject();
        return stringer.toString();
    }

    public String token(Mac mac, boolean isSdk) throws AuthException, JSONException {
        if (this.deadline == 0L) {
            if (this.expires == 0L || this.expires > 900L) {
                this.expires = 900L;
            }
            this.deadline = System.currentTimeMillis() / 1000L + this.expires;
        }
        byte[] data = EncodeUtils.toByte(this.marshal());
        if (isSdk) {
            return DigestAuth.signWithDataBySdk(mac, data);
        }
        return DigestAuth.signWithData(mac, data);
    }

    public String token(Mac mac) throws AuthException, JSONException {
        return this.token(mac, true);
    }
}

