/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.core.service;

import com.pingan.iobs.core.exception.IobsCoreException;
import com.pingan.iobs.core.model.request.BaseRequestParam;
import com.pingan.iobs.core.model.request.MkblkRequestParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FileService {
    @Value(value="${bigfile.nas.root.path}")
    private String nasAddr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFirstSliceToBlock(String blockPath, InputStream ins) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(blockPath);
            this.writeInsToFops(ins, fos);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ins);
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private void writeInsToFops(InputStream ins, FileOutputStream fos) throws IOException {
        int len;
        byte[] bytes = new byte[4096];
        while ((len = ins.read(bytes)) != -1) {
            fos.write(bytes, 0, len);
            fos.flush();
        }
    }

    public String initBlock(MkblkRequestParam requestParam) throws IOException {
        String blockDir = this.getBlockDirsPath(requestParam);
        com.pingan.iobs.core.util.FileUtils.createDirs(blockDir);
        return blockDir;
    }

    public String getBlockDirsPath(BaseRequestParam requestParam) {
        StringBuffer sb = new StringBuffer();
        return sb.append(this.nasAddr).append(File.separator).append(requestParam.getBucketInfo().getIobsName()).append(File.separator).append(requestParam.getKey()).toString();
    }

    public boolean judgeBlockIsExisted(String blockPath) throws IobsCoreException {
        File blockFile = new File(blockPath);
        if (blockFile.exists()) {
            return true;
        }
        throw new IobsCoreException(410, "Upload file lose efficacy, please upload again!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSliceToBlock(String blockPath, InputStream ins, int offset) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(blockPath, "rw");
            randomAccessFile.seek(offset);
            byte[] bytes = IOUtils.toByteArray((InputStream)ins);
            randomAccessFile.write(bytes);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            IOUtils.closeQuietly((InputStream)ins);
        }
    }

    public List<File> sortFileByName(String blockDir, String fileName) throws IobsCoreException {
        File file = new File(blockDir);
        if (!file.exists()) {
            throw new IobsCoreException(410, "Upload file lose efficacy, please upload again!");
        }
        List<File> blockList = Arrays.asList(file.listFiles());
        blockList = this.judgeAndRemoveBigFile(blockList, fileName);
        Collections.sort(blockList, new /* Unavailable Anonymous Inner Class!! */);
        return blockList;
    }

    private List<File> judgeAndRemoveBigFile(List<File> blockList, String bigFileName) {
        ArrayList<File> siftBlockList = new ArrayList<File>();
        for (File file : blockList) {
            if (file.getName().equals(bigFileName)) continue;
            siftBlockList.add(file);
        }
        return siftBlockList;
    }

    public String fileMD5(File file) throws Exception {
        return this.MD5(FileUtils.readFileToByteArray((File)file));
    }

    public String fileMD5(String filePath) throws Exception {
        File file = new File(filePath);
        return this.MD5(FileUtils.readFileToByteArray((File)file));
    }

    public String bigFileMD5(List<File> blockList) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (File file : blockList) {
            String md5 = this.MD5(FileUtils.readFileToByteArray((File)file));
            sb.append(md5);
        }
        return this.MD5(sb.toString().getBytes());
    }

    public String MD5(byte[] btInput) throws NoSuchAlgorithmException {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MessageDigest mdInst = MessageDigest.getInstance("MD5");
        mdInst.update(btInput);
        byte[] md = mdInst.digest();
        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File combineWholeFile(String blockDir, String fileName, List<File> blockList) throws IOException {
        File file;
        String bigFilePath = blockDir + File.separator + fileName;
        File bigFile = new File(bigFilePath);
        FileOutputStream fops = null;
        try {
            fops = new FileOutputStream(bigFile);
            this.loopWriteFile(fops, blockList);
            file = bigFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fops);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fops);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loopWriteFile(FileOutputStream fops, List<File> blockList) throws IOException {
        for (File file : blockList) {
            FileInputStream fins = null;
            try {
                fins = new FileInputStream(file);
                this.writeInsToFops(fins, fops);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fins);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fins);
        }
    }

    public void deleteBlockDir(String blockDir) throws IOException {
        FileUtils.deleteDirectory((File)new File(blockDir));
    }
}

