package tk.mybatis.springboot.startup;

import org.springframework.stereotype.Component;
import tk.mybatis.springboot.service.ConfigSystemService;
import tk.mybatis.springboot.util.HuaWeiRespConst;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Component
public class InitConfig {

	@Resource
	private ConfigSystemService configSystemService;

	/**
	 *
	 * <b>Function </b> 初始化环境，定位当前系统的环境
	 *
	 * @author LuoPeng
	 * @date 2016年12月20日 下午8:52:24
	 */
	@PostConstruct
	private void initConfig(){
		//HuaWeiRespConst.put("1","成功");
		//HuaWeiRespConst.put("-1","失败，截取异常");
		HuaWeiRespConst.put("DJ:0255","运营商拦截，一般是因为短信内容不允许发送。");
		HuaWeiRespConst.put("SC:0001","人工审核拦截");
		HuaWeiRespConst.put("SC:0002","人工审核告警拦截");
		HuaWeiRespConst.put("SC:0003","黑名单拦截");
		HuaWeiRespConst.put("SC:0004","红名单拦截");
		HuaWeiRespConst.put("SC:0005","投诉黑名单");
		HuaWeiRespConst.put("SC:0006","禁用关键字拦截");
		HuaWeiRespConst.put("SC:0007","特征关键字拦截");
		HuaWeiRespConst.put("SC:0008","管控关键字拦截");
		HuaWeiRespConst.put("SC:0009","缺失必备关键字");
		HuaWeiRespConst.put("SC:0010","短信超频拦截");
		HuaWeiRespConst.put("SC:0011","时段管控拦截");
		HuaWeiRespConst.put("SC:0012","人工审核超时处理");
		HuaWeiRespConst.put("SC:0013","签名黑名单拦截");
		HuaWeiRespConst.put("SC:0014","免审核模板匹配");
		HuaWeiRespConst.put("SC:0015","拦截模板匹配");
		HuaWeiRespConst.put("E200015","待发送短信数量太大");
		HuaWeiRespConst.put("E200028","模板变量校验失败");
		HuaWeiRespConst.put("E200029","模板类型校验失败");
		HuaWeiRespConst.put("E200030","模板未激活");
		HuaWeiRespConst.put("E200031","协议校验失败");
		HuaWeiRespConst.put("E200033","模板类型不正确");

		configSystemService.listInCache();
	}
	
}