package tk.mybatis.springboot.controller;

import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import tk.mybatis.springboot.service.ConfigSystemService;

import javax.annotation.Resource;

@Service
@EnableScheduling
public class SystemScheduleTask {

	@Resource
	private ConfigSystemService configSystemService;

	/**
	 * <b>定时任务，每隔5分钟读取一遍配置文件 </b>
	 */
	@Scheduled(cron="0 0/5 * * * ? ")
	public void reloadSystemConfig() {
		configSystemService.listInCache();
	}

}
