package com.bcxin.auth.web.controller.system;

import java.util.List;

import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysRegion;
import com.bcxin.auth.system.service.ISysRegionService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import com.bcxin.auth.common.annotation.Log;
import com.bcxin.auth.common.enums.BusinessType;
import com.bcxin.auth.common.core.controller.BaseController;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.utils.poi.ExcelUtil;
import com.bcxin.auth.common.core.page.TableDataInfo;

/**
 * 地区Controller
 * 
 * @author bcxin
 * @date 2021-01-22
 */
@Controller
@RequestMapping("/region")
public class SysRegionController extends BaseController
{
    private String prefix = "region";

    @Autowired
    private ISysRegionService sysRegionService;

    /**
     * 查询地区列表
     */
    @PostMapping("/list")
    @ResponseBody
    public List<SysRegion> list(SysRegion sysRegion)
    {
        return sysRegionService.selectSysRegionList(sysRegion);
    }

}
