/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.config;

import at.pollux.thymeleaf.shiro.dialect.ShiroDialect;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.utils.spring.SpringUtils;
import com.bcxin.auth.framework.shiro.realm.UserRealm;
import com.bcxin.auth.framework.shiro.session.OnlineSessionDAO;
import com.bcxin.auth.framework.shiro.session.OnlineSessionFactory;
import com.bcxin.auth.framework.shiro.web.filter.LogoutFilter;
import com.bcxin.auth.framework.shiro.web.filter.captcha.CaptchaValidateFilter;
import com.bcxin.auth.framework.shiro.web.filter.kickout.KickoutSessionFilter;
import com.bcxin.auth.framework.shiro.web.filter.online.OnlineSessionFilter;
import com.bcxin.auth.framework.shiro.web.filter.sync.SyncOnlineSessionFilter;
import com.bcxin.auth.framework.shiro.web.session.OnlineWebSessionManager;
import com.bcxin.auth.framework.shiro.web.session.SpringSessionValidationScheduler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Value(value="${shiro.session.expireTime}")
    private int expireTime;
    @Value(value="${shiro.session.validationInterval}")
    private int validationInterval;
    @Value(value="${shiro.session.maxSession}")
    private int maxSession;
    @Value(value="${shiro.session.kickoutAfter}")
    private boolean kickoutAfter;
    @Value(value="${shiro.user.captchaEnabled}")
    private boolean captchaEnabled;
    @Value(value="${shiro.user.captchaType}")
    private String captchaType;
    @Value(value="${shiro.cookie.domain}")
    private String domain;
    @Value(value="${shiro.cookie.path}")
    private String path;
    @Value(value="${shiro.cookie.httpOnly}")
    private boolean httpOnly;
    @Value(value="${shiro.cookie.maxAge}")
    private int maxAge;
    @Value(value="${shiro.cookie.cipherKey}")
    private String cipherKey;
    @Value(value="${shiro.user.loginUrl}")
    private String loginUrl;
    @Value(value="${shiro.user.unauthorizedUrl}")
    private String unauthorizedUrl;

    @Bean
    public EhCacheManager getEhCacheManager() {
        net.sf.ehcache.CacheManager cacheManager = net.sf.ehcache.CacheManager.getCacheManager((String)"om");
        EhCacheManager em = new EhCacheManager();
        if (StringUtils.isNull((Object)cacheManager)) {
            em.setCacheManager(new net.sf.ehcache.CacheManager(this.getCacheManagerConfigFileInputStream()));
            return em;
        }
        em.setCacheManager(cacheManager);
        return em;
    }

    protected InputStream getCacheManagerConfigFileInputStream() {
        String configFile = "classpath:ehcache/ehcache-shiro.xml";
        InputStream inputStream = null;
        try {
            ByteArrayInputStream in;
            inputStream = ResourceUtils.getInputStreamForPath((String)configFile);
            byte[] b = IOUtils.toByteArray((InputStream)inputStream);
            ByteArrayInputStream byteArrayInputStream = in = new ByteArrayInputStream(b);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to obtain input stream for cacheManagerConfigFile [" + configFile + "]", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Bean
    public UserRealm userRealm(EhCacheManager cacheManager) {
        UserRealm userRealm = new UserRealm();
        userRealm.setAuthorizationCacheName("sys-authCache");
        userRealm.setCacheManager((CacheManager)cacheManager);
        return userRealm;
    }

    @Bean
    public OnlineSessionDAO sessionDAO() {
        OnlineSessionDAO sessionDAO = new OnlineSessionDAO();
        return sessionDAO;
    }

    @Bean
    public OnlineSessionFactory sessionFactory() {
        OnlineSessionFactory sessionFactory = new OnlineSessionFactory();
        return sessionFactory;
    }

    @Bean
    public OnlineWebSessionManager sessionManager() {
        OnlineWebSessionManager manager = new OnlineWebSessionManager();
        manager.setCacheManager((CacheManager)this.getEhCacheManager());
        manager.setDeleteInvalidSessions(true);
        manager.setGlobalSessionTimeout(this.expireTime * 60 * 1000);
        manager.setSessionIdUrlRewritingEnabled(false);
        manager.setSessionValidationScheduler((SessionValidationScheduler)SpringUtils.getBean(SpringSessionValidationScheduler.class));
        manager.setSessionValidationSchedulerEnabled(true);
        manager.setSessionDAO((SessionDAO)this.sessionDAO());
        manager.setSessionFactory(this.sessionFactory());
        return manager;
    }

    @Bean
    public SecurityManager securityManager(UserRealm userRealm) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)userRealm);
        securityManager.setRememberMeManager((RememberMeManager)this.rememberMeManager());
        securityManager.setCacheManager((CacheManager)this.getEhCacheManager());
        securityManager.setSessionManager((SessionManager)this.sessionManager());
        return securityManager;
    }

    public LogoutFilter logoutFilter() {
        LogoutFilter logoutFilter = new LogoutFilter();
        logoutFilter.setLoginUrl(this.loginUrl);
        return logoutFilter;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        shiroFilterFactoryBean.setLoginUrl(this.loginUrl);
        shiroFilterFactoryBean.setUnauthorizedUrl(this.unauthorizedUrl);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/peopleInfo/**", "anon");
        filterChainDefinitionMap.put("/background/**", "anon");
        filterChainDefinitionMap.put("/oauth/**", "anon");
        filterChainDefinitionMap.put("/public/common/**", "anon");
        filterChainDefinitionMap.put("/favicon.ico**", "anon");
        filterChainDefinitionMap.put("/task.png**", "anon");
        filterChainDefinitionMap.put("/css/**", "anon");
        filterChainDefinitionMap.put("/good/**", "anon");
        filterChainDefinitionMap.put("/docs/**", "anon");
        filterChainDefinitionMap.put("/fonts/**", "anon");
        filterChainDefinitionMap.put("/img/**", "anon");
        filterChainDefinitionMap.put("/ajax/**", "anon");
        filterChainDefinitionMap.put("/js/**", "anon");
        filterChainDefinitionMap.put("/task/**", "anon");
        filterChainDefinitionMap.put("/company/**", "anon");
        filterChainDefinitionMap.put("/depart/**", "anon");
        filterChainDefinitionMap.put("/person/**", "anon");
        filterChainDefinitionMap.put("/auth/**", "anon");
        filterChainDefinitionMap.put("/dataSync/**", "anon");
        filterChainDefinitionMap.put("/manage/cer/**", "anon");
        filterChainDefinitionMap.put("/captcha/captchaImage**", "anon");
        filterChainDefinitionMap.put("/logout", "logout");
        filterChainDefinitionMap.put("/login", "anon,captchaValidate");
        filterChainDefinitionMap.put("/register", "anon,captchaValidate");
        LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();
        filters.put("onlineSession", (Object)this.onlineSessionFilter());
        filters.put("syncOnlineSession", (Object)this.syncOnlineSessionFilter());
        filters.put("captchaValidate", (Object)this.captchaValidateFilter());
        filters.put("kickout", (Object)this.kickoutSessionFilter());
        filters.put("logout", (Object)this.logoutFilter());
        shiroFilterFactoryBean.setFilters(filters);
        filterChainDefinitionMap.put("/**", "user,kickout,onlineSession,syncOnlineSession");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    public OnlineSessionFilter onlineSessionFilter() {
        OnlineSessionFilter onlineSessionFilter = new OnlineSessionFilter();
        onlineSessionFilter.setLoginUrl(this.loginUrl);
        onlineSessionFilter.setOnlineSessionDAO(this.sessionDAO());
        return onlineSessionFilter;
    }

    public SyncOnlineSessionFilter syncOnlineSessionFilter() {
        SyncOnlineSessionFilter syncOnlineSessionFilter = new SyncOnlineSessionFilter();
        syncOnlineSessionFilter.setOnlineSessionDAO(this.sessionDAO());
        return syncOnlineSessionFilter;
    }

    public CaptchaValidateFilter captchaValidateFilter() {
        CaptchaValidateFilter captchaValidateFilter = new CaptchaValidateFilter();
        captchaValidateFilter.setCaptchaEnabled(this.captchaEnabled);
        captchaValidateFilter.setCaptchaType(this.captchaType);
        return captchaValidateFilter;
    }

    public SimpleCookie rememberMeCookie() {
        SimpleCookie cookie = new SimpleCookie("rememberMe");
        cookie.setDomain(this.domain);
        cookie.setPath(this.path);
        cookie.setHttpOnly(this.httpOnly);
        cookie.setMaxAge(this.maxAge * 24 * 60 * 60);
        return cookie;
    }

    public CookieRememberMeManager rememberMeManager() {
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie((Cookie)this.rememberMeCookie());
        cookieRememberMeManager.setCipherKey(Base64.decode((String)this.cipherKey));
        return cookieRememberMeManager;
    }

    public KickoutSessionFilter kickoutSessionFilter() {
        KickoutSessionFilter kickoutSessionFilter = new KickoutSessionFilter();
        kickoutSessionFilter.setCacheManager((CacheManager)this.getEhCacheManager());
        kickoutSessionFilter.setSessionManager((SessionManager)this.sessionManager());
        kickoutSessionFilter.setMaxSession(this.maxSession);
        kickoutSessionFilter.setKickoutAfter(this.kickoutAfter);
        kickoutSessionFilter.setKickoutUrl("/login?kickout=1");
        return kickoutSessionFilter;
    }

    @Bean
    public ShiroDialect shiroDialect() {
        return new ShiroDialect();
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(@Qualifier(value="securityManager") SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }
}

