package com.bcxin.ferry.strategy.callback.impl;

import com.bcxin.ferry.common.queue.DetailFileQueue;
import com.bcxin.ferry.strategy.callback.ReceiveCallbackStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * description：接收明细文件回调策略
 * author：linchunpeng
 * date：2024/3/6
 */
@Slf4j
@Service
public class ReceiveDetailFileCallbackStrategy implements ReceiveCallbackStrategy {

    @Async(value = "taskExecutor")
    @Override
    public void handle(String data) {
        try {
            log.info("接收明细文件回调策略，回调参数放入队列");
            DetailFileQueue.DETAIL_FILE_CALLBACK_QUEUE.put(data);
            log.info("接收明细文件回调策略，回调参数放入队列，完成");
        } catch (InterruptedException e) {
            e.printStackTrace();
            log.error("接收明细文件回调策略，回调参数放入队列异常，{}", e.getMessage(), e);
        }
    }
}
