package com.bcxin.ferry.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

 /**
 * 摆渡异常信息表;
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Data
@TableName("ferry_error_info")
public class FerryErrorInfoEntity implements Serializable {

private static final long serialVersionUID = 1L;
    
    //主键id(文件id)
    @TableId(value = "id")
    private Long id;
    
    //摆渡任务id
    private Long ferryTaskId;
    
    //摆渡文件id
    private Long ferryFileId;
    
    //接收任务id
    private Long receiveTaskId;
    
    //接收文件id
    private Long receiveFileId;
    
    //异常消息
    private String errorMessage;
    
    //异常明细
    private String errorDetail;
    
    //处理状态，1-创建异常，2-已通知，3-已修复
    private Integer handleStatus;
    
    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    
    //更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}