/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.strategy.receive.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.emus.FileTypeEnum;
import com.bcxin.ferry.dtos.FerryFileDto;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import com.bcxin.ferry.strategy.receive.ReceiveStrategy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ReceiveTaskFileStrategy
implements ReceiveStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReceiveTaskFileStrategy.class);
    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="taskExecutor")
    public void handle(String data) {
        String lockKey = "REDISSON_LOCK_RECEIVE_TASK_FILE";
        log.info("\u63a5\u6536\u6446\u6e21\u4efb\u52a1\u6587\u4ef6\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(300L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            FerryFileDto ferryFileDto = (FerryFileDto)JSONObject.parseObject((String)data, FerryFileDto.class);
            log.info("\u63a5\u6536\u4efb\u52a1\u6587\u4ef6\u7b56\u7565\uff0c\u57fa\u672c\u53c2\u6570");
            log.info("ferryTaskId\uff1a{}", (Object)ferryFileDto.getFerryTaskId());
            log.info("requestId\uff1a{}", (Object)ferryFileDto.getRequestId());
            log.info("fileId\uff1a{}", (Object)ferryFileDto.getFileId());
            log.info("fileType\uff1a{}", (Object)ferryFileDto.getFileType());
            log.info("isPushZw\uff1a{}", (Object)ferryFileDto.getIsPushZw());
            String packageUrl = this.ferryReceiveTaskService.receiveRequest(ferryFileDto);
            if (StringUtils.isNotBlank((CharSequence)packageUrl)) {
                if (ferryFileDto.getFileType().intValue() != FileTypeEnum.NORMAL.getCode()) {
                    log.info("\u63a5\u6536\u6446\u6e21\u4efb\u52a1\u6587\u4ef6\uff0c\u9700\u8981\u8f6c\u6587\u4ef6\u7684base64\u5b57\u7b26\u4e32\uff0c\u6587\u4ef6id\uff1a{}", (Object)ferryFileDto.getFileId());
                    ferryFileDto.putFileContent(data);
                }
                List ferryTaskFileEntityList = this.ferryReceiveTaskService.parseTaskFile(ferryFileDto);
                this.ferryReceiveTaskService.initTaskInfo(ferryFileDto, ferryTaskFileEntityList, packageUrl);
                this.ferryReceiveTaskService.taskFileCallback(ferryFileDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a5\u6536\u6446\u6e21\u4efb\u52a1\u6587\u4ef6\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u63a5\u6536\u6446\u6e21\u4efb\u52a1\u6587\u4ef6\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
    }
}

