/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.strategy.callback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.dtos.FerryFileCallbackDto;
import com.bcxin.ferry.entity.FerryTaskFileEntity;
import com.bcxin.ferry.service.FerryTaskFileService;
import com.bcxin.ferry.service.FerryTaskService;
import com.bcxin.ferry.strategy.callback.ReceiveCallbackStrategy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ReceiveTaskFileCallbackStrategy
implements ReceiveCallbackStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReceiveTaskFileCallbackStrategy.class);
    @Autowired
    private FerryTaskService ferryTaskService;
    @Autowired
    private FerryTaskFileService ferryTaskFileService;
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="taskExecutor")
    public void handle(String data) {
        String lockKey = "REDISSON_LOCK_RECEIVE_TASK_FILE_CALLBACK";
        log.info("\u63a5\u6536\u4efb\u52a1\u6587\u4ef6\u56de\u8c03\u7b56\u7565\uff0clockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(300L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            Long taskId = this.ferryTaskService.updateFerryTaskFileResult((FerryFileCallbackDto)JSONObject.parseObject((String)data, FerryFileCallbackDto.class));
            if (taskId != null) {
                this.ferryTaskService.sendFerryDetailFile(taskId);
                log.info("\u6446\u6e21\u4efb\u52a1\u660e\u7ec6\u6587\u4ef6");
                List ferryTaskFileEntityList = this.ferryTaskFileService.queryDetailFileByTaskId(taskId);
                for (FerryTaskFileEntity taskFileEntity : ferryTaskFileEntityList) {
                    log.info("\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\uff0ctaskId\uff1a{}\uff0c\u6587\u4ef6id\uff1a{}\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}", new Object[]{taskId, taskFileEntity.getId(), taskFileEntity.getFileName()});
                    this.ferryTaskFileService.ferryFileToBoundary(taskFileEntity, SendBoundaryUrlEnum.SEND_DETAIL_FILE);
                }
                log.info("\u6446\u6e21\u4efb\u52a1\u660e\u7ec6\u6587\u4ef6\u5b8c\u6210");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a5\u6536\u4efb\u52a1\u6587\u4ef6\u56de\u8c03\u7b56\u7565\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u63a5\u6536\u4efb\u52a1\u6587\u4ef6\u56de\u8c03\u7b56\u7565\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
    }
}

