/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.utils.HttpUtil;
import com.bcxin.ferry.configs.BoundaryServerConfig;
import com.bcxin.ferry.dtos.response.boundary.BoundaryResult;
import com.bcxin.ferry.dtos.response.boundary.BoundaryResultData;
import com.bcxin.ferry.service.FerryRequestLogService;
import com.google.common.util.concurrent.RateLimiter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class SendRequestToBoundaryService {
    private static final Logger log = LoggerFactory.getLogger(SendRequestToBoundaryService.class);
    @Autowired
    private BoundaryServerConfig boundaryServerConfig;
    @Autowired
    private FerryRequestLogService ferryRequestLogService;

    @Retryable(value={Exception.class}, maxAttempts=10, backoff=@Backoff(delay=5000L, maxDelay=60000L, multiplier=2.0))
    public BoundaryResult send(Map<String, Object> paramMap) {
        RateLimiter limiter = RateLimiter.create((double)10.0);
        limiter.acquire();
        String paramJson = JSONObject.toJSONString(paramMap);
        log.info("\u53d1\u9001\u8bf7\u6c42\u5230\u8fb9\u754c\u670d\u52a1");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("role_code", this.boundaryServerConfig.getRoleCode());
        String postResult = HttpUtil.post((String)this.boundaryServerConfig.getApi().getSendUrl(), (String)paramJson, headerMap);
        if ("fail".equals(postResult)) {
            log.error("\u8c03\u7528\u8fb9\u754c\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u8fb9\u754c\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        BoundaryResult result = (BoundaryResult)JSONObject.parseObject((String)postResult, BoundaryResult.class);
        log.info("\u53d1\u9001\u8bf7\u6c42\u5230\u8fb9\u754c\u670d\u52a1\u6210\u529f\uff0c\u8fd4\u56de\u503c\uff1a{}", (Object)postResult);
        String boundaryTaskId = null;
        if (!result.getStatus_code().equals("0")) {
            log.error("\u8c03\u7528\u8fb9\u754c\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u8fb9\u754c\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        boundaryTaskId = ((BoundaryResultData)result.getData().get(0)).getTask_id();
        return result;
    }
}

