/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.utils.Base64Util;
import com.bcxin.ferry.common.utils.HttpUtil;
import com.bcxin.ferry.configs.BaiduutilServerConfig;
import com.bcxin.ferry.dtos.baiduutil.ChangeLogsRequestDto;
import com.bcxin.ferry.dtos.baiduutil.FerryReceiveTaskPushResult;
import com.bcxin.ferry.dtos.baiduutil.FerryTaskPullResult;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.entity.FerryTaskEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class RetryService {
    private static final Logger log = LoggerFactory.getLogger(RetryService.class);
    @Autowired
    private BaiduutilServerConfig baiduutilServerConfig;
    @Value(value="${spring.profiles.active}")
    private String activeFile;

    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=10000L, maxDelay=60000L, multiplier=2.0))
    public void postToBaiduutilServerPull(FerryTaskEntity ferryTaskEntity) {
        JSONObject result;
        ChangeLogsRequestDto requestDto = new ChangeLogsRequestDto();
        requestDto.setFromTime(ferryTaskEntity.getStartTime());
        requestDto.setEndTime(ferryTaskEntity.getEndTime());
        requestDto.setRegionCodes(ferryTaskEntity.getRegionCode());
        requestDto.setTables(new ArrayList());
        requestDto.setAutoFerryTaskId(ferryTaskEntity.getId());
        boolean isZw = ferryTaskEntity.getRegionCode().equals("govout-to-govin");
        String pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(isZw).getPullUrl(), (String)JSONObject.toJSONString((Object)requestDto));
        if ("fail".equals(pullResult)) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        if ((result = JSONObject.parseObject((String)pullResult)).get((Object)"code") == null || result.getInteger("code") != 200) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
    }

    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=10000L, maxDelay=60000L, multiplier=2.0))
    public void postToBaiduutilServerPush(FerryReceiveTaskEntity receiveTaskEntity) {
        JSONObject result;
        boolean isZw;
        String pullResult;
        String isNeedUnzip = "?isNeedUnzip=false";
        if ("out-prod".equals(this.activeFile)) {
            isNeedUnzip = "?isNeedUnzip=true";
        }
        if ("fail".equals(pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(isZw = receiveTaskEntity.getIsPushZw() != null && receiveTaskEntity.getIsPushZw() == 1).getPushUrl().concat(receiveTaskEntity.getRequestId()).concat(isNeedUnzip), (String)"{}"))) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        if ((result = JSONObject.parseObject((String)pullResult)).get((Object)"code") == null || result.getInteger("code") != 200) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
    }

    public FerryTaskPullResult postToBaiduutilServerPullResult(FerryTaskEntity ferryTaskEntity) {
        ChangeLogsRequestDto requestDto = new ChangeLogsRequestDto();
        requestDto.setAutoFerryTaskId(ferryTaskEntity.getId());
        boolean isZw = ferryTaskEntity.getRegionCode().equals("govout-to-govin");
        String pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(isZw).getPullQueryResultUrl(), (String)JSONObject.toJSONString((Object)requestDto));
        if ("fail".equals(pullResult)) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            return null;
        }
        JSONObject result = JSONObject.parseObject((String)pullResult);
        if (result.get((Object)"id") == null) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            return null;
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
        return (FerryTaskPullResult)JSONObject.parseObject((String)pullResult, FerryTaskPullResult.class);
    }

    public FerryReceiveTaskPushResult postToBaiduutilServerPushResult(FerryReceiveTaskEntity receiveTaskEntity) {
        boolean isZw = receiveTaskEntity.getIsPushZw() != null && receiveTaskEntity.getIsPushZw() == 1;
        String pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(isZw).getPushQueryResultUrl().concat(receiveTaskEntity.getRequestId()), (String)"{}");
        if ("fail".equals(pullResult)) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            return null;
        }
        JSONObject result = JSONObject.parseObject((String)pullResult);
        if (result.get((Object)"requestId") == null) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            return null;
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
        return (FerryReceiveTaskPushResult)JSONObject.parseObject((String)pullResult, FerryReceiveTaskPushResult.class);
    }

    public boolean postToBaiduutilServerUploadFile(FerryReceiveTaskEntity receiveTaskEntity, File file) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("fileBase64", Base64Util.fileToBase64((File)file, (boolean)false));
        param.put("requestId", receiveTaskEntity.getRequestId());
        boolean isZw = receiveTaskEntity.getIsPushZw() != null && receiveTaskEntity.getIsPushZw() == 1;
        String pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(isZw).getPushUploadUrl(), (String)JSONObject.toJSONString(param));
        if ("fail".equals(pullResult)) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            return false;
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
        return true;
    }
}

