/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.emus.FerryTaskFileStatusEnum;
import com.bcxin.ferry.common.emus.FerryTaskStatusEnum;
import com.bcxin.ferry.common.utils.DateUtil;
import com.bcxin.ferry.common.utils.FileUtils;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.common.utils.ObsUtil;
import com.bcxin.ferry.configs.BaiduutilServerConfig;
import com.bcxin.ferry.configs.SchedulingConfig;
import com.bcxin.ferry.dao.mapper.FerryTaskMapper;
import com.bcxin.ferry.dtos.FerryDto;
import com.bcxin.ferry.dtos.FerryFileCallbackDto;
import com.bcxin.ferry.dtos.FerryTaskInfoDto;
import com.bcxin.ferry.dtos.baiduutil.FerryTaskPullResult;
import com.bcxin.ferry.entity.FerryTaskEntity;
import com.bcxin.ferry.entity.FerryTaskFileEntity;
import com.bcxin.ferry.service.FerryTaskFileService;
import com.bcxin.ferry.service.RetryService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FerryTaskService
extends ServiceImpl<FerryTaskMapper, FerryTaskEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryTaskService.class);
    @Autowired
    private SchedulingConfig schedulingConfig;
    @Autowired
    private RetryService retryService;
    @Autowired
    private FerryTaskFileService ferryTaskFileService;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    @Autowired
    private RedissonClient redissonClient;
    @Value(value="${spring.profiles.active}")
    private String activeFile;
    @Autowired
    private BaiduutilServerConfig baiduutilServerConfig;

    @Transactional
    public void createFerryTask(String regionCode) {
        log.info("\u5f00\u59cb\u521b\u5efa\u6446\u6e21\u4efb\u52a1\uff0cregionCode\uff1a{}", (Object)regionCode);
        Date nowTime = new Date();
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getRegionCode, (Object)regionCode);
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        lqw.last("limit 1");
        List list = lqw.list();
        FerryTaskEntity lastTask = CollectionUtil.isNotEmpty((Collection)list) ? (FerryTaskEntity)list.get(0) : null;
        log.info(lastTask == null ? "\u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1" : "\u6700\u8fd1\u4e00\u6b21\u7684\u4efb\u52a1\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)lastTask));
        if (lastTask != null && lastTask.getTaskStatus().intValue() != FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode()) {
            log.info("\u6700\u8fd1\u4e00\u6b21\u6446\u6e21\u4efb\u52a1\u672a\u5b8c\u6210");
            int intervalHour = 2;
            if (lastTask.getTaskStatus().intValue() == FerryTaskStatusEnum.FERRY_DETAIL_FILE_COMPLETE.getCode()) {
                log.info("\u6700\u8fd1\u4e00\u6b21\u6446\u6e21\u4efb\u52a1\u662f\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u7ed3\u675f\uff0c\u4fee\u6539\u7b49\u5f85\u65f6\u95f4\u4e3a3\u4e2a\u5c0f\u65f6");
                intervalHour = 3;
            }
            long intervalTime = 3600000 * intervalHour;
            long differenceTime = nowTime.getTime() - lastTask.getCreateTime().getTime();
            if (differenceTime >= intervalTime) {
                log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u521b\u5efa\u65f6\u95f4>=2\u5c0f\u65f6\uff0c\u8fdb\u884c\u8865\u507f\uff0c\u590d\u5236\u4e00\u4e2a\u4efb\u52a1\u51fa\u6765\uff0c\u91cd\u65b0\u6446\u6e21");
                String requestId = "";
                boolean isNeedRetryPull = false;
                if (lastTask.getTaskStatus().intValue() == FerryTaskStatusEnum.BEGIN_PULL.getCode()) {
                    log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u72b6\u6001\u662f\uff1a{}\uff0c\u6240\u4ee5\u9700\u8981\u91cd\u65b0\u62c9\u53d6", (Object)FerryTaskStatusEnum.BEGIN_PULL.getDefaultMessage());
                    isNeedRetryPull = true;
                } else {
                    log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u72b6\u6001\u662f\uff1a{}\uff0c\u4e0d\u7528\u9700\u8981\u91cd\u65b0\u62c9\u53d6\uff0c\u76f4\u63a5\u590d\u5236\u6446\u6e21\u5305\u5373\u53ef", (Object)lastTask.getTaskStatus());
                    requestId = "" + this.snowflake.snowflakeId();
                    String oldZip = lastTask.getPackageUrl().concat(File.separator).concat(lastTask.getRequestId()).concat(".zip");
                    String newZip = lastTask.getPackageUrl().concat(File.separator).concat(requestId).concat(".zip");
                    FileUtil.copy((String)oldZip, (String)newZip, (boolean)true);
                    log.info("\u6587\u4ef6\u590d\u5236\u5b8c\u6210\uff0coldZip\uff1a{}, newZip\uff1a{}", (Object)oldZip, (Object)newZip);
                }
                lastTask.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode()));
                lastTask.setFerryResult("\u521b\u5efa\u65f6\u95f4>=2\u5c0f\u65f6\uff0c\u8fdb\u884c\u8865\u507f\uff0c\u590d\u5236\u4e00\u4e2a\u4efb\u52a1\u51fa\u6765\uff0c\u91cd\u65b0\u6446\u6e21");
                lastTask.setUpdateTime(new Date());
                this.updateById((Object)lastTask);
                FerryTaskEntity ferryTaskEntity = new FerryTaskEntity();
                ferryTaskEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
                ferryTaskEntity.setRegionCode(regionCode);
                ferryTaskEntity.setStartTime(lastTask.getStartTime());
                ferryTaskEntity.setEndTime(lastTask.getEndTime());
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.BEGIN_PULL.getCode()));
                ferryTaskEntity.setCreateTime(nowTime);
                ferryTaskEntity.setUpdateTime(nowTime);
                if (!isNeedRetryPull) {
                    ferryTaskEntity.setRequestId(requestId);
                    ferryTaskEntity.setPackageUrl(lastTask.getPackageUrl());
                    ferryTaskEntity.setPullResult("retry_ferry");
                    ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.PULL_COMPLETE.getCode()));
                }
                this.save((Object)ferryTaskEntity);
                if (isNeedRetryPull) {
                    this.retryService.postToBaiduutilServerPull(ferryTaskEntity);
                }
            } else {
                log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u521b\u5efa\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u5dee\uff1a{} \u6beb\u79d2\uff0c<{}\u5c0f\u65f6\uff0c\u65e0\u9700\u8865\u507f", (Object)differenceTime, (Object)intervalHour);
            }
        } else if (lastTask != null && lastTask.getTaskStatus().intValue() == FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode() && lastTask.getPullResult() != null && lastTask.getPullResult().equals("\u62c9\u53d6\u670d\u52a1\u65e0zip\u5305\u4e0b\u8f7d") && StringUtils.isBlank((CharSequence)lastTask.getFerryResult())) {
            log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u65e0zip\u5305\u4e0b\u8f7d\uff0c\u91cd\u65b0\u6446\u6e21");
            FerryTaskEntity ferryTaskEntity = new FerryTaskEntity();
            ferryTaskEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
            ferryTaskEntity.setRegionCode(regionCode);
            ferryTaskEntity.setStartTime(lastTask.getStartTime());
            ferryTaskEntity.setEndTime(lastTask.getEndTime());
            ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.BEGIN_PULL.getCode()));
            ferryTaskEntity.setFerryResult("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u65e0zip\u5305\u4e0b\u8f7d\uff0c\u91cd\u65b0\u6446\u6e21");
            ferryTaskEntity.setCreateTime(nowTime);
            ferryTaskEntity.setUpdateTime(nowTime);
            this.save((Object)ferryTaskEntity);
            this.retryService.postToBaiduutilServerPull(ferryTaskEntity);
        } else {
            log.info("\u6700\u8fd1\u4e00\u6b21\u6446\u6e21\u4efb\u52a1\u5df2\u5b8c\u6210 || \u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1");
            Date pullDataBeginTime = DateUtil.getMinuteZeroTime((Date)nowTime);
            int after = this.schedulingConfig.getCreateFerryTask().getTimeInterval();
            long intervalTime = 3600000L;
            if (lastTask != null) {
                pullDataBeginTime = lastTask.getEndTime();
                if (nowTime.getTime() - pullDataBeginTime.getTime() > intervalTime) {
                    log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u95f4\u9694>1\u5c0f\u65f6\uff0c\u9700\u8981\u7ffb\u500d\u62c9\u53d6", (Object)lastTask.getEndTime(), (Object)nowTime);
                    log.info("\u539f\u672c\u62c9\u53d6\uff1a{}\u5206\u949f", (Object)after);
                    log.info("\u73b0\u5728\u62c9\u53d6\uff1a{}\u5206\u949f", (Object)(after *= 2));
                }
            }
            Date pullDataEndTime = DateUtil.getAfterNumMinuteTime((Date)pullDataBeginTime, (int)after);
            log.info("\u65b0\u7684\u4efb\u52a1\u62c9\u53d6\u6570\u636e\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u62c9\u53d6\u6570\u636e\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)DateUtil.formatDateTime((Date)pullDataBeginTime), (Object)DateUtil.formatDateTime((Date)pullDataEndTime));
            if (pullDataEndTime.getTime() >= nowTime.getTime()) {
                log.info("\u65b0\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4 >= \u5f53\u524d\u65f6\u95f4\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1\uff0c\u7b49\u5f85\u4e0b\u6b21\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8");
            } else {
                log.info("\u65b0\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4 < \u5f53\u524d\u65f6\u95f4\uff0c\u53ef\u4ee5\u521b\u5efa\u65b0\u7684\u4efb\u52a1");
                FerryTaskEntity ferryTaskEntity = new FerryTaskEntity();
                ferryTaskEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
                ferryTaskEntity.setRegionCode(regionCode);
                ferryTaskEntity.setStartTime(pullDataBeginTime);
                ferryTaskEntity.setEndTime(pullDataEndTime);
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.BEGIN_PULL.getCode()));
                ferryTaskEntity.setCreateTime(nowTime);
                ferryTaskEntity.setUpdateTime(nowTime);
                this.save((Object)ferryTaskEntity);
                this.retryService.postToBaiduutilServerPull(ferryTaskEntity);
            }
        }
    }

    @Transactional
    public void queryPullIsComplete() {
        Date nowTime = new Date();
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.BEGIN_PULL.getCode());
        lqw.isNull(FerryTaskEntity::getRequestId);
        lqw.isNull(FerryTaskEntity::getPackageUrl);
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryTaskEntity ferryTaskEntity : list) {
                FerryTaskPullResult result = this.retryService.postToBaiduutilServerPullResult(ferryTaskEntity);
                if (result == null || result.getTaskStatus() == null) continue;
                FerryTaskEntity ferryTask = (FerryTaskEntity)this.getById((Serializable)result.getId());
                ferryTask.setRequestId(result.getRequestId());
                ferryTask.setPackageUrl(result.getPackageUrl());
                ferryTask.setPullResult(result.getPullResult());
                ferryTask.setTaskStatus(result.getTaskStatus());
                ferryTask.setUpdateTime(nowTime);
                this.updateById((Object)ferryTask);
            }
        } else {
            log.info("\u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u5f00\u59cb\u62c9\u53d6\u7684\u4efb\u52a1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> queryPullComplete() {
        ArrayList<Long> canInitTaskIdList = new ArrayList<Long>();
        Date nowTime = new Date();
        log.info("\u5f53\u524d\u65f6\u95f4\u6233\uff1a{}", (Object)nowTime.getTime());
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.PULL_COMPLETE.getCode());
        lqw.isNotNull(FerryTaskEntity::getRequestId);
        lqw.isNotNull(FerryTaskEntity::getPackageUrl);
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryTaskEntity ferryTaskEntity : list) {
                String lockKey = "REDISSON_LOCK_QUERY_FERRY_TASK_STATUS_" + ferryTaskEntity.getId().toString();
                log.info("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001\u4efb\u52a1\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
                RLock lock = this.redissonClient.getLock(lockKey);
                lock.lock(900L, TimeUnit.SECONDS);
                log.info("\u53d6\u5230\u9501");
                try {
                    boolean unzipResult = true;
                    String ferryPackageUrl = ferryTaskEntity.getPackageUrl().concat(File.separator).concat(ferryTaskEntity.getRequestId());
                    String zipPath = ferryPackageUrl.concat(".zip");
                    log.info("activeFile\uff1a{}\uff0cpullResult\uff1a{}", (Object)this.activeFile, (Object)ferryTaskEntity.getPullResult());
                    if ("out-prod".equals(this.activeFile) && !"retry_ferry".equals(ferryTaskEntity.getPullResult())) {
                        log.info("\u5317\u4eac\u653f\u52a1\u5916\u7f51 && \u4e0d\u662f\u91cd\u8bd5\u6446\u6e21\uff0c\u9700\u8981\u4e0b\u8f7dzip\u5305");
                        log.info("regionCode\uff1a{}", (Object)ferryTaskEntity.getRegionCode());
                        boolean downloadFileResult = false;
                        int downloadCount = 0;
                        if (ferryTaskEntity.getRegionCode().contains("gov")) {
                            while (!downloadFileResult && downloadCount < 10) {
                                String fileUrl = this.baiduutilServerConfig.getRequestApi(true).getPullDownloadResultUrl().concat(ferryTaskEntity.getRequestId());
                                downloadFileResult = FileUtils.downloadByUrl((String)fileUrl, (String)zipPath);
                                log.info("\u7b2c{}\u6b21\u4e0b\u8f7d\u653f\u52a1\u5916\u7f51\u6446\u6e21\u5305\uff0c\u4e0b\u8f7d\uff1a{}", (Object)(++downloadCount), (Object)downloadFileResult);
                                if (downloadFileResult) continue;
                                log.info("\u4e0b\u8f7d\u5931\u8d25\uff0c\u7b49\u5f852\u5206\u949f");
                                try {
                                    Thread.sleep(120000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            while (!downloadFileResult && downloadCount < 10) {
                                downloadFileResult = ObsUtil.downloadFile((String)zipPath, (String)zipPath.substring(zipPath.indexOf("baidu/")));
                                log.info("\u7b2c{}\u6b21\u4e0b\u8f7dOBS\uff0c\u4e0b\u8f7d\uff1a{}", (Object)(++downloadCount), (Object)downloadFileResult);
                                if (downloadFileResult) continue;
                                log.info("\u4e0b\u8f7d\u5931\u8d25\uff0c\u7b49\u5f852\u5206\u949f");
                                try {
                                    Thread.sleep(120000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (downloadFileResult) {
                            File unzip;
                            File zipFile = new File(zipPath);
                            if (!zipFile.exists()) {
                                log.error("zip\u6587\u4ef6\u4e0d\u5b58\u5728");
                                unzipResult = false;
                            }
                            if (!(unzip = ZipUtil.unzip((File)zipFile)).exists()) {
                                log.error("zip\u89e3\u538b\u5931\u8d25");
                                unzipResult = false;
                            }
                            log.info("\u89e3\u538b\u7ed3\u675f");
                        } else {
                            unzipResult = false;
                            log.error("\u4e0b\u8f7d\u6446\u6e21\u5305\u5931\u8d25");
                        }
                    } else {
                        log.info("\u4e0d\u662f\u5317\u4eac\u653f\u52a1\u5916\u7f51 || \u662f\u91cd\u8bd5\u6446\u6e21\uff0c\u4e0d\u9700\u8981\u4e0b\u8f7dzip\u5305");
                    }
                    if ("retry_ferry".equals(ferryTaskEntity.getPullResult())) {
                        File unzip;
                        log.info("\u662f\u91cd\u8bd5\u6446\u6e21\uff0c\u9700\u8981\u89e3\u538bzip\u5305");
                        File zipFile = new File(zipPath);
                        if (!zipFile.exists()) {
                            log.error("zip\u6587\u4ef6\u4e0d\u5b58\u5728");
                            unzipResult = false;
                        }
                        if (!(unzip = ZipUtil.unzip((File)zipFile)).exists()) {
                            log.error("zip\u89e3\u538b\u5931\u8d25");
                            unzipResult = false;
                        }
                        log.info("\u89e3\u538b\u7ed3\u675f");
                    }
                    if (!unzipResult) continue;
                    canInitTaskIdList.add(ferryTaskEntity.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001\u4efb\u52a1\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    if (lock.isLocked()) {
                        lock.unlock();
                    }
                    log.info("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001\u4efb\u52a1\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
                }
            }
        } else {
            log.info("\u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u62c9\u53d6\u5b8c\u6210\u7684\u4efb\u52a1");
        }
        return canInitTaskIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void initFileInfo(Long taskId) {
        Date nowTime = new Date();
        log.info("\u5f53\u524d\u65f6\u95f4\u6233\uff1a{}", (Object)nowTime.getTime());
        String lockKey = "REDISSON_LOCK_FERRY_TASK_FILE_INIT";
        log.info("\u521d\u59cb\u5316\u6587\u4ef6\u5217\u8868\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(900L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            log.info("\u521d\u59cb\u5316\u6587\u4ef6\u5217\u8868\uff0ctaskId\uff1a{}", (Object)taskId);
            FerryTaskEntity ferryTaskEntity = (FerryTaskEntity)this.getById((Serializable)taskId);
            String ferryPackageUrl = ferryTaskEntity.getPackageUrl().concat(File.separator).concat(ferryTaskEntity.getRequestId());
            List fileList = FileUtil.loopFiles((String)ferryPackageUrl);
            if (CollectionUtil.isNotEmpty((Collection)fileList)) {
                log.info("\u5f00\u59cb\u521d\u59cb\u5316\u6587\u4ef6\uff0c\u521d\u59cb\u6587\u4ef6\u603b\u6570\uff1a{}", (Object)fileList.size());
                for (File file : fileList) {
                    if (file.isHidden()) continue;
                    this.ferryTaskFileService.createFerryTaskFile(ferryTaskEntity, file);
                }
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.SCAN_FILE_COMPLETE.getCode()));
                log.info("\u521d\u59cb\u5316\u6587\u4ef6\u7ed3\u675f");
                this.createFerryTaskInfoFile(ferryTaskEntity);
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.CREATE_TASK_FILE_COMPLETE.getCode()));
                ferryTaskEntity.setUpdateTime(nowTime);
                this.updateById((Object)ferryTaskEntity);
            } else {
                log.info("\u521d\u59cb\u5316\u6587\u4ef6\u5217\u8868\uff0ctaskId\uff1a{}\uff0c\u4e0d\u5b58\u5728\u6587\u4ef6\u5217\u8868", (Object)taskId);
            }
            log.info("\u521d\u59cb\u5316\u6587\u4ef6\u5217\u8868\uff0ctaskId\uff1a{}\uff0c\u5b8c\u6210", (Object)taskId);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u521d\u59cb\u5316\u6587\u4ef6\u5217\u8868\uff0c{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u521d\u59cb\u5316\u6587\u4ef6\u5217\u8868\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
    }

    private void createFerryTaskInfoFile(FerryTaskEntity ferryTaskEntity) {
        log.info("\u5f00\u59cb\u751f\u6210\u6446\u6e21\u4efb\u52a1\u4fe1\u606f\u6587\u4ef6");
        String fileName = ferryTaskEntity.getPackageUrl().concat(File.separator).concat(ferryTaskEntity.getRequestId()).concat(File.separator).concat("FERRY_FILE_").concat(ferryTaskEntity.getId().toString()).concat(".ferry");
        File infoFile = new File(fileName);
        this.ferryTaskFileService.createFerryTaskFile(ferryTaskEntity, infoFile);
        List ferryTaskFileEntityList = this.ferryTaskFileService.queryByTaskId(ferryTaskEntity.getId());
        FerryTaskInfoDto dto = new FerryTaskInfoDto();
        dto.setFerryTaskEntity(ferryTaskEntity);
        dto.setFerryTaskFileEntityList(ferryTaskFileEntityList);
        FileUtil.appendUtf8String((String)JSONObject.toJSONString((Object)dto), (File)infoFile);
        log.info("\u751f\u6210\u6446\u6e21\u4efb\u52a1\u4fe1\u606f\u6587\u4ef6\u7ed3\u675f\uff0c\u521d\u59cb\u540e\uff0c\u6587\u4ef6\u603b\u6570\uff1a{}", (Object)ferryTaskFileEntityList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFerryTaskFile() {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.CREATE_TASK_FILE_COMPLETE.getCode());
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryTaskEntity ferryTaskEntity : list) {
                String lockKey = "REDISSON_LOCK_SEND_FERRY_TASK_FILE_" + ferryTaskEntity.getId().toString();
                log.info("\u8c03\u7528\u8fb9\u754c\u670d\u52a1\u6267\u884c\u6446\u6e21\u4efb\u52a1\u4fe1\u606f\u6587\u4ef6\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
                RLock lock = this.redissonClient.getLock(lockKey);
                lock.lock(300L, TimeUnit.SECONDS);
                log.info("\u53d6\u5230\u9501");
                try {
                    log.info("\u5f00\u59cb\u6446\u6e21\u4efb\u52a1\u4fe1\u606f\u6587\u4ef6");
                    this.ferryTaskFileService.ferryTaskFile(ferryTaskEntity.getId());
                    ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_TASK_FILE_BEGIN.getCode()));
                    ferryTaskEntity.setUpdateTime(new Date());
                    this.updateById((Object)ferryTaskEntity);
                    log.info("\u5f00\u59cb\u6446\u6e21\u4efb\u52a1\u4fe1\u606f\u6587\u4ef6\u7ed3\u675f");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u8c03\u7528\u8fb9\u754c\u670d\u52a1\u6267\u884c\u6446\u6e21\u4efb\u52a1\u4fe1\u606f\u6587\u4ef6\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    if (lock.isLocked()) {
                        lock.unlock();
                    }
                    log.info("\u8c03\u7528\u8fb9\u754c\u670d\u52a1\u6267\u884c\u6446\u6e21\u4efb\u52a1\u4fe1\u606f\u6587\u4ef6\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
                }
            }
        } else {
            log.info("\u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u751f\u6210\u4efb\u52a1\u6587\u4ef6\u5b8c\u6210\u7684\u4efb\u52a1");
        }
    }

    @Transactional
    public Long updateFerryTaskFileResult(FerryFileCallbackDto callbackDto) {
        Date nowTime = new Date();
        FerryTaskFileEntity fileEntity = (FerryTaskFileEntity)this.ferryTaskFileService.getById((Serializable)((Object)callbackDto.getFileId()));
        log.info("\u6446\u6e21\u4efb\u52a1\u6587\u4ef6\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)fileEntity));
        FerryTaskEntity ferryTaskEntity = (FerryTaskEntity)this.getById((Serializable)fileEntity.getTaskId());
        log.info("\u6446\u6e21\u4efb\u52a1\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)ferryTaskEntity));
        if (ferryTaskEntity.getTaskStatus().intValue() == FerryTaskStatusEnum.FERRY_TASK_FILE_BEGIN.getCode()) {
            log.info("\u4fee\u6539\u6446\u6e21\u4efb\u52a1\u6587\u4ef6\u7ed3\u679c");
            fileEntity.setFileStatus(callbackDto.getFileStatus());
            fileEntity.setFerryResult(callbackDto.getFerryResult());
            fileEntity.setUpdateTime(nowTime);
            this.ferryTaskFileService.updateById((Object)fileEntity);
            log.info("\u4fee\u6539\u4efb\u52a1\u72b6\u6001\uff1a{}", (Object)FerryTaskStatusEnum.FERRY_TASK_FILE_COMPLETE.getCode());
            ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_TASK_FILE_COMPLETE.getCode()));
            ferryTaskEntity.setUpdateTime(nowTime);
            this.updateById((Object)ferryTaskEntity);
            return ferryTaskEntity.getId();
        }
        log.info("\u6446\u6e21\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u4ee5\u4fee\u6539");
        return null;
    }

    @Transactional
    public void sendFerryDetailFile(Long taskId) {
        FerryTaskEntity ferryTaskEntity = (FerryTaskEntity)this.getById((Serializable)taskId);
        if (ferryTaskEntity != null) {
            log.info("\u5f00\u59cb\u6446\u6e21\u4efb\u52a1\u660e\u7ec6\u6587\u4ef6");
            ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_DETAIL_FILE_BEGIN.getCode()));
            ferryTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)ferryTaskEntity);
            log.info("\u5f00\u59cb\u6446\u6e21\u4efb\u52a1\u660e\u7ec6\u6587\u4ef6\u7ed3\u675f");
        }
    }

    @Transactional
    public Long updateFerryDetailFileResult(FerryFileCallbackDto callbackDto) {
        FerryTaskFileEntity fileEntity = (FerryTaskFileEntity)this.ferryTaskFileService.getById((Serializable)((Object)callbackDto.getFileId()));
        log.info(fileEntity == null ? "\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u4e0d\u5b58\u5728" : "\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)fileEntity));
        if (fileEntity == null) {
            return null;
        }
        if (fileEntity.getFileStatus().intValue() == FerryTaskFileStatusEnum.PULL_COMPLETE.getCode() || fileEntity.getFileStatus().intValue() == FerryTaskFileStatusEnum.FERRY_BEGIN.getCode()) {
            log.info("\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u72b6\u6001\u53ef\u4ee5\u4fee\u6539");
            fileEntity.setFileStatus(callbackDto.getFileStatus());
            fileEntity.setFerryResult(callbackDto.getFerryResult());
            fileEntity.setUpdateTime(new Date());
            this.ferryTaskFileService.updateById((Object)fileEntity);
        } else {
            log.info("\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u72b6\u6001\u4e0d\u53ef\u4ee5\u4fee\u6539");
        }
        return fileEntity.getTaskId();
    }

    @Transactional
    public void updateFerryDetailFileComplete(Long taskId) {
        long nullFerryResultCount = this.ferryTaskFileService.countNullFerryResultByTaskId(taskId);
        log.info("\u67e5\u8be2\u8fd8\u6709\u591a\u5c11\u4e2a\u660e\u7ec6\u6587\u4ef6\u672a\u6446\u6e21\u5b8c\u6210\uff0ctaskId\uff1a{}\uff0cnullFerryResultCount\uff1a{}", (Object)taskId, (Object)nullFerryResultCount);
        if (nullFerryResultCount == 0L) {
            log.info("\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u90fd\u5b8c\u6210\u4e86\uff0c\u4fee\u6539\u4efb\u52a1\u72b6\u6001");
            FerryTaskEntity ferryTaskEntity = (FerryTaskEntity)this.getById((Serializable)taskId);
            log.info("\u5f53\u524d\u4efb\u52a1\u72b6\u6001\uff0ctaskStatus\uff1a{}", (Object)ferryTaskEntity.getTaskStatus());
            if (ferryTaskEntity.getTaskStatus().intValue() == FerryTaskStatusEnum.FERRY_DETAIL_FILE_BEGIN.getCode()) {
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_DETAIL_FILE_COMPLETE.getCode()));
                ferryTaskEntity.setUpdateTime(new Date());
                this.updateById((Object)ferryTaskEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateFerryTaskComplete(FerryDto ferryDto) {
        long taskId = Long.parseLong(ferryDto.getFerryTaskId());
        log.info("\u4fee\u6539\u6446\u6e21\u4efb\u52a1\u5b8c\u6210\uff0ctaskId\uff1a{}", (Object)taskId);
        String lockKey = "REDISSON_LOCK_UPDATE_FERRY_TASK_STATUS_" + taskId;
        log.info("\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u4e3a\uff1a\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u7ed3\u675f\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(300L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            FerryTaskEntity ferryTaskEntity = (FerryTaskEntity)this.getById((Serializable)Long.valueOf(taskId));
            if (ferryTaskEntity != null) {
                log.info("\u5f53\u524d\u4efb\u52a1\u72b6\u6001\uff0ctaskStatus\uff1a{}", (Object)ferryTaskEntity.getTaskStatus());
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode()));
                ferryTaskEntity.setFerryResult(ferryDto.getFerryTaskResult());
                ferryTaskEntity.setUpdateTime(new Date());
                this.updateById((Object)ferryTaskEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u4e3a\uff1a\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u7ed3\u675f\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u4e3a\uff1a\u6446\u6e21\u660e\u7ec6\u6587\u4ef6\u7ed3\u675f\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
    }

    public List<FerryTaskEntity> queryOneHourNotCompleteList() {
        Date intervalTime = DateUtil.getBeforeNumMinuteTime((Date)new Date(), (int)this.schedulingConfig.getScanErrorInfo().getTimeInterval());
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.ne(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode());
        lqw.lt(FerryTaskEntity::getCreateTime, (Object)intervalTime);
        lqw.orderByAsc(FerryTaskEntity::getCreateTime);
        return lqw.list();
    }

    public boolean isNotCreateNewTask() {
        FerryTaskEntity lastComplete;
        Date now = new Date();
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode());
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        lqw.last("limit 1");
        List list = lqw.list();
        FerryTaskEntity ferryTaskEntity = lastComplete = CollectionUtil.isNotEmpty((Collection)list) ? (FerryTaskEntity)list.get(0) : null;
        if (lastComplete != null && now.getTime() - lastComplete.getUpdateTime().getTime() > 6400L) {
            FerryTaskEntity lastTask;
            LambdaQueryChainWrapper lqw2 = this.lambdaQuery();
            lqw2.orderByDesc(FerryTaskEntity::getCreateTime);
            lqw2.last("limit 1");
            List list2 = lqw2.list();
            FerryTaskEntity ferryTaskEntity2 = lastTask = CollectionUtil.isNotEmpty((Collection)list2) ? (FerryTaskEntity)list2.get(0) : null;
            return lastTask != null && lastComplete.getId().longValue() == lastTask.getId().longValue();
        }
        return true;
    }
}

