/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.crypto.digest.MD5;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.emus.FerryTaskFileStatusEnum;
import com.bcxin.ferry.common.emus.FileTypeEnum;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.common.utils.Base64Util;
import com.bcxin.ferry.common.utils.DateUtil;
import com.bcxin.ferry.common.utils.FileSpiltMergeUtil;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.configs.BoundaryServerConfig;
import com.bcxin.ferry.dao.mapper.FerryTaskFileMapper;
import com.bcxin.ferry.dao.mapper.FerryTaskMapper;
import com.bcxin.ferry.dtos.FerryFileDto;
import com.bcxin.ferry.dtos.response.boundary.BoundaryResult;
import com.bcxin.ferry.dtos.response.boundary.BoundaryResultData;
import com.bcxin.ferry.entity.FerryTaskEntity;
import com.bcxin.ferry.entity.FerryTaskFileEntity;
import com.bcxin.ferry.service.SendRequestToBoundaryService;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FerryTaskFileService
extends ServiceImpl<FerryTaskFileMapper, FerryTaskFileEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryTaskFileService.class);
    @Autowired
    private SendRequestToBoundaryService sendRequestToBoundaryService;
    @Autowired
    private FerryTaskMapper ferryTaskMapper;
    @Autowired
    private BoundaryServerConfig boundaryServerConfig;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    private static final String NORMAL_FILE_SUFFIX = "DOC,DOCX,XLS,XLSX,CSV,PPT,PPTX,PDF,PNG,JPG,GIF";

    public List<FerryTaskFileEntity> queryByTaskId(Long taskId) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskFileEntity::getTaskId, (Object)taskId);
        lqw.orderByAsc(FerryTaskFileEntity::getCreateTime);
        return lqw.list();
    }

    public FerryTaskFileEntity queryTaskFileByTaskId(Long taskId) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskFileEntity::getTaskId, (Object)taskId);
        lqw.eq(FerryTaskFileEntity::getFileType, (Object)FileTypeEnum.TASK.getCode());
        lqw.orderByDesc(FerryTaskFileEntity::getCreateTime);
        lqw.last("limit 1");
        List list = lqw.list();
        return CollectionUtil.isNotEmpty((Collection)list) ? (FerryTaskFileEntity)list.get(0) : null;
    }

    public List<FerryTaskFileEntity> queryDetailFileByTaskId(Long taskId) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskFileEntity::getTaskId, (Object)taskId);
        lqw.ne(FerryTaskFileEntity::getFileType, (Object)FileTypeEnum.TASK.getCode());
        lqw.orderByAsc(FerryTaskFileEntity::getCreateTime);
        return lqw.list();
    }

    public long countNullFerryResultByTaskId(Long taskId) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskFileEntity::getTaskId, (Object)taskId);
        lqw.eq(FerryTaskFileEntity::getIsSplit, (Object)0);
        lqw.in(FerryTaskFileEntity::getFileStatus, new Object[]{1, 2});
        return lqw.count();
    }

    @Transactional
    public void createFerryTaskFile(FerryTaskEntity ferryTaskEntity, File file) {
        log.info("\u521d\u59cb\u5316\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
        String fileName = file.getName();
        FerryTaskFileEntity fileEntity = new FerryTaskFileEntity();
        fileEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
        fileEntity.setTaskId(ferryTaskEntity.getId());
        fileEntity.setFileName(fileName);
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase(Locale.ROOT);
        if (fileName.startsWith("FERRY_FILE_")) {
            fileEntity.setFileType(Integer.valueOf(FileTypeEnum.TASK.getCode()));
        } else if (suffix.equals("SQL")) {
            fileEntity.setFileType(Integer.valueOf(FileTypeEnum.SQL.getCode()));
        } else if (suffix.equals("TXT")) {
            fileEntity.setFileType(Integer.valueOf(FileTypeEnum.TXT.getCode()));
        } else if (this.checkSpecial(fileName, suffix, file.length())) {
            fileEntity.setFileType(Integer.valueOf(FileTypeEnum.SPECIAL.getCode()));
        } else {
            fileEntity.setFileType(Integer.valueOf(FileTypeEnum.NORMAL.getCode()));
        }
        String absolutePath = file.getAbsolutePath();
        absolutePath = absolutePath.replaceAll("\\\\", "/");
        absolutePath = absolutePath.substring(absolutePath.indexOf("/".concat(ferryTaskEntity.getRequestId())));
        fileEntity.setFileUrl(absolutePath);
        fileEntity.setFileStatus(Integer.valueOf(FerryTaskFileStatusEnum.PULL_COMPLETE.getCode()));
        fileEntity.setFileSize(new BigDecimal(file.length()).divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP));
        if (file.length() > this.boundaryServerConfig.getMaxFileSize()) {
            log.info("\u6587\u4ef6\uff1a{}\uff0c\u9700\u8981\u62c6\u5206", (Object)file.getAbsolutePath());
            fileEntity.setIsSplit(Integer.valueOf(1));
            fileEntity.setSplitFileIds(this.createChildrenFileList(ferryTaskEntity, FileSpiltMergeUtil.splitFile((long)(this.boundaryServerConfig.getMaxFileSize() * 3L), (File)file)));
            log.info("\u62c6\u5206\u51fa\u7684\u6587\u4ef6id\u4e3a\uff1a{}", (Object)fileEntity.getSplitFileIds());
        } else {
            log.info("\u6587\u4ef6\uff1a{}\uff0c\u4e0d\u9700\u8981\u62c6\u5206", (Object)file.getAbsolutePath());
            fileEntity.setIsSplit(Integer.valueOf(0));
        }
        if (!fileName.startsWith("FERRY_FILE_")) {
            fileEntity.setFileMd5(MD5.create().digestHex16(file));
        }
        fileEntity.setCreateTime(new Date());
        fileEntity.setUpdateTime(new Date());
        this.save((Object)fileEntity);
        log.info("\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
    }

    private boolean checkSpecial(String fileName, String suffix, long fileLength) {
        if (fileLength < 1024L) {
            return true;
        }
        if (!NORMAL_FILE_SUFFIX.contains(suffix)) {
            return true;
        }
        if (fileName.matches(".*[\u4e00-\u9fa5]+.*")) {
            return true;
        }
        String regex = ".*[[ `~!@#$%^&*+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c'\u3002\uff0c\u3001\uff1f]|\\n|\\r|\\t].*";
        return fileName.matches(regex);
    }

    private String createChildrenFileList(FerryTaskEntity ferryTaskEntity, List<String> childrenFilePathList) {
        StringBuffer splitFileIds = new StringBuffer();
        if (CollectionUtil.isNotEmpty(childrenFilePathList)) {
            for (String path : childrenFilePathList) {
                File file = new File(path);
                String fileName = file.getName();
                FerryTaskFileEntity fileEntity = new FerryTaskFileEntity();
                fileEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
                fileEntity.setTaskId(ferryTaskEntity.getId());
                fileEntity.setFileName(fileName);
                fileEntity.setFileType(Integer.valueOf(FileTypeEnum.CHILDREN.getCode()));
                String absolutePath = file.getAbsolutePath();
                absolutePath = absolutePath.replaceAll("\\\\", "/");
                absolutePath = absolutePath.substring(absolutePath.indexOf("/".concat(ferryTaskEntity.getRequestId())));
                fileEntity.setFileUrl(absolutePath);
                fileEntity.setFileStatus(Integer.valueOf(FerryTaskFileStatusEnum.PULL_COMPLETE.getCode()));
                fileEntity.setFileSize(new BigDecimal(file.length()).divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP));
                fileEntity.setIsSplit(Integer.valueOf(0));
                fileEntity.setFileMd5(MD5.create().digestHex16(file));
                fileEntity.setCreateTime(new Date());
                fileEntity.setUpdateTime(new Date());
                this.save((Object)fileEntity);
                splitFileIds.append(fileEntity.getId().toString()).append(",");
            }
        }
        if (splitFileIds.length() == 0) {
            return null;
        }
        return splitFileIds.substring(0, splitFileIds.length() - 1);
    }

    @Transactional
    public void ferryTaskFile(Long taskId) {
        FerryTaskFileEntity taskFileEntity = this.queryTaskFileByTaskId(taskId);
        this.ferryFileToBoundary(taskFileEntity, SendBoundaryUrlEnum.SEND_TASK_FILE);
    }

    @Transactional
    public void ferryFileToBoundary(FerryTaskFileEntity taskFileEntity, SendBoundaryUrlEnum urlEnum) {
        BoundaryResult boundaryResult;
        FerryTaskEntity ferryTaskEntity = (FerryTaskEntity)this.ferryTaskMapper.selectById((Serializable)taskFileEntity.getTaskId());
        FerryFileDto ferryFileDto = new FerryFileDto();
        ferryFileDto.setFerryTaskId(taskFileEntity.getTaskId().toString());
        ferryFileDto.setRequestId(ferryTaskEntity.getRequestId());
        ferryFileDto.setFerry_accept_url(urlEnum.getValue());
        ferryFileDto.setFileType(taskFileEntity.getFileType());
        ferryFileDto.setFileId(taskFileEntity.getId().toString());
        if (urlEnum.getCode() == SendBoundaryUrlEnum.SEND_TASK_FILE.getCode()) {
            if (ferryTaskEntity.getRegionCode().equals("govin-to-govout")) {
                ferryFileDto.setIsPushZw(Integer.valueOf(1));
            } else {
                ferryFileDto.setIsPushZw(Integer.valueOf(0));
            }
        }
        Map paramMap = BeanUtil.beanToMap((Object)ferryFileDto, (String[])new String[0]);
        File file = new File(ferryTaskEntity.getPackageUrl().concat(taskFileEntity.getFileUrl()));
        if (taskFileEntity.getIsSplit() == 0 && file.length() != 0L) {
            String fileToBase64 = Base64Util.fileToBase64((File)file, (taskFileEntity.getFileType().intValue() != FileTypeEnum.NORMAL.getCode() ? 1 : 0) != 0);
            if (taskFileEntity.getFileType().intValue() == FileTypeEnum.NORMAL.getCode()) {
                paramMap.put("img_base64", fileToBase64);
            } else {
                List fileBase64List = this.splitStringByLength(fileToBase64, 1000);
                paramMap.put("paramContentSize", fileBase64List.size());
                for (int i = 0; i < fileBase64List.size(); ++i) {
                    paramMap.put("paramContent_" + i, fileBase64List.get(i));
                }
            }
        }
        if ((boundaryResult = this.sendRequestToBoundaryService.send(paramMap)) != null && "0".equals(boundaryResult.getStatus_code())) {
            taskFileEntity.setBoundaryTaskId(((BoundaryResultData)boundaryResult.getData().get(0)).getTask_id());
            taskFileEntity.setFileStatus(Integer.valueOf(FerryTaskFileStatusEnum.FERRY_BEGIN.getCode()));
        } else {
            taskFileEntity.setFileStatus(Integer.valueOf(FerryTaskFileStatusEnum.FERRY_FAIL.getCode()));
            taskFileEntity.setFerryResult(boundaryResult != null ? boundaryResult.getMsg() : "\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        taskFileEntity.setRetryCount(Integer.valueOf(taskFileEntity.getRetryCount() == null ? 0 : taskFileEntity.getRetryCount() + 1));
        this.updateById((Object)taskFileEntity);
    }

    private List<String> splitStringByLength(String input, int length) {
        ArrayList<String> result = new ArrayList<String>();
        for (int start = 0; start < input.length(); start += length) {
            int end = Math.min(start + length, input.length());
            result.add(input.substring(start, end));
        }
        return result;
    }

    public List<FerryTaskFileEntity> queryHalfHourNotCompleteList() {
        Date intervalTime = DateUtil.getBeforeNumMinuteTime((Date)new Date(), (int)30);
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.ne(FerryTaskFileEntity::getFileStatus, (Object)FerryTaskFileStatusEnum.FERRY_COMPLETE.getCode());
        lqw.ne(FerryTaskFileEntity::getFileType, (Object)FileTypeEnum.TASK.getCode());
        lqw.lt(FerryTaskFileEntity::getRetryCount, (Object)10);
        lqw.lt(FerryTaskFileEntity::getCreateTime, (Object)intervalTime);
        lqw.orderByAsc(FerryTaskFileEntity::getCreateTime);
        return lqw.list();
    }
}

