/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.dao.mapper.FerryRequestLogMapper;
import com.bcxin.ferry.entity.FerryRequestLogEntity;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FerryRequestLogService
extends ServiceImpl<FerryRequestLogMapper, FerryRequestLogEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryRequestLogService.class);
    @Autowired
    private IdGeneratorSnowflake snowflake;

    @Transactional
    public Long createLog(Object taskId, Object fileId, Object apiUrl, String requestParam) {
        log.info("\u521b\u5efa\u8bf7\u6c42\u65e5\u5fd7");
        FerryRequestLogEntity log = new FerryRequestLogEntity();
        log.setId(Long.valueOf(this.snowflake.snowflakeId()));
        log.setTaskId(taskId != null ? Long.valueOf(Long.parseLong(taskId.toString())) : null);
        log.setFileId(fileId != null ? Long.valueOf(Long.parseLong(fileId.toString())) : null);
        log.setApiUrl(apiUrl != null ? apiUrl.toString() : null);
        JSONObject jsonObject = JSONObject.parseObject((String)requestParam);
        jsonObject.keySet().removeIf("img_base64"::equals);
        jsonObject.keySet().removeIf("paramContent"::contains);
        log.setRequestParam(JSONObject.toJSONString((Object)jsonObject));
        log.setFerryStatus(Integer.valueOf(1));
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        this.save((Object)log);
        return log.getId();
    }

    @Transactional
    public void updateLogRequestResult(Long id, String requestResult, String boundaryTaskId) {
        log.info("\u66f4\u65b0\u8bf7\u6c42\u65e5\u5fd7");
        FerryRequestLogEntity log = (FerryRequestLogEntity)this.getById((Serializable)id);
        log.setRequestResult(requestResult);
        log.setBoundaryTaskId(boundaryTaskId);
        log.setFerryStatus(Integer.valueOf(2));
        log.setApiReturnTime(new Date());
        log.setUpdateTime(new Date());
        this.updateById((Object)log);
    }

    @Async(value="taskExecutor")
    @Transactional
    public void boundaryServerCallback(String boundaryTaskId) {
        log.info("\u8fb9\u754c\u670d\u52a1\u56de\u8c03\uff0c\u4fee\u6539\u72b6\u6001");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryRequestLogEntity::getBoundaryTaskId, (Object)boundaryTaskId);
        lqw.orderByDesc(FerryRequestLogEntity::getCreateTime);
        lqw.last("limit 1");
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            FerryRequestLogEntity log = (FerryRequestLogEntity)list.get(0);
            log.setFerryStatus(Integer.valueOf(3));
            log.setSuccessTime(new Date());
            log.setUpdateTime(new Date());
            this.updateById((Object)log);
        }
    }
}

