/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.emus.FerryReceiveTaskStatusEnum;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.common.utils.Base64Util;
import com.bcxin.ferry.common.utils.DateUtil;
import com.bcxin.ferry.common.utils.FileSpiltMergeUtil;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.configs.ReceiveConfig;
import com.bcxin.ferry.configs.SchedulingConfig;
import com.bcxin.ferry.dao.mapper.FerryReceiveTaskMapper;
import com.bcxin.ferry.dtos.FerryFileDto;
import com.bcxin.ferry.dtos.FerryTaskInfoDto;
import com.bcxin.ferry.dtos.baiduutil.FerryReceiveTaskPushResult;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.entity.FerryReceiveTaskFileEntity;
import com.bcxin.ferry.entity.FerryTaskFileEntity;
import com.bcxin.ferry.service.FerryReceiveTaskFileService;
import com.bcxin.ferry.service.RetryService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FerryReceiveTaskService
extends ServiceImpl<FerryReceiveTaskMapper, FerryReceiveTaskEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryReceiveTaskService.class);
    @Autowired
    private SchedulingConfig schedulingConfig;
    @Autowired
    private ReceiveConfig receiveConfig;
    @Autowired
    private FerryReceiveTaskFileService ferryReceiveTaskFileService;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    @Autowired
    private RetryService retryService;

    @Transactional
    public String receiveRequest(FerryFileDto receiveDto) {
        log.info("\u63a5\u6536\u6446\u6e21\u4efb\u52a1\u6587\u4ef6");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getFerryTaskId, (Object)Long.parseLong(receiveDto.getFerryTaskId()));
        if (lqw.exists()) {
            log.info("\u8be5\u4efb\u52a1\u6587\u4ef6\u5df2\u7ecf\u63a5\u6536\u4e86");
            return null;
        }
        log.info("\u521b\u5efa\u63a5\u6536\u4efb\u52a1");
        FerryReceiveTaskEntity receiveTaskEntity = new FerryReceiveTaskEntity();
        receiveTaskEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
        receiveTaskEntity.setFerryTaskId(Long.valueOf(Long.parseLong(receiveDto.getFerryTaskId())));
        receiveTaskEntity.setRequestId(receiveDto.getRequestId());
        receiveTaskEntity.setIsPushZw(receiveDto.getIsPushZw());
        receiveTaskEntity.setPackageUrl(this.receiveConfig.getPackageUrl().concat(receiveDto.getRequestId()));
        receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.RECEIVE_REQUEST.getCode()));
        receiveTaskEntity.setCreateTime(new Date());
        receiveTaskEntity.setUpdateTime(new Date());
        this.save((Object)receiveTaskEntity);
        return receiveTaskEntity.getPackageUrl();
    }

    @Transactional
    public List<FerryTaskFileEntity> parseTaskFile(FerryFileDto receiveDto) {
        FerryReceiveTaskEntity receiveTaskEntity;
        log.info("\u89e3\u6790\u4efb\u52a1\u6587\u4ef6");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getFerryTaskId, (Object)Long.parseLong(receiveDto.getFerryTaskId()));
        List list = lqw.list();
        FerryReceiveTaskEntity ferryReceiveTaskEntity = receiveTaskEntity = CollectionUtil.isNotEmpty((Collection)list) ? (FerryReceiveTaskEntity)list.get(0) : null;
        if (receiveTaskEntity != null) {
            log.info("\u53d6\u51fa\u4efb\u52a1\u6587\u4ef6");
            File taskFile = Base64Util.base64ToFile((String)receiveDto.getImg_base64(), (String)receiveTaskEntity.getPackageUrl().concat(File.separator).concat("FERRY_FILE_").concat(receiveDto.getFerryTaskId()).concat(".ferry"), (boolean)true);
            log.info("\u4efb\u52a1\u6587\u4ef6\uff1a{}", (Object)taskFile.getName());
            String fileContent = FileUtil.readUtf8String((File)taskFile);
            FerryTaskInfoDto ferryTaskInfoDto = (FerryTaskInfoDto)JSONObject.parseObject((String)fileContent, FerryTaskInfoDto.class);
            receiveTaskEntity.setFileTotalCount(Integer.valueOf(CollectionUtil.isNotEmpty((Collection)ferryTaskInfoDto.getFerryTaskFileEntityList()) ? ferryTaskInfoDto.getFerryTaskFileEntityList().size() : 0));
            receiveTaskEntity.setFileReceiveCount(Integer.valueOf(1));
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.PARSE_TASK_FILE.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
            return ferryTaskInfoDto.getFerryTaskFileEntityList();
        }
        return null;
    }

    @Transactional
    public void initTaskInfo(FerryFileDto receiveDto, List<FerryTaskFileEntity> ferryTaskFileEntityList, String packageUrl) {
        FerryReceiveTaskEntity receiveTaskEntity;
        log.info("\u521d\u59cb\u5316\u4efb\u52a1\u4fe1\u606f");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getFerryTaskId, (Object)Long.parseLong(receiveDto.getFerryTaskId()));
        List list = lqw.list();
        FerryReceiveTaskEntity ferryReceiveTaskEntity = receiveTaskEntity = CollectionUtil.isNotEmpty((Collection)list) ? (FerryReceiveTaskEntity)list.get(0) : null;
        if (receiveTaskEntity != null && CollectionUtil.isNotEmpty(ferryTaskFileEntityList)) {
            ArrayList<FerryReceiveTaskFileEntity> ferryReceiveTaskFileEntityList = new ArrayList<FerryReceiveTaskFileEntity>();
            for (FerryTaskFileEntity fileEntity : ferryTaskFileEntityList) {
                FerryReceiveTaskFileEntity receiveTaskFileEntity = this.ferryReceiveTaskFileService.createFerryReceiveTaskFile(receiveTaskEntity, fileEntity);
                if (receiveTaskFileEntity.getId() == Long.parseLong(receiveDto.getFileId())) {
                    log.info("\u4efb\u52a1\u6587\u4ef6\uff0c\u76f4\u63a5\u8bbe\u7f6e\u63a5\u6536\u5b8c\u6210");
                    receiveTaskFileEntity.setReceiveFileMd5(MD5.create().digestHex16(new File(packageUrl.concat(File.separator).concat("FERRY_FILE_").concat(receiveDto.getFerryTaskId()).concat(".ferry"))));
                    receiveTaskFileEntity.setReceiveResult("\u63a5\u6536\u5b8c\u6210");
                    receiveTaskFileEntity.setFileStatus(Integer.valueOf(2));
                }
                ferryReceiveTaskFileEntityList.add(receiveTaskFileEntity);
            }
            log.info("\u672c\u6b21\u6446\u6e21\u603b\u6587\u4ef6\u6570\u91cf\uff1a{}", (Object)ferryReceiveTaskFileEntityList.size());
            this.ferryReceiveTaskFileService.saveBatch(ferryReceiveTaskFileEntityList);
            log.info("\u672c\u6b21\u6446\u6e21\u603b\u6587\u4ef6\u90fd\u4fdd\u5b58\u5165\u5e93\u5b8c\u6210");
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.INIT_TASK_INFO.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
            log.info("\u4fee\u6539\u63a5\u6536\u4efb\u52a1\u72b6\u6001\u4e3a\uff1a{}", (Object)FerryReceiveTaskStatusEnum.INIT_TASK_INFO.getCode());
        }
    }

    @Transactional
    public void taskFileCallback(FerryFileDto receiveDto) {
        FerryReceiveTaskEntity receiveTaskEntity;
        log.info("\u4efb\u52a1\u6587\u4ef6\u56de\u8c03\u8bf7\u6c42\u7aef");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getFerryTaskId, (Object)Long.parseLong(receiveDto.getFerryTaskId()));
        List list = lqw.list();
        FerryReceiveTaskEntity ferryReceiveTaskEntity = receiveTaskEntity = CollectionUtil.isNotEmpty((Collection)list) ? (FerryReceiveTaskEntity)list.get(0) : null;
        if (receiveTaskEntity != null && receiveTaskEntity.getTaskStatus().intValue() == FerryReceiveTaskStatusEnum.INIT_TASK_INFO.getCode()) {
            this.ferryReceiveTaskFileService.callbackToBoundary(Long.valueOf(Long.parseLong(receiveDto.getFileId())), SendBoundaryUrlEnum.SEND_TASK_FILE_CALLBACK);
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.TASK_FILE_CALLBACK.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
        }
    }

    @Transactional
    public void updateTaskStatusReceiveDetailFileBegin(Long ferryTaskId) {
        FerryReceiveTaskEntity receiveTaskEntity;
        log.info("\u63a5\u6536\u660e\u7ec6\u6587\u4ef6\u5f00\u59cb");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getFerryTaskId, (Object)ferryTaskId);
        List list = lqw.list();
        FerryReceiveTaskEntity ferryReceiveTaskEntity = receiveTaskEntity = CollectionUtil.isNotEmpty((Collection)list) ? (FerryReceiveTaskEntity)list.get(0) : null;
        if (receiveTaskEntity != null && receiveTaskEntity.getTaskStatus().intValue() == FerryReceiveTaskStatusEnum.TASK_FILE_CALLBACK.getCode()) {
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.RECEIVE_DETAIL_FILE_BEGIN.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
        }
    }

    @Transactional
    public void updateTaskStatusReceiveDetailFileComplete(Long ferryTaskId) {
        FerryReceiveTaskEntity receiveTaskEntity;
        log.info("\u63a5\u6536\u660e\u7ec6\u6587\u4ef6\u5b8c\u6210");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getFerryTaskId, (Object)ferryTaskId);
        List list = lqw.list();
        FerryReceiveTaskEntity ferryReceiveTaskEntity = receiveTaskEntity = CollectionUtil.isNotEmpty((Collection)list) ? (FerryReceiveTaskEntity)list.get(0) : null;
        if (receiveTaskEntity != null) {
            receiveTaskEntity.setFileReceiveCount(Integer.valueOf(receiveTaskEntity.getFileReceiveCount() + 1));
            long count = this.ferryReceiveTaskFileService.countNotCompleteByTaskId(receiveTaskEntity.getId());
            if (count == 0L) {
                log.info("\u660e\u7ec6\u6587\u4ef6\u90fd\u5df2\u5b8c\u6210\u63a5\u6536\uff0c\u4fee\u6539\u63a5\u6536\u4efb\u52a1\u72b6\u6001");
                receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.RECEIVE_DETAIL_FILE_COMPLETE.getCode()));
            }
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
        }
    }

    @Transactional
    public List<FerryReceiveTaskEntity> queryReceiveDetailFileComplete() {
        log.info("\u67e5\u8be2\u662f\u5426\u6709\u63a5\u6536\u660e\u7ec6\u6587\u4ef6\u5b8c\u6210\u7684\u4efb\u52a1");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getTaskStatus, (Object)FerryReceiveTaskStatusEnum.RECEIVE_DETAIL_FILE_COMPLETE.getCode());
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryReceiveTaskEntity receiveTaskEntity : list) {
                if (receiveTaskEntity == null) continue;
                log.info("\u4fee\u6539\u63a5\u6536\u4efb\u52a1\u72b6\u6001\u4e3a\uff1a\u5408\u5e76\u6587\u4ef6\u5f00\u59cb");
                receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.MERGE_FILE_BEGIN.getCode()));
                receiveTaskEntity.setUpdateTime(new Date());
                this.updateById((Object)receiveTaskEntity);
            }
        }
        return list;
    }

    @Transactional
    public void mergeFile(FerryReceiveTaskEntity receiveTaskEntity) {
        log.info("\u904d\u5386\u660e\u7ec6\u6587\u4ef6\u5217\u8868\uff0c\u5408\u5e76\u6587\u4ef6");
        List fileEntityList = this.ferryReceiveTaskFileService.queryFerryCompleteList(receiveTaskEntity.getId());
        if (CollectionUtil.isNotEmpty((Collection)fileEntityList)) {
            log.info("\u9700\u8981\u5408\u5e76\u7684\u6587\u4ef6\u6570\u91cf\uff1a{}", (Object)fileEntityList.size());
            for (FerryReceiveTaskFileEntity fileEntity : fileEntityList) {
                String[] fileId;
                List fileIds;
                List childrenList;
                log.info("\u6587\u4ef6id\uff1a{}\uff0c\u5b50\u6587\u4ef6id\uff1a{}", (Object)fileEntity.getId(), (Object)fileEntity.getSplitFileIds());
                if (!StringUtils.isNotBlank((CharSequence)fileEntity.getSplitFileIds()) || !CollectionUtil.isNotEmpty((Collection)(childrenList = this.ferryReceiveTaskFileService.queryByIds(fileIds = Arrays.stream(fileId = fileEntity.getSplitFileIds().split(",")).map(Long::parseLong).collect(Collectors.toList()))))) continue;
                List<File> fileList = childrenList.stream().map(childrenFile -> new File(this.receiveConfig.getPackageUrl().concat(childrenFile.getFileUrl()))).collect(Collectors.toList());
                File parentFile = new File(this.receiveConfig.getPackageUrl().concat(fileEntity.getFileUrl()));
                long fileSize = FileSpiltMergeUtil.join((File[])fileList.toArray(new File[0]), (File)parentFile);
                if (fileSize > 0L) {
                    log.info("\u6587\u4ef6id\uff1a{}\uff0c\u5408\u5e76\u6210\u529f", (Object)fileEntity.getId());
                    fileEntity.setMergeStatus(Integer.valueOf(2));
                } else {
                    fileEntity.setReceiveResult("\u5408\u5e76\u5931\u8d25");
                    log.info("\u6587\u4ef6id\uff1a{}\uff0c\u5408\u5e76\u5931\u8d25", (Object)fileEntity.getId());
                }
                fileEntity.setUpdateTime(new Date());
                long sleepTime = 1000L;
                if (fileList.size() > 100) {
                    sleepTime = 20000L;
                } else if (fileList.size() > 50) {
                    sleepTime = 10000L;
                } else if (fileList.size() > 20) {
                    sleepTime = 5000L;
                } else if (fileList.size() > 10) {
                    sleepTime = 3000L;
                } else if (fileList.size() > 5) {
                    sleepTime = 2000L;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (File file : fileList) {
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
            this.ferryReceiveTaskFileService.updateBatchById((Collection)fileEntityList);
        }
    }

    @Transactional
    public void updateTaskStatusMergeFileComplete(Long id) {
        log.info("\u4fee\u6539\u63a5\u6536\u4efb\u52a1\u72b6\u6001-\u5408\u5e76\u6587\u4ef6\u5b8c\u6210");
        FerryReceiveTaskEntity receiveTaskEntity = (FerryReceiveTaskEntity)this.getById((Serializable)id);
        if (receiveTaskEntity != null) {
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.MERGE_FILE_COMPLETE.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
        }
    }

    @Transactional
    public void pushData(Long id) {
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\uff0c\u63a8\u9001\u6570\u636e");
        FerryReceiveTaskEntity receiveTaskEntity = (FerryReceiveTaskEntity)this.getById((Serializable)id);
        if (receiveTaskEntity != null) {
            this.retryService.postToBaiduutilServerPush(receiveTaskEntity);
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.PUSH_DATA.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
        }
    }

    @Transactional
    public void queryReceiveTaskIsComplete() {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getTaskStatus, (Object)FerryReceiveTaskStatusEnum.PUSH_DATA.getCode());
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryReceiveTaskEntity receiveTaskEntity : list) {
                FerryReceiveTaskPushResult result;
                if (receiveTaskEntity == null || (result = this.retryService.postToBaiduutilServerPushResult(receiveTaskEntity)) == null || result.getTaskStatus() == null) continue;
                receiveTaskEntity.setReceiveResult(result.getReceiveResult());
                receiveTaskEntity.setTaskStatus(result.getTaskStatus());
                receiveTaskEntity.setUpdateTime(new Date());
                this.updateById((Object)receiveTaskEntity);
            }
        } else {
            log.info("\u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u6267\u884c\u63a8\u9001\u64cd\u4f5c\u7684\u4efb\u52a1");
        }
    }

    @Transactional
    public List<FerryReceiveTaskEntity> queryReceiveTaskComplete() {
        log.info("\u67e5\u8be2\u662f\u5426\u6709\u6446\u6e21\u5b8c\u6210\u7684\u4efb\u52a1");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getTaskStatus, (Object)FerryReceiveTaskStatusEnum.FERRY_COMPLETE.getCode());
        return lqw.list();
    }

    public List<FerryReceiveTaskEntity> queryOneHourNotCompleteList() {
        Date intervalTime = DateUtil.getBeforeNumMinuteTime((Date)new Date(), (int)this.schedulingConfig.getScanErrorInfo().getTimeInterval());
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.ne(FerryReceiveTaskEntity::getTaskStatus, (Object)FerryReceiveTaskStatusEnum.CALLBACK_COMPLETE.getCode());
        lqw.lt(FerryReceiveTaskEntity::getCreateTime, (Object)intervalTime);
        lqw.orderByAsc(FerryReceiveTaskEntity::getCreateTime);
        return lqw.list();
    }

    public boolean isNotCreateNewTask() {
        FerryReceiveTaskEntity lastComplete;
        Date now = new Date();
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getTaskStatus, (Object)FerryReceiveTaskStatusEnum.CALLBACK_COMPLETE.getCode());
        lqw.orderByDesc(FerryReceiveTaskEntity::getCreateTime);
        lqw.last("limit 1");
        List list = lqw.list();
        FerryReceiveTaskEntity ferryReceiveTaskEntity = lastComplete = CollectionUtil.isNotEmpty((Collection)list) ? (FerryReceiveTaskEntity)list.get(0) : null;
        if (lastComplete != null && now.getTime() - lastComplete.getUpdateTime().getTime() > 6400L) {
            FerryReceiveTaskEntity lastTask;
            LambdaQueryChainWrapper lqw2 = this.lambdaQuery();
            lqw2.orderByDesc(FerryReceiveTaskEntity::getCreateTime);
            lqw2.last("limit 1");
            List list2 = lqw2.list();
            FerryReceiveTaskEntity ferryReceiveTaskEntity2 = lastTask = CollectionUtil.isNotEmpty((Collection)list2) ? (FerryReceiveTaskEntity)list2.get(0) : null;
            return lastTask != null && lastComplete.getId().longValue() == lastTask.getId().longValue();
        }
        return true;
    }
}

