/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.crypto.digest.MD5;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.emus.FerryTaskFileStatusEnum;
import com.bcxin.ferry.common.emus.FileTypeEnum;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.common.utils.Base64Util;
import com.bcxin.ferry.common.utils.DateUtil;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.configs.ReceiveConfig;
import com.bcxin.ferry.dao.mapper.FerryReceiveTaskFileMapper;
import com.bcxin.ferry.dtos.FerryFileCallbackDto;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.entity.FerryReceiveTaskFileEntity;
import com.bcxin.ferry.entity.FerryTaskFileEntity;
import com.bcxin.ferry.service.SendRequestToBoundaryService;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FerryReceiveTaskFileService
extends ServiceImpl<FerryReceiveTaskFileMapper, FerryReceiveTaskFileEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryReceiveTaskFileService.class);
    @Autowired
    private ReceiveConfig receiveConfig;
    @Autowired
    private SendRequestToBoundaryService sendRequestToBoundaryService;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    public FerryReceiveTaskFileEntity createFerryReceiveTaskFile(FerryReceiveTaskEntity receiveTaskEntity, FerryTaskFileEntity ferryTaskFileEntity) {
        FerryReceiveTaskFileEntity receiveTaskFileEntity = new FerryReceiveTaskFileEntity();
        BeanUtils.copyProperties((Object)ferryTaskFileEntity, (Object)receiveTaskFileEntity);
        receiveTaskFileEntity.setId(ferryTaskFileEntity.getId());
        receiveTaskFileEntity.setTaskId(receiveTaskEntity.getId());
        receiveTaskFileEntity.setFileStatus(Integer.valueOf(1));
        receiveTaskFileEntity.setMergeStatus(Integer.valueOf(1));
        receiveTaskFileEntity.setCreateTime(new Date());
        receiveTaskFileEntity.setUpdateTime(new Date());
        return receiveTaskFileEntity;
    }

    @Transactional
    public boolean receiveTaskDetailFile(Long id, String base64) {
        FerryReceiveTaskFileEntity receiveTaskFileEntity = (FerryReceiveTaskFileEntity)this.getById((Serializable)id);
        if (receiveTaskFileEntity.getFileStatus() == 2) {
            log.info("\u8be5\u660e\u7ec6\u6587\u4ef6\u5df2\u7ecf\u63a5\u6536\u4e86");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)base64)) {
            File file = Base64Util.base64ToFile((String)base64, (String)this.receiveConfig.getPackageUrl().concat(receiveTaskFileEntity.getFileUrl()), (receiveTaskFileEntity.getFileType().intValue() != FileTypeEnum.NORMAL.getCode() ? 1 : 0) != 0);
            receiveTaskFileEntity.setReceiveFileMd5(MD5.create().digestHex16(file));
        }
        receiveTaskFileEntity.setReceiveResult("\u63a5\u6536\u5b8c\u6210");
        receiveTaskFileEntity.setFileStatus(Integer.valueOf(2));
        receiveTaskFileEntity.setMergeStatus(Integer.valueOf(1));
        receiveTaskFileEntity.setUpdateTime(new Date());
        this.updateById((Object)receiveTaskFileEntity);
        return true;
    }

    public long countNotCompleteByTaskId(Long taskId) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskFileEntity::getTaskId, (Object)taskId);
        lqw.eq(FerryReceiveTaskFileEntity::getIsSplit, (Object)0);
        lqw.eq(FerryReceiveTaskFileEntity::getFileStatus, (Object)1);
        return lqw.count();
    }

    @Transactional
    public void callbackToBoundary(Long id, SendBoundaryUrlEnum urlEnum) {
        FerryReceiveTaskFileEntity receiveTaskFileEntity = (FerryReceiveTaskFileEntity)this.getById((Serializable)id);
        FerryFileCallbackDto callbackDto = new FerryFileCallbackDto();
        callbackDto.setFerry_accept_url(urlEnum.getValue());
        callbackDto.setFileId(receiveTaskFileEntity.getId().toString());
        callbackDto.setFileStatus(Integer.valueOf(FerryTaskFileStatusEnum.FERRY_COMPLETE.getCode()));
        callbackDto.setFerryResult("\u6446\u6e21\u5b8c\u6210");
        this.sendRequestToBoundaryService.send(BeanUtil.beanToMap((Object)callbackDto, (String[])new String[0]));
    }

    public List<FerryReceiveTaskFileEntity> queryFerryCompleteList(Long taskId) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskFileEntity::getTaskId, (Object)taskId);
        lqw.eq(FerryReceiveTaskFileEntity::getIsSplit, (Object)1);
        lqw.eq(FerryReceiveTaskFileEntity::getFileStatus, (Object)2);
        return lqw.list();
    }

    public List<FerryReceiveTaskFileEntity> queryByIds(List<Long> ids) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.in(FerryReceiveTaskFileEntity::getId, ids);
        return lqw.list();
    }

    public List<FerryReceiveTaskFileEntity> queryHalfHourNotCompleteList() {
        Date intervalTime = DateUtil.getBeforeNumMinuteTime((Date)new Date(), (int)30);
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.ne(FerryReceiveTaskFileEntity::getFileStatus, (Object)1);
        lqw.lt(FerryReceiveTaskFileEntity::getCreateTime, (Object)intervalTime);
        lqw.orderByAsc(FerryReceiveTaskFileEntity::getCreateTime);
        return lqw.list();
    }
}

