/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.dao.mapper.FerryErrorInfoMapper;
import com.bcxin.ferry.entity.FerryErrorInfoEntity;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.entity.FerryTaskFileEntity;
import com.bcxin.ferry.service.FerryReceiveTaskFileService;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import com.bcxin.ferry.service.FerryTaskFileService;
import com.bcxin.ferry.service.FerryTaskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FerryErrorInfoService
extends ServiceImpl<FerryErrorInfoMapper, FerryErrorInfoEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryErrorInfoService.class);
    @Autowired
    private FerryTaskService ferryTaskService;
    @Autowired
    private FerryTaskFileService ferryTaskFileService;
    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private FerryReceiveTaskFileService ferryReceiveTaskFileService;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    public void scanErrorInfo() {
        log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:1\u3001\u662f\u5426\u6709\u5927\u4e8e\u4e00\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210\u7684\u4efb\u52a1\uff1f");
        ArrayList<FerryErrorInfoEntity> insertList = new ArrayList<FerryErrorInfoEntity>();
        List notCompleteFerryTaskList = this.ferryTaskService.queryOneHourNotCompleteList();
        if (CollectionUtil.isNotEmpty((Collection)notCompleteFerryTaskList)) {
            for (Object ferryTaskEntity : notCompleteFerryTaskList) {
                log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:1\u3001\u6709");
                insertList.add(this.createFerryErrorInfoEntity(ferryTaskEntity.getId(), null, null, null, "\u6446\u6e21\u4efb\u52a1\u5927\u4e8e\u4e00\u4e2a\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210"));
            }
        }
        log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:2\u3001\u4e0a\u4e2a\u4efb\u52a1\u5b8c\u6210\u65f6\u95f4\u662f\u5426\u5927\u4e8e\u4e00\u4e2a\u534a\u5c0f\u65f6\u8fd8\u672a\u751f\u6210\u65b0\u4efb\u52a1\uff08\u6682\u65f6\u53bb\u6389\uff09");
        log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:3\u3001\u662f\u5426\u6709\u5927\u4e8e\u534a\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210\u7684\u6587\u4ef6\uff1f");
        List notCompleteFerryFileList = this.ferryTaskFileService.queryHalfHourNotCompleteList();
        if (CollectionUtil.isNotEmpty((Collection)notCompleteFerryFileList)) {
            log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:3\u3001\u6709");
            for (FerryTaskFileEntity fileEntity : notCompleteFerryFileList) {
                log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:\u6587\u4ef6id\uff1a{}\uff0c\u5927\u4e8e\u534a\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210\uff0c\u8fdb\u884c\u91cd\u8bd5", (Object)fileEntity.getId());
                if (fileEntity.getRetryCount() == null || fileEntity.getRetryCount() < 10) {
                    log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:\u6587\u4ef6id\uff1a{}\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a{}", (Object)fileEntity.getId(), (Object)(fileEntity.getRetryCount() == null ? 1 : fileEntity.getRetryCount() + 1));
                    this.ferryTaskFileService.ferryFileToBoundary(fileEntity, SendBoundaryUrlEnum.SEND_DETAIL_FILE);
                    continue;
                }
                log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:\u6587\u4ef6id\uff1a{}\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a{}\uff0c\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u8bb0\u5f55\u8bb0\u5f55\uff0c\u4e0d\u518d\u91cd\u8bd5", (Object)fileEntity.getId(), (Object)(fileEntity.getRetryCount() == null ? 1 : fileEntity.getRetryCount() + 1));
                insertList.add(this.createFerryErrorInfoEntity(fileEntity.getTaskId(), fileEntity.getId(), null, null, "\u6446\u6e21\u6587\u4ef6\u5927\u4e8e\u4e00\u4e2a\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210"));
            }
        }
        log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:4\u3001\u662f\u5426\u6709\u63a5\u6536\u4efb\u52a1\u5927\u4e8e\u4e00\u4e2a\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210\u7684\u4efb\u52a1\uff1f");
        List notCompleteReceiveTaskList = this.ferryReceiveTaskService.queryOneHourNotCompleteList();
        if (CollectionUtil.isNotEmpty((Collection)notCompleteReceiveTaskList)) {
            log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:4\u3001\u6709");
            for (FerryReceiveTaskEntity receiveTaskEntity : notCompleteReceiveTaskList) {
                insertList.add(this.createFerryErrorInfoEntity(receiveTaskEntity.getFerryTaskId(), null, receiveTaskEntity.getId(), null, "\u63a5\u6536\u4efb\u52a1\u5927\u4e8e\u4e00\u4e2a\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210"));
            }
        }
        log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:5\u3001\u662f\u5426\u6709\u4e0a\u4e2a\u63a5\u6536\u4efb\u52a1\u5b8c\u6210\u65f6\u95f4\u5927\u4e8e\u4e00\u4e2a\u534a\u5c0fx\u65f6\u8fd8\u672a\u751f\u6210\u65b0\u4efb\u52a1\uff1f");
        if (this.ferryReceiveTaskService.isNotCreateNewTask()) {
            log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:5\u3001\u6709");
            insertList.add(this.createFerryErrorInfoEntity(null, null, null, null, "\u4e0a\u4e2a\u63a5\u6536\u4efb\u52a1\u5b8c\u6210\u65f6\u95f4\u5927\u4e8e\u4e00\u4e2a\u534a\u5c0f\u65f6\u8fd8\u672a\u751f\u6210\u65b0\u4efb\u52a1"));
        }
        log.info("\u626b\u63cf\u5f02\u5e38\u4fe1\u606f:6\u3001\u662f\u5426\u63a5\u6536\u6587\u4ef6\u5927\u4e8e\u4e00\u4e2a\u5c0f\u65f6\u8fd8\u672a\u6446\u6e21\u5b8c\u6210\uff1f\uff08\u6682\u65f6\u53bb\u6389\uff09");
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.saveBatch(insertList);
        }
    }

    private FerryErrorInfoEntity createFerryErrorInfoEntity(Long ferryTaskId, Long ferryFileId, Long receiveTaskId, Long receiveFileId, String errorMessage) {
        FerryErrorInfoEntity entity = new FerryErrorInfoEntity();
        entity.setId(Long.valueOf(this.snowflake.snowflakeId()));
        entity.setFerryTaskId(ferryTaskId);
        entity.setFerryFileId(ferryFileId);
        entity.setReceiveTaskId(receiveTaskId);
        entity.setReceiveFileId(receiveFileId);
        entity.setErrorMessage(errorMessage);
        entity.setHandleStatus(Integer.valueOf(1));
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        return entity;
    }
}

