/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.scheduling;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.ferry.common.emus.FerryReceiveTaskStatusEnum;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.dtos.FerryDto;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import com.bcxin.ferry.service.SendRequestToBoundaryService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class QueryReceiveTaskComplete {
    private static final Logger log = LoggerFactory.getLogger(QueryReceiveTaskComplete.class);
    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private SendRequestToBoundaryService sendRequestToBoundaryService;

    @Scheduled(cron="${scheduling-config.query-receive-task-complete.cron}")
    public void queryReceiveTaskComplete() {
        log.info("===================================\u5b9a\u65f6\u67e5\u8be2\u63a5\u6536\u4efb\u52a1\u72b6\u6001-\u6446\u6e21\u5b8c\u6210===================================");
        this.ferryReceiveTaskService.queryReceiveTaskIsComplete();
        List list = this.ferryReceiveTaskService.queryReceiveTaskComplete();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryReceiveTaskEntity receiveTaskEntity : list) {
                log.info("\u6446\u6e21\u5b8c\u6210\u56de\u8c03\uff0ctaskId\uff1a{}\uff0crequestId\uff1a{}", (Object)receiveTaskEntity.getFerryTaskId().toString(), (Object)receiveTaskEntity.getRequestId());
                FerryDto callbackDto = new FerryDto();
                callbackDto.setFerry_accept_url(SendBoundaryUrlEnum.SEND_FERRY_COMPLETE_CALLBACK.getValue());
                callbackDto.setFerryTaskId(receiveTaskEntity.getFerryTaskId().toString());
                callbackDto.setFerryTaskResult(receiveTaskEntity.getReceiveResult());
                this.sendRequestToBoundaryService.send(BeanUtil.beanToMap((Object)callbackDto, (String[])new String[0]));
                receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.CALLBACK_COMPLETE.getCode()));
                receiveTaskEntity.setUpdateTime(new Date());
                this.ferryReceiveTaskService.updateById((Object)receiveTaskEntity);
            }
        }
        log.info("===================================\u67e5\u8be2\u63a5\u6536\u4efb\u52a1\u72b6\u6001-\u6446\u6e21\u5b8c\u6210\u7ed3\u675f===================================");
    }
}

