/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ZipUtil;
import com.bcxin.ferry.common.utils.ObsUtil;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import com.bcxin.ferry.service.RetryService;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class QueryReceiveDetailFileComplete {
    private static final Logger log = LoggerFactory.getLogger(QueryReceiveDetailFileComplete.class);
    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private RetryService retryService;
    @Value(value="${spring.profiles.active}")
    private String activeFile;

    @Scheduled(cron="${scheduling-config.query-receive-detail-file-complete.cron}")
    public void queryReceiveDetailFileComplete() {
        log.info("===================================\u5b9a\u65f6\u67e5\u8be2\u63a5\u6536\u4efb\u52a1\u72b6\u6001-\u63a5\u6536\u660e\u7ec6\u6587\u4ef6\u5b8c\u6210===================================");
        List list = this.ferryReceiveTaskService.queryReceiveDetailFileComplete();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryReceiveTaskEntity receiveTaskEntity : list) {
                this.ferryReceiveTaskService.mergeFile(receiveTaskEntity);
                this.ferryReceiveTaskService.updateTaskStatusMergeFileComplete(receiveTaskEntity.getId());
                if (!this.zipAndUpload(receiveTaskEntity)) continue;
                this.ferryReceiveTaskService.pushData(receiveTaskEntity.getId());
            }
        }
        log.info("===================================\u67e5\u8be2\u63a5\u6536\u4efb\u52a1\u72b6\u6001-\u63a5\u6536\u660e\u7ec6\u6587\u4ef6\u5b8c\u6210\u7ed3\u675f===================================");
    }

    private boolean zipAndUpload(FerryReceiveTaskEntity receiveTaskEntity) {
        if ("out-prod".equals(this.activeFile)) {
            String filePath = receiveTaskEntity.getPackageUrl();
            File zip = ZipUtil.zip((String)filePath);
            boolean isPushZw = receiveTaskEntity.getIsPushZw() != null && receiveTaskEntity.getIsPushZw() == 1;
            int uploadCount = 0;
            boolean uploadResult = false;
            if (isPushZw) {
                while (!uploadResult && uploadCount < 10) {
                    uploadResult = this.retryService.postToBaiduutilServerUploadFile(receiveTaskEntity, zip);
                    log.info("\u7b2c{}\u6b21\u4e0a\u4f20\u5230\u653f\u52a1\u5916\u7f51\uff0c\u4e0a\u4f20\uff1a{}", (Object)(++uploadCount), (Object)uploadResult);
                    if (uploadResult) continue;
                    log.info("\u4e0a\u4f20\u5931\u8d25\uff0c\u7b49\u5f852\u5206\u949f");
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                while (!uploadResult && uploadCount < 10) {
                    uploadResult = ObsUtil.uploadFile((File)zip, (String)filePath.substring(filePath.indexOf("baidu/")).concat(".zip"));
                    log.info("\u7b2c{}\u6b21\u4e0a\u4f20OBS\uff0c\u4e0a\u4f20\uff1a{}", (Object)(++uploadCount), (Object)uploadResult);
                    if (uploadResult) continue;
                    log.info("\u4e0a\u4f20\u5931\u8d25\uff0c\u7b49\u5f852\u5206\u949f");
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            return uploadResult;
        }
        return true;
    }
}

