/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.scheduling;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.emus.FileTypeEnum;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.common.queue.DetailFileQueue;
import com.bcxin.ferry.dtos.FerryFileDto;
import com.bcxin.ferry.service.FerryReceiveTaskFileService;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DetailFileReceiveQueueTake {
    private static final Logger log = LoggerFactory.getLogger(DetailFileReceiveQueueTake.class);
    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private FerryReceiveTaskFileService ferryReceiveTaskFileService;

    @Scheduled(cron="10 */1 * * * ?")
    public void queueTake() {
        log.info("===================================\u5b9a\u65f6\u4ece\u660e\u7ec6\u6587\u4ef6\u961f\u5217\u53d6\u503c\u5e76\u64cd\u4f5c===================================");
        while (DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.size() > 0) {
            String data = null;
            try {
                boolean receiveTaskFileSuccess;
                log.info("\u660e\u7ec6\u6587\u4ef6\u961f\u5217\u6709\u503c\uff0c\u5927\u5c0f\uff1a{}\uff0c\u53ef\u4ee5\u53d6\u503c", (Object)DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.size());
                data = (String)DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.take();
                FerryFileDto ferryFileDto = (FerryFileDto)JSONObject.parseObject((String)data, FerryFileDto.class);
                log.info("\u63a5\u6536\u660e\u7ec6\u6587\u4ef6\u7b56\u7565\uff0c\u57fa\u672c\u53c2\u6570");
                log.info("ferryTaskId\uff1a{}", (Object)ferryFileDto.getFerryTaskId());
                log.info("requestId\uff1a{}", (Object)ferryFileDto.getRequestId());
                log.info("fileId\uff1a{}", (Object)ferryFileDto.getFileId());
                log.info("fileType\uff1a{}", (Object)ferryFileDto.getFileType());
                this.ferryReceiveTaskService.updateTaskStatusReceiveDetailFileBegin(Long.valueOf(Long.parseLong(ferryFileDto.getFerryTaskId())));
                if (ferryFileDto.getFileType().intValue() != FileTypeEnum.NORMAL.getCode()) {
                    log.info("\u6587\u4ef6\u7c7b\u578b\u4e0d\u662f\u666e\u901a\u6587\u4ef6\uff0c\u9700\u8981\u8f6c\u6587\u4ef6\u7684base64\u5b57\u7b26\u4e32\uff0c\u6587\u4ef6id\uff1a{}", (Object)ferryFileDto.getFileId());
                    ferryFileDto.putFileContent(data);
                }
                if (!(receiveTaskFileSuccess = this.ferryReceiveTaskFileService.receiveTaskDetailFile(Long.valueOf(Long.parseLong(ferryFileDto.getFileId())), ferryFileDto.getImg_base64()))) continue;
                this.ferryReceiveTaskFileService.callbackToBoundary(Long.valueOf(Long.parseLong(ferryFileDto.getFileId())), SendBoundaryUrlEnum.SEND_DETAIL_FILE_CALLBACK);
                this.ferryReceiveTaskService.updateTaskStatusReceiveDetailFileComplete(Long.valueOf(Long.parseLong(ferryFileDto.getFerryTaskId())));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5b9a\u65f6\u4ece\u660e\u7ec6\u6587\u4ef6\u961f\u5217\u53d6\u503c\u5e76\u64cd\u4f5c\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                if (!StringUtils.isNotBlank((CharSequence)data)) continue;
                try {
                    log.info("\u5b9a\u65f6\u4ece\u660e\u7ec6\u6587\u4ef6\u961f\u5217\u53d6\u503c\u5e76\u64cd\u4f5c\u5f02\u5e38\uff0c\u53c2\u6570\u653e\u5165\u961f\u5217");
                    DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.put(data);
                    log.info("\u5b9a\u65f6\u4ece\u660e\u7ec6\u6587\u4ef6\u961f\u5217\u53d6\u503c\u5e76\u64cd\u4f5c\u5f02\u5e38\uff0c\u53c2\u6570\u653e\u5165\u961f\u5217\uff0c\u5b8c\u6210");
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    log.error("\u5b9a\u65f6\u4ece\u660e\u7ec6\u6587\u4ef6\u961f\u5217\u53d6\u503c\u5e76\u64cd\u4f5c\u5f02\u5e38\uff0c\u53c2\u6570\u653e\u5165\u961f\u5217\u5f02\u5e38\uff0c{}", (Object)ie.getMessage(), (Object)ie);
                }
            }
        }
        log.info("===================================\u5b9a\u65f6\u4ece\u660e\u7ec6\u6587\u4ef6\u961f\u5217\u53d6\u503c\u5e76\u64cd\u4f5c\u7ed3\u675f===================================");
    }
}

