/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.scheduling;

import com.bcxin.ferry.configs.BaiduutilServerConfig;
import com.bcxin.ferry.service.FerryTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CreateFerryTask {
    private static final Logger log = LoggerFactory.getLogger(CreateFerryTask.class);
    @Autowired
    private FerryTaskService ferryTaskService;
    @Autowired
    private BaiduutilServerConfig baiduutilServerConfig;
    @Value(value="${spring.profiles.active}")
    private String activeFile;

    @Scheduled(cron="${scheduling-config.create-ferry-task.cron}")
    public void createFerryTask() {
        log.info("===================================\u5b9a\u65f6\u521b\u5efa\u6446\u6e21\u4efb\u52a1===================================");
        String regionCodes = this.baiduutilServerConfig.getRegionCodes();
        log.info("===================================regionCodes\uff1a{}===================================", (Object)regionCodes);
        for (String regionCode : regionCodes.split(",")) {
            log.info("===================================regionCode\uff1a{}===================================", (Object)regionCode);
            this.ferryTaskService.createFerryTask(regionCode);
            if (!"in-beijing".equals(this.activeFile)) continue;
            log.info("===================================\u5317\u4eac\u5185\u7f51\uff0c\u9700\u8981\u7b495\u5206\u949f\u6267\u884c\u4e0b\u4e00\u4e2a===================================");
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            log.info("===================================5\u5206\u949f\u5230\u4e86===================================");
        }
        log.info("===================================\u521b\u5efa\u6446\u6e21\u4efb\u52a1\u7ed3\u675f===================================");
    }
}

