/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSpiltMergeUtil {
    private static final Logger log = LoggerFactory.getLogger(FileSpiltMergeUtil.class);

    public static List<String> splitFile(long maxSize, File original) {
        log.info("\u6587\u4ef6\uff1a{}\uff0c\u5f00\u59cb\u62c6\u5206", (Object)original.getAbsolutePath());
        String name = original.getName();
        if (name.contains(".")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        name = name + "-s-";
        long size = (long)((double)maxSize * 0.8);
        File directory = original.getParentFile();
        ArrayList<String> childrenFilePathList = new ArrayList<String>();
        int count = 1;
        try (FileInputStream fis = new FileInputStream(original);){
            if (size <= 0x7FFFFFF7L) {
                byte[] bytes = new byte[(int)size];
                while (fis.available() != 0) {
                    int readSize = fis.read(bytes);
                    File outFile = new File(directory, name + count++ + ".kfm");
                    FileOutputStream fos = new FileOutputStream(outFile);
                    fos.write(bytes, 0, readSize);
                    log.info("\u62c6\u5206\u51fa\u6587\u4ef6\uff1a{}", (Object)outFile.getName());
                    fos.close();
                    childrenFilePathList.add(outFile.getAbsolutePath());
                }
            } else {
                while (fis.available() != 0) {
                    byte[] bytes;
                    long sum;
                    int readSize;
                    File outFile = new File(directory, name + count++ + ".part");
                    FileOutputStream fos = new FileOutputStream(outFile);
                    for (sum = size; sum > 0x7FFFFFF7L && fis.available() != 0; sum -= (long)readSize) {
                        bytes = new byte[0x7FFFFFF7];
                        readSize = fis.read(bytes);
                        fos.write(bytes, 0, readSize);
                    }
                    if (fis.available() != 0) {
                        bytes = new byte[(int)sum];
                        readSize = fis.read(bytes);
                        fos.write(bytes, 0, readSize);
                    }
                    log.info("\u62c6\u5206\u51fa\u6587\u4ef6\uff1a{}", (Object)outFile.getName());
                    fos.close();
                    childrenFilePathList.add(outFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childrenFilePathList;
    }

    public static long join(File[] files, File target) {
        long size = 0L;
        if (files == null || files.length == 0) {
            return size;
        }
        if (target == null) {
            return size;
        }
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        Arrays.sort(files, (f1, f2) -> {
            String name1 = f1.getName();
            String name2 = f2.getName();
            int index1 = Integer.parseInt(name1.substring(name1.indexOf("-s-") + 3, name1.length() - 4));
            int index2 = Integer.parseInt(name2.substring(name2.indexOf("-s-") + 3, name2.length() - 4));
            return index1 - index2;
        });
        try {
            FileOutputStream fos = new FileOutputStream(target);
            for (File file : files) {
                FileInputStream fileInputStream = new FileInputStream(file);
                while (fileInputStream.available() != 0) {
                    byte[] bytes = new byte[1024];
                    int readSize = fileInputStream.read(bytes);
                    fos.write(bytes, 0, readSize);
                }
                fileInputStream.close();
                size += file.length();
            }
            fos.close();
        }
        catch (IOException e) {
            log.error("\u5408\u5e76\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return size;
    }

    public static void main(String[] args) {
    }
}

