package com.bcxin.file.model;


import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.file.MD5Util;
import com.mysql.cj.util.StringUtils;

import java.util.Objects;

public class FileLog {

    private String fileUrl;

    private String md5;

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FileLog fileLog = (FileLog) o;
        return md5.equals(fileLog.md5) || getMd5Subs().equals(fileLog.getMd5Subs());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getMd5Subs());
    }

    private String md5SubStr;
    public String getMd5Subs() {
        String url = this.getFileUrl();
        if (StringUtils.isNullOrEmpty(url)) {
            return null;
        }

        if(StringUtils.isNullOrEmpty(md5SubStr)) {
            if (url.startsWith("http")) {
                url = url.substring(url.indexOf("/"));
            }
            md5SubStr = MD5Util.encryptToMD5(url);
        }

        return md5SubStr;
    }

    public String getSqlWhere() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("'%s'", this.getMd5()));
        if (!StringUtils.isNullOrEmpty(this.getMd5Subs())) {
            sb.append(String.format(",'%s'", this.getMd5()));
        }

        return sb.toString();
    }
}
