/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.configs;

import cn.hutool.core.bean.BeanUtil;
import com.bcxin.autodownloadupload.common.utils.DateUtil;
import com.bcxin.autodownloadupload.configs.PullConfig;
import com.bcxin.autodownloadupload.dtos.ChangeLogsRequestDto;
import java.util.Date;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="pull-config")
public class PullConfig {
    private String api;
    private String obsUrl;
    private String fileSqlCount;
    private String v5Path;
    private Boolean isRemoveRepeat;
    private String completedPath;
    private Scheduled scheduled;
    private DatasourceConfig datasource;

    public ChangeLogsRequestDto getChangeLogsRequestDto() {
        Date now = new Date();
        String week = DateUtil.getWeekEngStrOfDate((Date)now);
        Map timeRangeMap = BeanUtil.beanToMap((Object)this.getScheduled().getTimeRange(), (String[])new String[0]);
        int range = Integer.parseInt(timeRangeMap.get(week).toString());
        if (range != 0) {
            ChangeLogsRequestDto dto = new ChangeLogsRequestDto();
            dto.setFromTime(DateUtil.getBeforeNumDayZeroTime((Date)now, (int)range));
            dto.setEndTime(DateUtil.getDateZeroTime((Date)now));
            dto.setRegionCodes(this.getScheduled().getRegionCodes());
            dto.setTables(this.getScheduled().getTables());
            dto.setIsRemoveRepeat(this.getIsRemoveRepeat());
            return dto;
        }
        return null;
    }

    public String getApi() {
        return this.api;
    }

    public String getObsUrl() {
        return this.obsUrl;
    }

    public String getFileSqlCount() {
        return this.fileSqlCount;
    }

    public String getV5Path() {
        return this.v5Path;
    }

    public Boolean getIsRemoveRepeat() {
        return this.isRemoveRepeat;
    }

    public String getCompletedPath() {
        return this.completedPath;
    }

    public Scheduled getScheduled() {
        return this.scheduled;
    }

    public DatasourceConfig getDatasource() {
        return this.datasource;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setObsUrl(String obsUrl) {
        this.obsUrl = obsUrl;
    }

    public void setFileSqlCount(String fileSqlCount) {
        this.fileSqlCount = fileSqlCount;
    }

    public void setV5Path(String v5Path) {
        this.v5Path = v5Path;
    }

    public void setIsRemoveRepeat(Boolean isRemoveRepeat) {
        this.isRemoveRepeat = isRemoveRepeat;
    }

    public void setCompletedPath(String completedPath) {
        this.completedPath = completedPath;
    }

    public void setScheduled(Scheduled scheduled) {
        this.scheduled = scheduled;
    }

    public void setDatasource(DatasourceConfig datasource) {
        this.datasource = datasource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PullConfig)) {
            return false;
        }
        PullConfig other = (PullConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isRemoveRepeat = this.getIsRemoveRepeat();
        Boolean other$isRemoveRepeat = other.getIsRemoveRepeat();
        if (this$isRemoveRepeat == null ? other$isRemoveRepeat != null : !((Object)this$isRemoveRepeat).equals(other$isRemoveRepeat)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$obsUrl = this.getObsUrl();
        String other$obsUrl = other.getObsUrl();
        if (this$obsUrl == null ? other$obsUrl != null : !this$obsUrl.equals(other$obsUrl)) {
            return false;
        }
        String this$fileSqlCount = this.getFileSqlCount();
        String other$fileSqlCount = other.getFileSqlCount();
        if (this$fileSqlCount == null ? other$fileSqlCount != null : !this$fileSqlCount.equals(other$fileSqlCount)) {
            return false;
        }
        String this$v5Path = this.getV5Path();
        String other$v5Path = other.getV5Path();
        if (this$v5Path == null ? other$v5Path != null : !this$v5Path.equals(other$v5Path)) {
            return false;
        }
        String this$completedPath = this.getCompletedPath();
        String other$completedPath = other.getCompletedPath();
        if (this$completedPath == null ? other$completedPath != null : !this$completedPath.equals(other$completedPath)) {
            return false;
        }
        Scheduled this$scheduled = this.getScheduled();
        Scheduled other$scheduled = other.getScheduled();
        if (this$scheduled == null ? other$scheduled != null : !this$scheduled.equals(other$scheduled)) {
            return false;
        }
        DatasourceConfig this$datasource = this.getDatasource();
        DatasourceConfig other$datasource = other.getDatasource();
        return !(this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PullConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isRemoveRepeat = this.getIsRemoveRepeat();
        result = result * 59 + ($isRemoveRepeat == null ? 43 : ((Object)$isRemoveRepeat).hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $obsUrl = this.getObsUrl();
        result = result * 59 + ($obsUrl == null ? 43 : $obsUrl.hashCode());
        String $fileSqlCount = this.getFileSqlCount();
        result = result * 59 + ($fileSqlCount == null ? 43 : $fileSqlCount.hashCode());
        String $v5Path = this.getV5Path();
        result = result * 59 + ($v5Path == null ? 43 : $v5Path.hashCode());
        String $completedPath = this.getCompletedPath();
        result = result * 59 + ($completedPath == null ? 43 : $completedPath.hashCode());
        Scheduled $scheduled = this.getScheduled();
        result = result * 59 + ($scheduled == null ? 43 : $scheduled.hashCode());
        DatasourceConfig $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        return result;
    }

    public String toString() {
        return "PullConfig(api=" + this.getApi() + ", obsUrl=" + this.getObsUrl() + ", fileSqlCount=" + this.getFileSqlCount() + ", v5Path=" + this.getV5Path() + ", isRemoveRepeat=" + this.getIsRemoveRepeat() + ", completedPath=" + this.getCompletedPath() + ", scheduled=" + this.getScheduled() + ", datasource=" + this.getDatasource() + ")";
    }
}

