/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.MetaPageSettingEntity;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageSettingRepository;
import com.bcxin.tenant.bcx.domains.services.MetaPageSettingService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pageSettings.CreatePageSettingCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pageSettings.UpdatePageSettingCommand;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class MetaPageSettingServiceImpl
implements MetaPageSettingService {
    private final MetaPageSettingRepository repository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public MetaPageSettingServiceImpl(MetaPageSettingRepository repository, UnitWork unitWork, IdWorker idWorker) {
        this.repository = repository;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreatePageSettingCommand command) {
        MetaPageSettingEntity entity = new MetaPageSettingEntity(command.getIdentity(), command.getSettingType());
        this.unitWork.executeTran(() -> {
            entity.change(command.getName(), command.getNote(), command.getIdentity(), command.getJsonConfig(), command.isEnabled(), command.getCondition());
            this.repository.insert(entity);
        });
    }

    @Override
    public void dispatch(UpdatePageSettingCommand command) {
        MetaPageSettingEntity entity = (MetaPageSettingEntity)this.repository.getById(command.getId());
        if (entity == null) {
            throw new NoFoundTenantException();
        }
        entity.change(command.getName(), command.getNote(), command.getIdentity(), command.getJsonConfig(), command.isEnabled(), command.getCondition());
        this.unitWork.executeTran(() -> this.repository.update(entity));
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        this.unitWork.executeTran(() -> this.repository.delete(command.getId()));
    }

    @Override
    public void dispatch(Collection<CreatePageSettingCommand> commands) {
        Collection ids = commands.stream().map(ii -> String.format("%s_%s", ii.getSettingType().ordinal(), ii.getIdentity())).collect(Collectors.toSet());
        Collection<MetaPageSettingEntity> entities = this.repository.findByIds(ids);
        ArrayList<MetaPageSettingEntity> newEntities = new ArrayList<MetaPageSettingEntity>();
        for (CreatePageSettingCommand command : commands) {
            MetaPageSettingEntity entity = entities.stream().filter(ii -> ii.getIdentity().equals(command.getIdentity()) && ii.getSettingType() == command.getSettingType()).findFirst().orElse(null);
            if (entity == null) {
                entity = new MetaPageSettingEntity(command.getIdentity(), command.getSettingType());
                newEntities.add(entity);
            }
            entity.change(command.getName(), command.getNote(), command.getIdentity(), command.getJsonConfig(), command.isEnabled(), command.getCondition());
        }
        this.unitWork.executeTran(() -> {
            newEntities.forEach(ix -> this.repository.insert((Aggregate)ix));
            entities.forEach(ix -> this.repository.update((Aggregate)ix));
        });
    }
}

