package com.bcxin.tenant.bcx.infrastructures.valueTypes;

import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Data
public class StationCodeValueType extends ValueTypeAbstract {
    @Schema(name = "code", title = "驻勤点类型/工作组类型")
    private String code;
    @Schema(name = "name", title = "名称")
    private String name;
    @Schema(name = "icon", title = "岗点弹框图标; 没有值的画, 取mapIcon的可用值")
    private String icon;
    /**
     * 岗点打点
     */
    @Schema(name = "mapIcon", title = "岗点打点图标; 没有值的画, 使用默认图标")
    private String mapIcon;

    @Schema(name = "personOfflineMapIcon", title = "离线人员图标; 没有值的画, 取personMapIcon的可用值")
    private String personOfflineMapIcon;

    @Schema(name = "personMapIcon", title = "在线人员图标; 没有值的画, 使用默认图标")
    private String personMapIcon;

    private boolean onlyForStation;

    public static StationCodeValueType create(JsonProvider jsonProvider, String code, String name,
                                              String placeIconJson,
                                              String placeDetailIconJson,
                                              String personOfflineMapIcon,
                                              String personIconJson) {
        StationCodeValueType valueType = new StationCodeValueType();
        valueType.setCode(code);
        valueType.setName(name);

        valueType.setMapIcon(extractActualPath(jsonProvider, placeIconJson));
        valueType.setIcon(extractActualPath(jsonProvider, placeDetailIconJson));

        valueType.setPersonMapIcon(extractActualPath(jsonProvider, personIconJson));
        valueType.setPersonOfflineMapIcon(extractActualPath(jsonProvider, personOfflineMapIcon));


        return valueType;
    }

    private static String extractActualPath(JsonProvider jsonProvider, String jsonPath) {

        if (!StringUtil.isEmpty(jsonPath) && jsonPath.contains("[")) {
            try {
                if (!StringUtil.isEmpty(jsonPath) && jsonPath.contains("[")) {
                    Collection<V5AttachmentValueType> valueTypes =
                            jsonProvider.toObjects(V5AttachmentValueType.class, jsonPath);
                    if (valueTypes != null) {
                        return valueTypes.stream().map(ii -> ii.getPath()).findFirst().orElse(null);
                    }
                }
            } catch (Exception ex) {
            }
        }

        return jsonPath;
    }
}
