package com.bcxin.tenant.bcx.domains.utils;

import com.bcxin.tenant.bcx.domains.constants.DynamicConstants;
import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageDataJsonSnapshot;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageValueSnapshot;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DynamicPageDataEntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(DynamicPageDataEntityUtils.class);
    public static DynamicPageDataEntity translate2PageDataEntity(Map<String,Object> params, JsonProvider jsonProvider) {
        String id = (String) params.get(DynamicConstants.DYNAMIC_SYS_ID);

        Map<String, Object> rt = new HashMap<>();
        String sysJsonValue = (String) params.get(DynamicConstants.DYNAMIC_SYS_JSON_FIELD);
        /*
        if (!StringUtils.hasLength(sysJsonValue)) {
            throw new ArgumentTenantException("映射表单配置异常, 系统字段:sys_dynamic_json不能为空");
        }

         */

        DynamicPageValueSnapshot snapshot = jsonProvider.toObject(DynamicPageValueSnapshot.class, sysJsonValue);
        if (snapshot == null) {
            /**
             * 针对映射表单的查询功能，这个可为空
             */
            snapshot = DynamicPageValueSnapshot.empty();
            logger.error("页面数据非预期情况; 跟踪栈内容", new Exception());
        }

        if (CollectionUtils.isEmpty(snapshot.getColumnMappings())) {
            if(snapshot.getItems()!=null) {
                snapshot.getItems().forEach((k, v) -> {
                    if (!DynamicConstants.DYNAMIC_SYS_CURRENT.equals(k)) {
                        rt.put(k, v);
                    }
                });
            }

            params.forEach((k, v) -> {
                if (!DynamicConstants.DYNAMIC_SYS_JSON_FIELD.equals(k)) {
                    rt.put(k, v);
                }
            });
        } else {
            Set<String> allKeys = new HashSet<>();
            allKeys.addAll(params.keySet());
            allKeys.addAll(snapshot.getItems().keySet());

            for (String orKey : allKeys) {
                String mappedKey = orKey;
                if (snapshot.getColumnMappings().containsKey(orKey)) {
                    mappedKey = snapshot.getColumnMappings().get(orKey);
                }

                String rqKey = snapshot.getColumnMappings().get(mappedKey);
                if (rqKey == null) {
                    rqKey = mappedKey;
                }

                Object orValue = params.get(mappedKey);
                if (orValue == null) {
                    orValue = snapshot.getItems().get(mappedKey);
                }

                if (DynamicConstants.DYNAMIC_SYS_EXTEND_FIELD.equals(rqKey) ||
                        //DynamicConstants.DYNAMIC_SYS_JSON_FIELD.equals(rqKey) ||
                        DynamicConstants.DYNAMIC_SYS_CURRENT.equals(rqKey) ||
                        DynamicConstants.DYNAMIC_SYS_CREATOR_ID.equals(rqKey) ||
                        DynamicConstants.DYNAMIC_SYS_LAST_UPDATER_ID.equals(rqKey)
                ) {
                    continue;
                }

                if(DynamicConstants.DYNAMIC_SYS_JSON_FIELD.equals(rqKey))
                {
                    rt.put(rqKey, jsonProvider.toObject(DynamicPageDataJsonSnapshot.class,String.valueOf(orValue)));
                }else {
                    rt.put(rqKey, orValue);
                }

            }
        }

        DynamicPageDataJsonSnapshot sn = DynamicPageDataJsonSnapshot.create(rt);
        LocalDateTime createdTime = (LocalDateTime) rt.get(DynamicConstants.DYNAMIC_SYS_CREATED_TIME);
        LocalDateTime lastUpdatedTime = (LocalDateTime) rt.get(DynamicConstants.DYNAMIC_SYS_LAST_UPDATED_TIME);
        return DynamicPageDataEntity.createForMappingData(
                id,
                snapshot.getPageId(),
                snapshot.getVersion(),
                snapshot.getBusinessType(),
                sn,
                (String) rt.get(DynamicConstants.DYNAMIC_SYS_DOMAIN_ID),
                (String) rt.get(DynamicConstants.DYNAMIC_SYS_LAST_UPDATER_ID),
                (String) rt.get(DynamicConstants.DYNAMIC_SYS_CREATOR_ID),
                createdTime == null ? null : Timestamp.valueOf(createdTime),
                lastUpdatedTime == null ? null : Timestamp.valueOf(lastUpdatedTime),
                jsonProvider
        );
    }
}
