package com.bcxin.tenant.bcx.domains.services.commands.ExamEnrollmentCriterias;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.ExamReferenceType;
import lombok.Getter;

import java.sql.Timestamp;

@Getter
public class CreateExamEnrollmentCriteriaCommand extends CommandAbstract {
    private final ExamReferenceType subjectType;

    private final String subjectNumber;

    private final String name;

    private final String note;

    private final String slug;

    private final String logo;

    private final boolean sync2Identity;

    private final int limitedCount;

    private final String attachment;

    private final Timestamp beginTime;

    private final Timestamp endTime;

    private final boolean enableBPMFlow;

    private final boolean enableAnonymousAccess;

    private final String defaultFormJson;

    public CreateExamEnrollmentCriteriaCommand(String subjectNumber,
                                               String name, String note,
                                               String slug, String logo, boolean sync2Saas, int limitedCount,
                                               String attachment, Timestamp beginTime, Timestamp endTime,
                                               boolean enableBPMFlow, boolean enableAnonymousAccess,
                                               String defaultFormJson) {
        this.subjectType = ExamReferenceType.Subject;
        this.subjectNumber = subjectNumber;
        this.name = name;
        this.note = note;
        this.slug = slug;
        this.logo = logo;
        this.sync2Identity = sync2Saas;
        this.limitedCount = limitedCount;
        this.attachment = attachment;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.enableBPMFlow = enableBPMFlow;
        this.enableAnonymousAccess = enableAnonymousAccess;
        this.defaultFormJson = defaultFormJson;
    }

    public static CreateExamEnrollmentCriteriaCommand create(String subjectNumber,
                                                             String name, String note,
                                                             String slug, String logo, boolean sync2Identity, int limitedCount,
                                                             String attachment, Timestamp beginTime, Timestamp endTime,
                                                             boolean enableBPMFlow, boolean enableAnonymousAccess,
                                                             String defaultFormJson) {
        return new CreateExamEnrollmentCriteriaCommand(subjectNumber, name, note, slug, logo, sync2Identity,
                limitedCount, attachment, beginTime, endTime, enableBPMFlow, enableAnonymousAccess,defaultFormJson);
    }
}
